#include <io.h>
#include <system.h>
#include <stdio.h>
#include "sys/alt_irq.h"
#include <alt_types.h>
#include <math.h>
#include <unistd.h>
#include <fcntl.h>


//READ/WRITE REGISTERS
#define STEER_W(data) IOWR_16DIRECT(PWM_BASE, 0, data)    
#define THROTTLE_W(data) IOWR_16DIRECT(PWM_BASE, 2 , data)   
#define STEER_R() IORD_16DIRECT(PWM_BASE, 0)
#define THROTTLE_R() IORD_16DIRECT(PWM_BASE, 2)  
#define TIMER_R() IORD_16DIRECT(SENSOR_BASE, 4)
#define CLEAR_IRQ() IOWR_16DIRECT(SENSOR_BASE, 2, 0)
#define READ_SENSOR() IORD_16DIRECT(SENSOR_BASE, 0) //in tenths of an inch

// TEST SETTINGS
#define KEYBOARD_CONTROL 0
#define CALIBRATE 0
#define SENSOR_TEST 0
#define FEEDBACK_CONTROL 1

//CONSTANTS
#define CAL_COUNT 101

//FUNCTION PROTOTYPES
void ff();
void throttle_down();
void throttle_up();
int map_to_pwm(int);
void delay(int);
void initialize();
void forward();
void backward();
void left();
void right();
void halt();
void set_throttle(int);
void set_steer(int);
static void sensor_interrupt_handler();
void calibrate();
void keyboard_control();
void sensor_test();
void feedback_control();

//speed and distance variables
int distance = 0;
int time_msec = 0;
int last_distance = -1;
int speed = 0;
//calibration variables
int counter = 0;
int calibrated = 0;
int diff;
int mult;
//global throttle and steering variables
int max_throttle = 780;//820;
int min_throttle = 640;
int max_steer = 820;
int min_steer = 580;
int neutral_steer = 700;
int neutral_throttle = 750;
int current_throttle;
int current_steer;
int previous_throttle;
int previous_steer;
int throttle_increment = 3;
int steer_increment = 5;
int max_throttle_increase = 15;
int max_throttle_decrease = 18;
//feedback variables
int delta_distance;

int stop = 1;
int success = 0;
int cc = 0;

int desired_dist = 20;
int error;
int K_gain = 1;
int K_rate = -2;
int gain_out;
int rate_out;
int throttle_correction;
int error_in_pwm;
int rate_in_pwm;

int vals[15];
int mm = 15;
int gg = 0;
int ss = 0;



/* Bens addition from may 11th */
FILE *fp;
#define RECORDING_LENGTH 2000
short recorded_distance[RECORDING_LENGTH];
short recorded_time[RECORDING_LENGTH];
short dirty_recorded_time[RECORDING_LENGTH];
short recorded_throttle[RECORDING_LENGTH];
short dirty_recorded_distance[RECORDING_LENGTH];

short current_trottle[RECORDING_LENGTH];
short gain[RECORDING_LENGTH];
short rate[RECORDING_LENGTH];








  
short record_index;
short record_index2;
short elapsed_time;
short similar_count = 0;
short latest_results[2][6];
short similar_counter_threshhold = 5;
short no_movement_flag = 0;
short dX,dT;
short flag = 0;
int timeDeltaReading = 0;
short previousSpeed; 
short currentSpeed;
short Fourcount = 0;
int distance_reading = 0;

//SENSOR INTERRUPT HANDLER
static void sensor_interrupt_handler() {
    
    last_distance = distance_reading; 
    distance_reading = READ_SENSOR();
    time_msec = TIMER_R();
    
    //delta_distance = last_distance - distance;
    //speed = delta_distance * 20; //1000/50 e.g. every 50ms
    elapsed_time += time_msec;
    
    
    /*
    if (gg < mm && ss == 1) {
        vals[gg] = distance;
        gg++;
    }
    */

        
  
                        latest_results[0][5] = latest_results[0][4];
                        latest_results[0][4] = latest_results[0][3];
                        latest_results[0][3] = latest_results[0][2];
                        latest_results[0][2] = latest_results[0][1];
                        latest_results[0][1] = latest_results[0][0];
                        latest_results[0][0] = distance_reading;
                        
                        latest_results[1][3] = latest_results[1][2];
                        latest_results[1][2] = latest_results[1][1];
                        latest_results[1][1] = latest_results[1][0];
                        latest_results[1][0] = elapsed_time;
                          
                        if (    ((latest_results[0][1] > latest_results[0][0]) && (latest_results[0][1] > latest_results[0][2]))  ||
                                ((latest_results[0][1] < latest_results[0][0]) && (latest_results[0][1] < latest_results[0][2]))    )
                            {
                                 latest_results[0][1] = (latest_results[0][2] + latest_results[0][0]) / 2;
                            }
                   
                            distance = latest_results[0][1];
                            delta_distance = (int)(10*(
                                                    0.1 * (latest_results[0][5]-latest_results[0][4]) + 
                                                    0.2 * (latest_results[0][4]-latest_results[0][3]) +
                                                    0.3 * (latest_results[0][3]-latest_results[0][2]) +
                                                    0.4 * (latest_results[0][2]-latest_results[0][1])
                                                     
                                                  ));   
                                                     
                            //dT =  latest_results[1][1] - latest_results[1][2];
                            //lets measure speed as a weighted sum. since it cant change thaaaaaatttttt fast.
                            //speed = dX ;
                            //previousSpeed = currentSpeed;
                            //currentSpeed = .25 * previousSpeed + .75 *  speed; // prevent speed readings from being really jerky.
                      
                                                     
                        if (record_index < RECORDING_LENGTH)
                        {
                            recorded_time[record_index2++]         = latest_results[1][1];
                            recorded_distance[record_index2]     = latest_results[0][1];
                            dirty_recorded_distance[record_index]   = distance;
                            dirty_recorded_time[record_index]     = delta_distance;
                            recorded_throttle[record_index] = current_throttle >> 2;
                            gain[record_index] = gain_out;
                            rate[record_index] = rate_out;
                            current_trottle[record_index++] = current_throttle/15;
                            
                            
                        }
    
            
    if (latest_results[0][2] <= distance  && distance_reading < (desired_dist + 20))
            {
                similar_count++;
                
            }
            else
            {   
               
                similar_count = 0;
                
            }
 
            if (similar_count >= 5) 
            {
                
                stop = 1;
                halt();
                success = 1;
            }
           
    
    
    if(FEEDBACK_CONTROL) {
    
        if(stop == 1)
            halt();
        else
            if (Fourcount++ == 4) 
            {
                    Fourcount = 0;
                    feedback_control();
            }
    }
    
    CLEAR_IRQ();   // clear the interrupt   
}

int main()
{  
  latest_results[0][5] = 0;
  latest_results[0][4] = 0; 
  latest_results[0][3] = 0;
  latest_results[0][2] = 0;
  latest_results[0][1] = 0;
  latest_results[0][0] = 0;
  latest_results[1][3] = 0;
  latest_results[1][2] = 0;
  latest_results[1][1] = 0;
  latest_results[1][0] = 0;
  
  fp = fopen("/mnt/host/blah.txt","w");
  fprintf(fp,"recorded_time[w]\t recorded_distance[w] \t dirty_recorded_distance[w] \t dirty_recorded_time[w] \t current_trottle[w] \t rate[w] \t gain[w]\n");
  record_index =2001;
  record_index2 =2001;
  
  elapsed_time=0;
  
  printf("entering ...\n");

  initialize(); //registers sensor interrupt and other stuff
 
  if (CALIBRATE)
      calibrate();
  
  if (KEYBOARD_CONTROL)
      keyboard_control();
 
  if (SENSOR_TEST) 
      sensor_test();
      
  if (FEEDBACK_CONTROL)
      ff();
      //feedback_control();
  
  /*
  set_throttle(max_throttle);
  ss = 1;
  while (gg != mm);
  halt();
  int ii = 0;
  while(ii < mm){
    printf("%d; ", vals[ii]);
    ii++;
  }
  printf("\n");
  */
  
  printf("exiting ...\n");
  
  

  return 0;
}

void ff(){
    //ben
    int w;
    printf("Challenge start\n");
    while(getchar() != 'g');
    stop = 0;
    record_index =0;
    record_index2 =0;
    int j = 5000;
    while(1) {
        
        if(success == 1) {
            printf("Challenge completed\n");
            while(success = 1) {
                delay(1000000);
                printf("dist: %d; throt: %d; delta_dist: %d; error %d; gain %d; rate %d\n", \
                    distance, current_throttle, delta_distance, error, gain_out, rate_out);
                //ben:
                //this code should be moved elsewher
                //if(getchar() == 'w') { // dump datalog the data to the file
                    printf("Dumping data to file\n");
                    for(w=0;w<record_index;w++)
                    {
                        fprintf(fp,"%d \t %d \t %d \t %d \t %d \t %d \t %d\n ",recorded_time[w],recorded_distance[w],dirty_recorded_distance[w],dirty_recorded_time[w],current_trottle[w],rate[w],gain[w]);
                    }     
                    fclose(fp);
                    cc = 0;
                    success = 0;
                    stop = 0;    
                    
                //}
                while(1) {
                    if(getchar() == 'g') {
                        printf("Restart challenge\n");
                        cc = 0;
                        success = 0;
                        stop = 0;
                        break;
                    }
                }
                
            }
        }
        j--;
        if(j==0) {
            
            printf("dist: %d; throt: %d; delta_dist: %d; error %d; gain %d; rate %d\n", \
                distance, current_throttle, delta_distance, error, gain_out, rate_out);
            j = 5000;
        }
        if(getchar() == 'v') {
            stop = 1;
            printf("Halted\n");
            while(getchar() != 'g');
            printf("Resumed\n");
            stop = 0;
        }
        
    }
}

void feedback_control() {    
    //printf("Feedback control\n");
    
    

        
    //while(getchar() != 'g');
    
    //while(1) { 
    
        //delay(200000);
             
        error = distance - desired_dist;
        int error_abs = fabs(error);
        error_in_pwm = (error * 100) >> 7; //error as percentage of 128 (2^7) +. results in 0 to .1% duty cycle
        if(delta_distance >= 0) {
            
            if (error != 0)
                rate_in_pwm =  (delta_distance * 100) / error_abs;
            else
                rate_in_pwm =   (delta_distance * 100) / 1;
        }
        else {
            rate_in_pwm = 0;
            //
            
        }
        /*
        if(error_abs < 5) {
            cc++;
            if(cc == 10) {
                halt();
                stop = 1;
                success = 1;
                return;
            }
        }
        else {
            cc = 0;
        }
        */
        
        gain_out = K_gain * error_in_pwm;
        rate_out = K_rate * rate_in_pwm;
        
        
        throttle_correction = gain_out + rate_out; 
        current_throttle += throttle_correction;
        set_throttle(current_throttle);
        
        //printf("dist: %d; throt: %d; delta_dist: %d; error %d; err_pwm %d; rate_pwm %d\n", \
            distance, current_throttle, delta_distance, error, error_in_pwm, rate_in_pwm);
        
        /*   
        if (error == 0)
            cc++;
        else
            cc = 0;
        if (cc == 10) {
            success = 1;
            //printf("Challenge completed\n");
            //break;
        }
        */
        
        /*
        if(getchar() == 'v') {
            halt();
            printf("Halted\n");
            while(getchar() != 'g');
        }
        */
    //}
}

int map_to_pwm(int g) {
    return 0;
}

void calibrate() {
    while(1) {
            printf("Dist: %d, neutral throttle %d, read throt %d \n", distance, neutral_throttle, THROTTLE_R());
            if (calibrated == 1) {
                printf("Calibrated. %d \n", neutral_throttle); 
                break;
            }
            
            int j = 0;
            while (j != 100000) {
                j++;
            }
    }
}

void keyboard_control() {
      printf("a, d, w, s, v: \n");
      char c;
      //fcntl(STDIN_FILENO, F_SETFL, O_NONBLOCK);
      for(;;) {    
          switch(c = getchar()) {
              case 'a':   
                 left(); 
                 break;
              case 'd':
                 right();   
                 break;
              case 'w': 
                 forward();  
                 break; 
              case 's':
                 backward();
                 break;
              case 'v':
                  halt();
                  break;  
              default:
                  continue;      
          }
          printf("Steering: %d; throttle: %d\n", current_steer, current_throttle);
      }
}

void sensor_test() {
    for(;;){
        int i = 1000000;
        while (i--);
        printf("D %d; T %d; S %d\n", distance, time_msec, speed);
      }
}

void set_throttle(int t) {
    if (t > previous_throttle + max_throttle_increase) 
        current_throttle = previous_throttle + max_throttle_increase;
    else if (t < previous_throttle - max_throttle_decrease) 
        current_throttle = previous_throttle - max_throttle_decrease;
    else current_throttle = t;
    
    if (current_throttle > max_throttle) 
        current_throttle = max_throttle;
    else if (current_throttle < min_throttle) 
        current_throttle = min_throttle;
        
    previous_throttle = current_throttle;
    THROTTLE_W(current_throttle);
}

void set_steer(int s) {
    if (s > max_steer) current_steer = max_steer;
    else if (s < min_steer) current_steer = min_steer;
    else current_steer = s;
    STEER_W(current_steer);
}

void throttle_up() {
    set_throttle(current_throttle += 1);
}

void throttle_down() {
    set_throttle(current_throttle -= 1);
}

void forward() {
    set_throttle(current_throttle += throttle_increment);
}

void backward() {
    set_throttle(current_throttle -= throttle_increment);
}

void left() {
    set_steer(current_steer -= steer_increment);
}

void right() {
    set_steer(current_steer += steer_increment);   
}

void halt() {
    previous_throttle = neutral_throttle;
    set_throttle(current_throttle = neutral_throttle);
    set_steer(current_steer = neutral_steer);
}

void initialize() {
    int r = alt_irq_register(SENSOR_IRQ, NULL, (void*) sensor_interrupt_handler);
    printf("registered interrupt handler: %d\n", r);
    fcntl(STDIN_FILENO, F_SETFL, O_NONBLOCK);
    previous_throttle = neutral_throttle;
    previous_steer = neutral_steer;
    halt();
    delay(1000000);
}

void delay(int i) {
    while(i--);
}
