library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity sensor_unit is
  
  port (
-- Avalon Bus / CPU interface: 
 
    clk        : in  std_logic;
    reset_n    : in  std_logic;
    read       : in  std_logic;
	write	   : in  std_logic;
    chipselect : in  std_logic;
    address    : in  unsigned(1 downto 0);
	writedata  : in  unsigned(15 downto 0);
    readdata   : out unsigned(15 downto 0);	
	irq		   : out std_logic; --interrupt signal
	
	pulse      : in std_logic	-- from the GPIO
	);
  
end sensor_unit;

architecture rtl of sensor_unit is

  signal data  : unsigned(15 downto 0);
  signal interrupt : std_logic;
  signal count : unsigned(15 downto 0);
  signal inches  : unsigned(15 downto 0);
  signal raise : std_logic;
  signal start : std_logic;

  signal count_to_1_msec : unsigned(15 downto 0);
  signal time_in_msec : unsigned(15 downto 0);
  signal timer : unsigned (15 downto 0);
  signal msec_timer_reset : std_logic;

begin

  irq <= interrupt;

  process (clk)
  begin
    if rising_edge(clk) then
		 if reset_n = '0' then			
     		  readdata <= (others => '0');
			  interrupt <= '0';
		 else 
			  if chipselect = '1' then
					if address = "00" then
						if read = '1' then 
							readdata <= data;
						end if;
					elsif address = "01" then
						if write = '1' then
							interrupt <= writedata(0);
						end if;
					elsif address = "10" then
						if read = '1' then
							readdata <= timer;
						end if;
					end if;
		      else
				  if raise = '1' then
					  interrupt <= '1'; 
				  end if;		  
			  end if;
         end if; 
    end if; 
  end process;

  process (clk)
  begin
    if rising_edge(clk) then
           
      if reset_n = '0' then 	  
          count <= x"0000";	
		  raise <= '0';
		  start <= '0';
		  data <= x"0000";
		  inches <= x"0000";
		
		  timer <= x"0000";
		  msec_timer_reset <= '1';
	  else
			if pulse = '1' then
				start <= '1'; 
				if count = 7339 then -- 733 for .1 inch sensitivity; 7339 for 1 inch sensitivity
					inches <= inches + 1;
					count <= x"0000";
				else
					inches <= inches;
					count <= count + 1;
				end if;
				raise <= '0';
				data <= data;	
				
				timer <= timer;
				msec_timer_reset <= '0';
			elsif start = '1' then
				start <= '0';
				data <= inches;
				raise <= '1';
				inches <= x"0000";
				count <= x"0000";
				
				timer <= time_in_msec;
				msec_timer_reset <= '1';
			else
				inches <= x"0000";
				data <= data;
				count <= x"0000";
				start <= '0';
				raise <= '0';
				
				timer <= timer;
				msec_timer_reset <= '0';
			end if;
	    end if;
      end if;      
    
  end process;
  
  msec_timer: process(clk)
  begin
	if rising_edge(clk) then
		if msec_timer_reset = '1' then
			time_in_msec <= x"0000";
			count_to_1_msec <= x"0000";
		else
			if count_to_1_msec = 49999 then
				count_to_1_msec <= x"0000";
				time_in_msec <= time_in_msec + 1;
			else
				time_in_msec <= time_in_msec;
				count_to_1_msec <= count_to_1_msec + 1;
			end if;
		end if;
	end if;
  end process msec_timer;

end rtl;
