--
-- DE2 top-level module that includes the simple VGA raster generator
--
-- Stephen A. Edwards, Columbia University, sedwards@cs.columbia.edu
--
-- From an original by Terasic Technology, Inc.
-- (DE2_TOP.v, part of the DE2 system board CD supplied by Altera)
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity car_top is

  port (
    -- Clocks
    
    CLOCK_27,                                      -- 27 MHz
    CLOCK_50,                                      -- 50 MHz
    EXT_CLOCK : in std_logic;                      -- External Clock
	
	--Expansion Header
	
	GPIO_0,                                      -- GPIO Connection 0
    GPIO_1 : inout std_logic_vector(35 downto 0); -- GPIO Connection 1   

    -- SRAM
    
    SRAM_DQ : inout std_logic_vector(15 downto 0); -- Data bus 16 Bits
    SRAM_ADDR : out std_logic_vector(17 downto 0); -- Address bus 18 Bits
    SRAM_UB_N,                                     -- High-byte Data Mask 
    SRAM_LB_N,                                     -- Low-byte Data Mask 
    SRAM_WE_N,                                     -- Write Enable
    SRAM_CE_N,                                     -- Chip Enable
    SRAM_OE_N : out std_logic;                     -- Output Enable
    
    signal LEDR : out std_logic_vector(17 downto 0) -- Red LEDs

    );
  
end car_top;

architecture datapath of car_top is

 
  signal reset_n : std_logic;

begin

  LEDR(17) <= '1';
  LEDR(16) <= '1';


  nios: entity work.car_nios_sys port map (
    reset_n => '1',
    clk => CLOCK_50,

    SRAM_ADDR_from_the_sram      => SRAM_ADDR,
    SRAM_CE_N_from_the_sram      => SRAM_CE_N,
    SRAM_DQ_to_and_from_the_sram => SRAM_DQ,
    SRAM_LB_N_from_the_sram      => SRAM_LB_N,
    SRAM_OE_N_from_the_sram      => SRAM_OE_N,
    SRAM_UB_N_from_the_sram      => SRAM_UB_N,
    SRAM_WE_N_from_the_sram      => SRAM_WE_N,

	-- WIRES
	--ground: white/orange
	--3.3v: orange
	--steering:  blue
	--throttle: brown
	--sensor: green
	
	steering_pwm_from_the_pwm_unit2    => GPIO_1(2), 
    	throttle_pwm_from_the_pwm_unit2    => GPIO_1(4),
	servo_pwm_from_the_pwm_unit2	     => GPIO_1(6),

	pulse_to_the_sensor			 => GPIO_1(0) -- sensor wire - GREEN

  );
  
 
end datapath;
