library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity UcLinuxSensorUnit is
  
  port (
-- Avalon Bus / CPU interface: 
 
    	clk        : in  std_logic;
    	reset_n    : in  std_logic;
    	read       : in  std_logic;
	write	   : in  std_logic;
    	chipselect : in  std_logic;
    	address    : in  unsigned(3 downto 0);
	writedata  : in  unsigned(15 downto 0);
    	readdata   : out unsigned(15 downto 0);	
	pulse      : in std_logic	-- from the GPIO_1[0];
	);
  
end UcLinuxSensorUnit;

architecture rtl of UcLinuxSensorUnit is

  signal data  	 	: unsigned(15 downto 0);
  signal timeDelta  	: unsigned(15 downto 0);
  signal newData	: unsigned(15 downto 0);

  signal count : unsigned(15 downto 0);
  signal inches  : unsigned(15 downto 0);
  signal raise : std_logic;
  signal start : std_logic;
  signal msTimerEnabled : std_logic;


	--- Timer Signals ---
	signal  count_to_1_msec	 : integer range 0 to 100000; --was 50,000	
	
	signal  time_in_msec	 :  unsigned(31 downto 0);
	signal  time_in_sec      :  unsigned(31 downto 0);  
	
	signal 	msec_timer_enabled	: std_logic;
	signal 	msec_timer_reset	: std_logic;
	


begin

  --irq <= interrupt;

  process (clk)
  begin
    if rising_edge(clk) then
	
		   if chipselect = '1' then
					if read = '1' then
							if address = "0000" then 		-- they want the data
								readdata <= data;	
								timeDelta <= time_in_msec(15 downto 0);	-- record the time of the reading. 
								msec_timer_reset <= '1';
							else 
								msec_timer_reset <= '0';
								if address = "0001" then		-- they want the time elapsed since last reading.
									readdata <= timeDelta;
									newData <= x"0000";	
								
								elsif	address = "0010" then		-- they want to know if there is a new signal... 
									readdata <=  newData;
								
								elsif	address = "0011" then		-- sanity check. 
									readdata <=  x"1111";
								end if;
							end if;
					end if;
		      	  end if;
         	end if; 


	if (raise = '1') then 
		newData <= x"0001"; 
	end if;
	
  end process;



-- Professor edwards expressed the need to have 1 clock. so here it is
-- this is just a timer ciruit with external reset and enable signals. 
  	msec_timer : process (clk)
	begin
	if rising_edge(clk) then
		if (msec_timer_reset = '1') then -- reset rules.
		    time_in_sec <= x"00000000";
		    time_in_msec <= x"00000000";
		    count_to_1_msec <= 0;
	else
   			if count_to_1_msec = 99999 then -- 50,000,000 / 50,000 = 1000 = 1 msec.
			         count_to_1_msec <= 0;
				         -- WANT TO DO SOMETHING EACH MS? DO IT HERE.
				 if time_in_msec = 999 then
				 	time_in_msec <=  x"00000000";
				 	time_in_sec <= time_in_sec + 1; 
				 else
				 	time_in_msec <= time_in_msec + 1;
				 end if;
			else	-- regular case. just keep counting. 
				count_to_1_msec <= count_to_1_msec + 1;
			end if;			
	end if;
	end if; -- if rising_edge(clk) then	
	end process msec_timer;  






	process (clk)
	begin
    	if rising_edge(clk) then
    		if reset_n = '0' then 	  
          		count <= x"0000";	
			raise <= '0';
			start <= '0';
			data <= x"0000";
			inches <= x"0000";
	  	else
			if pulse = '1' then	--this signal is raised when the sensor begins evaluating the distance to a target.
				start <= '1'; 
				if count = 14680 then --.1 inch sensitivity; 7339 for 1 inch sensitivity
					inches <= inches + 1;
					count <= x"0000";
				else
					inches <= inches;
					count <= count + 1;
				end if;
					
			elsif start = '1' then
				--timeDelta <= time_in_msec(15 downto 0);				
				--msec_timer_reset <= '1';
				--msTimerEnabled <='0';
				start <= '0';
				data <= inches;
				raise <= '1';
				inches <= x"0000";
				count <= x"0000";
			else
				--msTimerEnabled <= '1';
				--msec_timer_reset <= '0';				
				inches <= x"0000";
				data <= data;
				count <= x"0000";
				start <= '0';
				raise <= '0';
			end if;
	    end if;
      end if;      
  end process;  
end rtl;
