library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity pwm_unit is
  
  port (
-- Avalon Bus / CPU interface: 
 
    clk        : in  std_logic;
    reset_n    : in  std_logic;
    read       : in  std_logic;
    write      : in  std_logic;
    chipselect : in  std_logic;
    address    : in  unsigned(1 downto 0); 	-- so far, no need for more than 4 different registers. we only need 2 actually. 
    writedata  : in  unsigned(15 downto 0);
    readdata   : out unsigned(15 downto 0);	

-- pwm outputs
    steering_pwm : out std_logic; 
    throttle_pwm : out std_logic;
    servo_pwm : out std_logic    
);
  
end pwm_unit;

architecture rtl of pwm_unit is

-------------------------------------------------------Software----------------------------------------------
  type ram_type is array(2 downto 0) of unsigned(15 downto 0);
  signal RAM : ram_type;
  signal ram_address: unsigned(1 downto 0);
  signal rdy_signal: std_logic;
-------------------------------------------------------Hardware--------------------------------------------------
  signal  count       : integer range 0 to 1000 := 0 ;
  signal  pwm_count   : integer range 0 to 10000 := 0 ;
  signal 	pwm_clk     : std_logic; 
----------------------------------------------------------------------------------------------------------------
begin
------------------------------ Software interface side -------------------------------------------------------------------------------- 

-- simple concept: make the software interface like memory! 
  ram_address <= address(1 downto 0);

  process (clk)
  begin
    if rising_edge(clk) then
		    if reset_n = '0' then
     			  readdata <= (others => '0');
					RAM(0) <= x"0000"; 				--Steering
					RAM(1) <= x"0000"; 				--Throttle
					RAM(2) <= x"0000"; 				--Servo
					
		    else 
			     if chipselect = '1' then
				      if write = '1' then
						      RAM(to_integer(ram_address)) <= writedata; -- 0 Steering 1 Throttle.
				      elsif read = '1' then 
							  readdata <= RAM(to_integer(ram_address));
				      end if;
					 end if; -- chipselect = 1;
        end if; -- reset_n
  end if; -- risinf edge... 
end process;

----------------------------Hardware interface side --------------------------------------------------------------------------------------
-- Create a PWM clock. 500,000HZ. 
 Counter : process (clk)
  begin
    if rising_edge(clk) then      
      if reset_n = '0' then 
       
               count <=  0;
               pwm_clk <= '0';
                       
      elsif count = 49 then 
         
               count <= 0;
               pwm_clk <= not pwm_clk;     
        
      else
               count <= count + 1;
      end if;      
    end if;
  end process Counter;  
  
--Count 10000 steps for each clock cycle. for 0.01% increments of duty cycle.  
  pwm_clock : process (clk)
      begin
          if rising_edge(clk) then 
			if pwm_clk = '1' then
              if reset_n = '0' then
                  pwm_count <= 0;
               elsif pwm_count = 9999 then -- should be 9999 to generate 50Hz PWM. 
                  pwm_count <= 0;
               else
                  pwm_count <= pwm_count + 1;
               end if;  
			end if;
		  end if ;
   end process ;          
  
--Based in the Duty cycle register (RAM(0)) create a wave for the steering controls.
   steering_pwm_generate : process (clk)
      begin
			if pwm_clk = '1' then
				if pwm_count < RAM(0)  then -- duty cycle : 0 - 9999, so can control .01 of a % 
					  steering_pwm <= '1';
				else 
					  steering_pwm <= '0';
				end if;   
			end if;
       end process ;        

--Based in the Duty cycle register (RAM(1)) create a wave for the Throttle controls.
   throttle_pwm_generate : process (clk)
      begin
			if pwm_clk = '1' then
				if pwm_count < RAM(1)  then -- duty cycle : 0 - 9999, so can control .01 of a % 
					throttle_pwm <= '1';
				else 
					throttle_pwm <= '0';
				end if;   
			end if;   
       end process ;        

--Based in the Duty cycle register (RAM(2)) create a wave for the Servo controls.
   servo_pwm_generate : process (clk)
      begin
			if pwm_clk = '1' then
				if pwm_count < RAM(2)  then -- duty cycle : 0 - 9999, so can control .01 of a % 
					  servo_pwm <= '1';
				else 
					  servo_pwm <= '0';
				end if;  
			end if
       end process ;        
-----------------------------------------------------------------------------------------------------------------------

end rtl;
