

#include <stdio.h>
#include <math.h>
#include <string.h>

#include<unistd.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<fcntl.h>

#include <asm/io.h>
#include <asm/uaccess.h>
#include <asm/system.h>
#include <linux/delay.h>

#include "nios2_system.h"    /* Descriptions of standard peripherals */

#define DCT_BASE 0x80681100
#define CAR_BASE 0x80681180
#define STEERING_BASE 0x806812b0
#define THROTTLE_BASE 0x80681184



#define MAX_DELTA 3


FILE *fp;
int distReading =0;
int timeDeltaReading = 0;
int timeReading = 0;
unsigned int x ;
short prevReading = 0;
short flag;
short similar_count;



readSensor()
{
	// minimal filtering. just get the reading and report it back. if its too big, put 255.
	x=0;
	
	while((*(volatile short*)(CAR_BASE+8)) == 0)
		{
			x++;
			if (x>999999)
			{
				printf("timed out waiting for rdy signal\n");
				break;	
			}
		}
		if (x < 10000) printf("performance warning: software close to lagging behind hw! x: %d\n",x);
	
		prevReading = distReading;
		distReading = (*(volatile int*)(CAR_BASE)); 
		timeReading = (*(volatile short*)(CAR_BASE+4)); 
		
		if (distReading > 255) distReading = 255;
		//fprintf(fp,"raw reading: %d\n",distReading); 
}


int main(void)
{

	//remove later:
	int elapsedtime = 0;
	short flag_raised =0;
	
	fp = fopen("out.txt", "w");
	short latest_results[2][4];
	
	float speed,currentSpeed,previousSpeed;
	short previous_reading_dropped = 0;
	
	//program startup. must calibrate.
	int done =0;
	int i;
	int sum;

		// reading delta of more than 3 seems unreasonable. at 20 readings per sec, that suggests a speed of 20*3*2.5/100 = 1.5 m/sec 
		// the car is moving forward, well thats at least what we are interested in. 
		// so, reading should be decreasing.		
	
	int delta1,delta2,delta3;
	short maxDelta = MAX_DELTA;		



	int w=0;
	for(i=0;i<4;i++) //fill the array with some data...
	{
		//getCurrentDistance();
		readSensor();
		latest_results[0][i] = distReading;;		
	}
		
	short similar_counter_threshhold = 5;
	short no_movement_flag = 0;

	short delta01,delta02,delta12,timeDelta;
	


	short dX,dT;









while(w++ < 600)
{
		flag_raised =0;
		//getCurrentDistance();
		x=0;
		flag = 0;
		
		timeDeltaReading =0;
		while(!flag) // there is a problem that two consectutive readings are the same if car is not moving fast. so, lets eliminate some of those.
		{
			readSensor();
			if (prevReading == distReading)
			{
				similar_count++;
				no_movement_flag = 1;
			}
			else
			{	
				flag = 1;
				similar_count = 0;
				similar_counter_threshhold = 5;
				no_movement_flag = 0;
			}
			if (similar_count > 0)
				timeDeltaReading += timeReading;	 
			else
				timeDeltaReading = timeReading; 

			if (similar_count > similar_counter_threshhold) 
			{
				
				flag = 1;
				//printf("similar_count > 10\n");
				//report speed every 6 readings even if car not moving.
				similar_counter_threshhold+=5;
				
			}
		}

		//observation: similar reading are possible while the car is moving. but, even at the slowest speeds similar reading are smaller than 5:
		
		elapsedtime += timeDeltaReading;
		fprintf(fp,"%d\t%d\t",elapsedtime,distReading);
		//if (similar_count > 0) fprintf(fp,"detected similar reading count: %d which lasted for %d\n",similar_count,timeDeltaReading);
		
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	//why use the present? lets use the future.
	latest_results[0][3] = latest_results[0][2];
	latest_results[0][2] = latest_results[0][1];
	latest_results[0][1] = latest_results[0][0];
	latest_results[0][0] = distReading;
	
	latest_results[1][3] = latest_results[1][2];
	latest_results[1][2] = latest_results[1][1];
	latest_results[1][1] = latest_results[1][0];
	latest_results[1][0] = elapsedtime;

	if (no_movement_flag)
		speed = -1;
	else
	{
		// the results must be filtered more. 
		// simplelest way is to get rid of parabula peaks i.e. the point is bigger than previous and next by a big factor. 
		

			//this	reading		//next	reading		//this	reading		//previous reading
		if (  	((latest_results[0][1] > latest_results[0][0]) && (latest_results[0][1] > latest_results[0][2]))  ||
		      	((latest_results[0][1] < latest_results[0][0]) && (latest_results[0][1] < latest_results[0][2]))  	)
		//then
			{
				flag_raised =1;
				latest_results[0][1] = (latest_results[0][2] + latest_results[0][0]) / 2;
			}
			
		dX =  latest_results[0][2] - latest_results[0][1];
		dT =  latest_results[1][1] - latest_results[1][2];
		//lets measure speed as a weighted sum. since it cant change thaaaaaatttttt fast.
		speed = (dX * 1000)/dT ;
		previousSpeed = currentSpeed;
		currentSpeed = .25 * previousSpeed + .75 *  speed; // prevent speed readings from being really jerky.
		 



		/*
		delta01 = latest_results[0][1] - latest_results[0][0]; 		
		if (delta01 < 0) delta01 = -delta01;
		delta12 = latest_results[0][2] - latest_results[0][1]; 
		if (delta12 < 0) delta12 = -delta12;
		delta02 = latest_results[0][2] - latest_results[0][0];
		if (delta02 < 0) delta02 = -delta02;

		if (delta12 > maxDelta)
		{
			if (delta12 > delta02) 
				latest_results[0][1] = latest_results[0][0]+latest_results[0][2]/2;
		}
		

		delta12 = latest_results[0][1] - latest_results[0][2]; 
		if (delta12 < 0) delta12 = -delta12;
		
		
		timeDelta = (latest_results[1][1] - latest_results[1][2]) ;
		speed = (delta12 *1000)/ (timeDelta);
	*/
	}
	if (flag_raised)
		fprintf(fp,"\t%d\t%d",latest_results[0][1],155); //this will signal an err on the graph. 
	else
		fprintf(fp,"\t%d\t",latest_results[0][1]);
	
	fprintf(fp,"\t%d\t%d\t%f\t%f\n",dX,dT,speed,currentSpeed);
	printf("speed = %f\n",currentSpeed);
	//fprintf(fp,"%d\t%d\t",elapsedtime,distReading);
	//fprintf(fp,"%f\t%d\t%d\n",speed,delta12,timeDelta);
	}//end of while loop.

	fclose(fp);
	}


