library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity yuv2rgb is
  port (
     -- 31         0
     -- y   u   y  v
     yuv : in unsigned (31 downto 0):=x"00000000"; 
     -- r:5 g:6 b:5
     rgb : out unsigned (15 downto 0):=x"0000"
  );
end yuv2rgb;

architecture y2r of yuv2rgb is
signal y: integer := 0;
signal u: integer := 0;
signal v: integer := 0;
signal r: integer := 0;
signal g: integer := 0;
signal b: integer := 0;


begin
  r <= y*298+v*409+128;
  g <= y*298-u*100-v*208+128;
  b <= y*298+u*516+128;

  y <= to_integer(yuv(31 downto 24))-16;
  u <= to_integer(yuv(7 downto 0))-128;
  v <= to_integer(yuv(23 downto 16))-128;

  rgb(15 downto 11) <= "11111" when r > 65535 else
                       "00000" when r < 0 else
                       to_unsigned(r/2048, 5);
  rgb(10 downto 5) <= "111111" when g > 65535 else
                      "000000" when g < 0 else
                      to_unsigned(g/1024, 6);
  rgb(4 downto 0) <= "11111" when b > 65535 else
                     "00000" when b < 0 else
                     to_unsigned(b/2048, 5);
end y2r;
