library IEEE;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity line_buffer is
  port (
    reset	  : in std_logic;
    wclk	  : in std_logic;
    rclk	  : in std_logic;
    write_enable  : in std_logic;
    write_data	  : in unsigned(15 downto 0);
    write_address : in unsigned(8 downto 0);
    read_data	  : out unsigned(15 downto 0);
    read_address  : in unsigned(8 downto 0);
    -- page = 0: write to line1, read from line2
    -- page = 1: write to line2, read from line1
    page          : in std_logic
  );
end line_buffer;

architecture RTL of line_buffer is

  type ram_type is array(0 to 450) of unsigned(15 downto 0);

  signal line1: ram_type;
  signal line2: ram_type;

begin

  WriteLine : process (wclk)
  begin
    if rising_edge(wclk) then
      if reset = '1' then
        line1 <= (others => x"0000");
        line2 <= (others => x"0000");
      elsif write_enable = '1' then
        if page = '0' then
          line1(to_integer(write_address)) <= write_data;
        else
          line2(to_integer(write_address)) <= write_data;
        end if;
      end if;
    end if;
  end process;

  ReadLine : process (rclk)
  begin
    if rising_edge(rclk) then
      if page = '0' then
        read_data <= line2(to_integer(read_address));
      else
        read_data <= line1(to_integer(read_address));
      end if;
    end if;
  end process;

end RTL;
