#include <stdio.h>
#include <stdlib.h>
#include <system.h>
#include <sys/alt_dma.h>
#include <io.h>
#define ROW 200
#define COL 320


#define TARGET_R 200
#define TARGET_G 100
#define TARGET_B 70


#define BLOCK_SIZE 16
#define PIC_THRESHOLD 30
#define BLOCK_THRESHOLD 180

#define OFFSET(i,j) ((i<<8)+(i<<6))+j // i*COL+j

//get most significant 5 bits, and return a byte
#define GET_R(color) (unsigned char)((color&0xF800)>>8)
//get least significant 5 bits, and return a byte
#define GET_B(color) (unsigned char)((color&0x001F)<<3)
//get the middle 6 bits,5-6-5,from color, and return a byte
#define GET_G(color) (unsigned char)((color&0x07E0)>>3)
//X / 5 = X/(4+1) = (X/4) /(1+1/4)= (X/4) * (1 - 1/4 + 1/16 - 1/64 + 1/256 ...)
//      = X/4 - X/16 + X/64 - X/256 + X/1024 - X/4096 ...
#define DIV(x) (unsigned char)((x>>2)-(x>>4)+(x>>6)-(x>>8))
#define CONVERT(r,g,b) (unsigned char)(DIV(((r>>2)+(g<<4))-(b)))
#define IOWR_SDRAM(base, data) IOWR_16DIRECT(base, 0, data)
#define IORD_SDRAM(base) IORD_16DIRECT(base, 0)

inline void comp(int *pt_r,int *pt_c);

void get_obj_def(short *buf, 
        int center_row,int center_col,
        unsigned char *val_r,
        unsigned char *val_g, unsigned char *val_b);

void get_obj_val_rgb(short *buf, 
		int center_row,int center_col,
		unsigned char *val_r,
		unsigned char *val_g, unsigned char *val_b);

void get_obj_val(short *buf, 
		int center_row,int center_col,
		unsigned char *cval);
void track_obj ( short *buf, int center_row, int center_col, 
         int *new_center_row, int *new_center_col);

void track_obj2 ( short *buf, int center_row, int center_col, 
		 int *new_center_row, int *new_center_col);
void track_obj3 ( short *buf, int center_row, int center_col, 
         int *new_center_row, int *new_center_col, short *color);
void track_obj4 ( short *buf, int center_row, int center_col, 
         int *new_center_row, int *new_center_col);