function seed_gen( A, n, N )

num = 0;
j = 1;

file_id = fopen('seeds.txt', 'w');

fprintf(file_id, 'constant ROM : rom_type := (');

for i=1:n*N  
    lfsr_32bit_num = floor((i-1)/32);

    if (mod(lfsr_32bit_num,4096) == 0)
        if (mod((i-1), 4096*32) == 0)
            j = 1;
            num = uint32(0);
        else
            j = j+1;
        end
    
        row_index = (floor((i-1)/N)+1);
        col_index = (mod(i-1,N)+1);
        bit = A(row_index,col_index);
        num = uint32(num*2 + floor((bit+1)/2));
        
        if (mod((i-1), 4096*32) == 31)
            fprintf(file_id, 'X"%s", ',dec2hex(num, 8));
        end
    end
end
 
fprintf(file_id, ');');

fclose(file_id);