function [ A, top, left ] = lfsr( seed, n, N )
%LFSR Summary of this function goes here
%   Detailed explanation goes here

lfsr_size = 32;

reg = uint32(seed);
limit = (n*N) / lfsr_size;
i=1;
j=0;

A = int8(zeros(n, N));
%size(A)
top = uint32(zeros(N/lfsr_size,1));
left = uint32(zeros(n,1));

while (i <= N / lfsr_size)
    for (k=0:lfsr_size-1)
        a = uint32(bitand(reg, uint32(hex2dec('0001'))));
        b = uint32(bitshift(bitand(reg, uint32(2^10)),-10));
        c = uint32(bitshift(bitand(reg, uint32(2^30)),-30));
        d = uint32(bitshift(bitand(reg, uint32(2^31)),-31));
        bit = bitxor(bitxor(a, b), bitxor(c, d));
        reg = uint32(bitor(uint32(bitshift(reg, -1)),bitshift(bit,lfsr_size-1)));
    end
    
    top(i) = reg;
    
    i = i+1;
end

i = 1;

while (i <= n)
    for (k=0:lfsr_size-1)
        a = uint32(bitand(reg, uint32(hex2dec('0001'))));
        b = uint32(bitshift(bitand(reg, uint32(2^10)),-10));
        c = uint32(bitshift(bitand(reg, uint32(2^30)),-30));
        d = uint32(bitshift(bitand(reg, uint32(2^31)),-31));
        bit = bitxor(bitxor(a, b), bitxor(c, d));
        reg = uint32(bitor(uint32(bitshift(reg, -1)),bitshift(bit,lfsr_size-1)));
    end
    
    left(i) = reg;
    
    i = i+1;
end

for y=1:n
   left_num = left(y);
   
   for x=1:(N/lfsr_size)
       top_num = top(x);

       for i=1:32
           top_bit = bitand(bitshift(top_num, 1-i),1);
           left_bit = bitand(bitshift(left_num, 1-i),1);
           
           A(y, (x-1)*lfsr_size + i) = 2*int8(bitxor(top_bit,left_bit)) - 1 ;
           %x
          % y
       end
   end
end

save 'A_4096_by_16384.mat' A;
exit

%for j=0:lfsr_size-1
%        index = i*lfsr_size + j;
%        
%        x = floor(index/N) + 1;
%        y = mod(index, N) + 1;
%        
%        v1 = uint32(bitshift(reg,-j));
%        v2 = bitand(v1, uint32(1));
%        v3 = bitshift(v2, 1);
%        
%        A(x,y) = int8(v3) - 1;
%    end
