function [ A ] = lfsr( size, seed, n, N )
%LFSR Summary of this function goes here
%   Detailed explanation goes here

lfsr_size = 32;

reg = uint32(seed);
limit = (n*N) / lfsr_size;
i=0;
j=0;

A = int32(zeros(n, N));
top = uint32(zeros(N/lfsr_size));
left = uint32(zeros(n/lfsr_size));

while (i < limit)
    for (k=0:lfsr_size-1)
        a = uint32(bitand(reg, uint32(hex2dec('0001'))));
        b = uint32(bitshift(bitand(reg, uint32(2^10)),-10));
        c = uint32(bitshift(bitand(reg, uint32(2^30)),-30));
        d = uint32(bitshift(bitand(reg, uint32(2^31)),-31));
        bit = bitxor(bitxor(a, b), bitxor(c, d));
        reg = uint32(bitor(uint32(bitshift(reg, -1)),bitshift(bit,lfsr_size-1)));
    end
    
    for j=0:lfsr_size-1
        index = i*lfsr_size + j;
        
        x = floor(index/N) + 1;
        y = mod(index, N) + 1;
        
        v1 = uint32(bitshift(reg,-j));
        v2 = bitand(v1, uint32(1));
        v3 = bitshift(v2, 1);
        
        A(x,y) = int8(v3) - 1;
    end
    
    i = i+1;
end