function [ A ] = lfsr( size, seed, n, N )
%LFSR Summary of this function goes here
%   Detailed explanation goes here

reg = uint16(seed);
limit = (n*N) / 16;
i=0;
j=0;

A = zeros(n, N);

while (i < limit)
    a = uint16(bitand(reg, uint16(hex2dec('0001'))));
    b = uint16(bitshift(bitand(reg, uint16(hex2dec('0004'))),-2));
    c = uint16(bitshift(bitand(reg, uint16(hex2dec('0008'))),-3));
    d = uint16(bitshift(bitand(reg, uint16(hex2dec('0020'))),-5));
    bit = bitxor(bitxor(a, b), bitxor(c, d));
    reg = uint16(bitor(uint16(bitshift(reg, -1)),bitshift(bit,15)));
    
    for j=0:15
        index = i*16 + j;
        
        A(floor(index/N)+1, mod(index, N)+1) = int8(bitshift(bitand((uint16(bitshift(reg,-j))),uint16(1)),1)) - 1;
    end
    
    i = i+1;
end
