function [ A, top, left ] = lfsr( seed, n, N )
% Generates an nxN random matrix A using LFSRs

lfsr_size = 32;
reg = uint32(seed);
limit = (n*N) / lfsr_size;
i=0;
j=0;

A = zeros(n, N);

while (i <= limit)
    for k=1:32  
        a = uint32(bitand(reg, uint32(hex2dec('0001'))));
        b = uint32(bitshift(bitand(reg, uint32(2^10)),-10));
        c = uint32(bitshift(bitand(reg, uint32(2^30)),-30));
        d = uint32(bitshift(bitand(reg, uint32(2^31)),-31));
        bit = bitxor(bitxor(a, b), bitxor(c, d));
        reg = uint32(bitor(uint32(bitshift(reg, -1)),bitshift(bit,lfsr_size-1)));
    end

        for j=0:lfsr_size-1
            index = i*lfsr_size + j;
            
            A(floor(index/N)+1, mod(index, N)+1) = int8(bitshift(bitand((uint32(bitshift(reg,-j))),uint32(1)),1)) - 1;
        end
    
    i = i+1;
end