% This code takes in an image from a file, compresses it, decompresses it,
% and displays the output.

clear all; close all;

% load the random A matrix (4096 rows x 16384 columns) from a file
load('A_final.mat'); A = double(A);

colormap(gray(256));axis('image');

% the number of data points in our compressed representation of the image
k = 4096;

% we zero out all but the N largest coefficients of the 16384 in the B matrix below
N = 1000;

% read in the image from a file and store it as a 128x128 matrix
x = double(imresize(imread('../images/Camera.tif'),.5));

% plot this original image in grayscale
subplot(1,2,1); image(x); colormap(gray(256)); axis('image');

% perform the Daubechies wavelet transform on the image and store in B (128x128)
% this produces B = Wx, where W represents the wavelet transform
h = daubcqf(4,'min'); B = mdwt(x,h,7);

% plot the wavelet-transformed image
subplot(1,2,2); image(B); colormap(gray(256)); axis('image');

% take the N largest coefficients from B and store them in the corresponding positions in tmp
tmp = zeros(16384,1);
for i=1:N
    [Y I] = max(abs(B(:)));
    tmp(I) = B(I);
    B(I) = 0;
end

% compressed vector y = AB = AWt; k=4096 rows, 1 column
y = A*tmp;

% print this vector to a file so it can be fed to the decompression C code
print_matrix_to_file( y, 'y', 'y_4096.txt', 1);

% decompress the image and store as "theta" (16384 x 1)
[theta numIters] = SolveOMP(A,y,16384);

close all;

% plot the output of the decompression function (pre-inverse transform)
subplot(1,3,1); image(reshape(theta,128,128)); colormap(gray(256)); axis('image');

% take the output of the decompression function and display it as an image
imrecov = midwt(reshape(theta,128,128), h);
subplot(1,3,2); image(imrecov); colormap(gray(256)); axis('image');