#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "invtransform2.c"
#include "transpose.c"

void invtransform(double theta[][128], int num_rows, int num_cols){
	/* mimic:
	theta_size = size(theta);
	n = theta_size(2);
	index = 2;

	while index <= n
	    theta1 = invtransform2(theta(1:index, 1:index)');
	    theta1t = theta1';
	    theta (1:index, 1:index)= invtransform2(theta1t);
	    index = index * 2;
	    clear theta1;
	    clear theta1t;
	end
	*/

	int index = 2;	
	while (index <= num_cols) {
		transpose(theta, index, index);
		invtransform2(theta, index, index);
		transpose(theta, index, index);
		invtransform2(theta, index, index);
		index = 2*index;
	}
}


