#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "cpv.c"

void iDWT_1d(double y[], int y_length){
	int i;	
	//mimic s=y(1:N/2);	
	double s[(y_length/2)];
	for (i=0; i<(y_length/2); i++){
		s[i] = y[i];
	}
	//mimic d=y(N/2+1:N);
	double d[(y_length/2)];
	for (i=(y_length/2); i<y_length; i++){
		d[i - (y_length/2)] = y[i];
	}
	//mimic d1=d/((sqrt(3)+1)/sqrt(2));
	double d1_for_cpv[(y_length/2)];
	for (i=0; i< (y_length/2); i++){
		d[i] = d[i]/((sqrt(3)+1)/sqrt(2));
		d1_for_cpv[i] = d[i];
	}
	//mimic s2=s/((sqrt(3)-1)/sqrt(2));
	for (i=0; i< (y_length/2); i++){
		s[i] = s[i]/((sqrt(3)-1)/sqrt(2));
	}
	//mimic s1=s2+cpv(d1,1);
	cpv(d1_for_cpv, (y_length/2), 1);

	double s1[(y_length/2)];
	double s1_for_cpv[(y_length/2)];
	for (i=0; i<(y_length/2); i++){
		s1[i] = s[i] + d1_for_cpv[i];
		s1_for_cpv[i] = s1[i];
	}
	//mimic S(2:2:N)=d1+sqrt(3)/4*s1+(sqrt(3)-2)/4*cpv(s1,-1);
	cpv(s1_for_cpv, (y_length/2), -1);
	for (i=0; i<(y_length/2); i++){
		y[1+(2*i)] = d[i] + sqrt(3) / 4 * s1[i] + (sqrt(3)-2) / 4 * s1_for_cpv[i];
	}
	//mimic S(1:2:N-1)=s1-sqrt(3)*S(2:2:N);
	for (i=0; i<(y_length/2); i++){
		y[2*i] = s1[i] - sqrt(3)*y[1+(2*i)];
	}
	
}
