library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity sram_mux is 
 port (
  sel : in std_logic;	
  SRAM_DQ_IN_from_av1  : in std_logic_vector(15 downto 0);
  SRAM_DQ_OUT_from_av1 : out std_logic_vector(15 downto 0);
  SRAM_ADDR_from_av1 : in std_logic_vector(17 downto 0);
  SRAM_UB_N_from_av1 : in std_logic;
  SRAM_LB_N_from_av1 : in std_logic;
  SRAM_WE_N_from_av1 : in std_logic;
  SRAM_CE_N_from_av1 : in std_logic;
  SRAM_OE_N_from_av1 : in std_logic;

  SRAM_DQ_IN_from_vga     : in std_logic_vector(15 downto 0);
  SRAM_DQ_OUT_from_vga    : out std_logic_vector(15 downto 0);
  SRAM_ADDR_from_vga : in std_logic_vector(17 downto 0);
  SRAM_UB_N_from_vga : in std_logic;
  SRAM_LB_N_from_vga : in std_logic;
  SRAM_WE_N_from_vga : in std_logic;
  SRAM_CE_N_from_vga : in std_logic;
  SRAM_OE_N_from_vga : in std_logic; 
  
  SRAM_DQ            : inout std_logic_vector(15 downto 0);
  SRAM_ADDR          : out std_logic_vector(17 downto 0);
  SRAM_UB_N          : out std_logic;
  SRAM_LB_N          : out std_logic;
  SRAM_WE_N          : out std_logic;
  SRAM_CE_N          : out std_logic;
  SRAM_OE_N          : out std_logic
  
  );
end sram_mux;

architecture rtl of sram_mux is
begin
  process( SRAM_DQ_IN_from_av1, SRAM_ADDR_from_av1, SRAM_UB_N_from_av1, 
           SRAM_LB_N_from_av1, SRAM_WE_N_from_av1, SRAM_CE_N_from_av1,
		   SRAM_OE_N_from_av1, SRAM_DQ_IN_from_vga, SRAM_ADDR_from_vga,
		   SRAM_UB_N_from_vga, SRAM_LB_N_from_vga, SRAM_WE_N_from_vga,
		   SRAM_CE_N_from_vga, SRAM_OE_N_from_vga, sel)
	begin
	  if sel = '0' then 
		if SRAM_WE_N_from_av1 = '0' then
	      SRAM_DQ <= SRAM_DQ_IN_from_av1;
	    else
	      SRAM_DQ <= (others => 'Z');
	    end if;
	
	    SRAM_DQ_OUT_from_av1 <= SRAM_DQ;  
	    SRAM_ADDR <= SRAM_ADDR_from_av1; 
	    SRAM_UB_N <= SRAM_UB_N_from_av1; 
	    SRAM_LB_N <= SRAM_LB_N_from_av1; 
	    SRAM_WE_N <= SRAM_WE_N_from_av1; 
	    SRAM_CE_N <= SRAM_CE_N_from_av1; 
	    SRAM_OE_N <= SRAM_OE_N_from_av1; 
	  else
		if SRAM_WE_N_from_vga = '0' then
	      SRAM_DQ <= SRAM_DQ_IN_from_vga;
		else
		  SRAM_DQ <= (others => 'Z'); 
		end if;
		
	    SRAM_DQ_OUT_from_vga <= SRAM_DQ; 
	    SRAM_ADDR <= SRAM_ADDR_from_vga; 
	    SRAM_UB_N <= SRAM_UB_N_from_vga; 
	    SRAM_LB_N <= SRAM_LB_N_from_vga; 
	    SRAM_WE_N <= SRAM_WE_N_from_vga; 
	    SRAM_CE_N <= SRAM_CE_N_from_vga;
	    SRAM_OE_N <= SRAM_OE_N_from_vga; 
	end if;
  end process;
end rtl;