library ieee;
use ieee.std_logic_1164.all;


--------------Single-Port RAM----------------

--RAM is used for storing input and ouput 
--vectors for the matrix-vector multiplication.
--As well as command and status registers for 
--signaling the state of the controller.

--VHDL follows the syntax suggested by Altera
--for instantiating the altsyncram megafuntion.
-----------------------------------------------



entity single_port_ram is

	generic 
	(
		DATA_WIDTH : natural := 16;
		ADDR_WIDTH : natural := 13
	);

	port 
	(
		clk		: in std_logic;
		addr	: in natural range 0 to 2**ADDR_WIDTH - 1;
		data	: in std_logic_vector((DATA_WIDTH-1) downto 0);
		we		: in std_logic := '1';
		q		: out std_logic_vector((DATA_WIDTH -1) downto 0)
	);

end entity;

architecture rtl of single_port_ram is

	-- Build a 2-D array type for the RAM
	subtype word_t is std_logic_vector((DATA_WIDTH-1) downto 0);
	type memory_t is array(addr'high downto 0) of word_t;

	-- Declare the RAM signal.	
	signal ram : memory_t;

	-- Register to hold the address 
	signal addr_reg : natural range 0 to addr'high;

begin

	process(clk)
	begin
	if(rising_edge(clk)) then
		if(we = '1') then
			ram(addr) <= data;
		end if;

		-- Register the address for reading
		addr_reg <= addr;
	end if;
	end process;

	-- assign the value to output
	q <= ram(addr_reg);

end rtl;
