library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;



-----------------------LFSR----------------------------

-- Linear feedback shift register for generating the 
-- random A matrix. Output bits are used to select
-- the appropriate operation in the accumulator block. 

-------------------------------------------------------
entity lfsr is
  port(
    clk     : in  std_logic;
    reset   : in  std_logic;
    enable  : in  std_logic;
    load    : in  std_logic;
    seed    : in  std_logic_vector(31 downto 0);
    bit_out : out std_logic
    );
end entity lfsr;

architecture behavior of lfsr is

  signal reg : std_logic_vector(31 downto 0);
  signal bit : std_logic;

begin

  bit_out <= reg(0);

  process(clk, reset, enable)
  begin
    if (reset = '1') then
      reg                  <= (others => '0');
    elsif (rising_edge(clk)) then
      if (load = '1') then
        reg                <= seed;
      else
        if enable = '1' then
          -- taps: 32, 22, 2, 1 (using 1-indexing)
          -- shift and generate new bit
		  reg(30 downto 0) <= reg(31 downto 1);
          reg(31)          <= reg(31) xor reg(30) xor reg(10) xor reg(0);
        else
          reg(31 downto 0) <= reg(31 downto 0);
        end if;
      end if;
    end if;
  end process;

end behavior;
