library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;


----------------Column Module--------------------

--The parallel element of our matrix-vector
--multiplier block.  Each module is a combination
--of a LFSR and accumulator block capable of 
--generating and producing an output for a row
--in the transposed random matrix.  

------------------------------------------------

entity column_module is

  port
    (
      clk        : in  std_logic;
      acc_active : in  std_logic;
      reset      : in  std_logic;
      reset_acc  : in  std_logic;
      load       : in  std_logic;
      seed       : in  std_logic_vector(31 downto 0);
      i_vec      : in  std_logic_vector(15 downto 0);
      o_reg      : out std_logic_vector(31 downto 0)
      );

end column_module;


architecture df of column_module is

  --component declaration for LFSR
  component lfsr
    port
      (
        clk, reset, load, enable : in  std_logic;
        seed                     : in  std_logic_vector(31 downto 0);
        bit_out                  : out std_logic
        );
  end component;

  --component declaration for Accumulator
  component accumulator
    port
      (
        clk, acc_active, sel, reset : in  std_logic;
        i_vec                       : in  std_logic_vector(15 downto 0);
        o_reg                       : out std_logic_vector(31 downto 0)
        );
  end component;

  signal sel : std_logic;
begin

  -- Port Mappings
  lfsr0 : lfsr port map
    (
      enable  => acc_active,
      clk     => clk,
      reset   => reset,
      load    => load,
      seed    => seed,
      bit_out => sel
      );

  acc0 : accumulator port map
    (
      clk        => clk,
      acc_active => acc_active,
      sel => sel,
      reset => reset_acc,
      i_vec => i_vec,
      o_reg => o_reg
      );

end df;
