library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;




--------------------------Accumulator-----------------------------

--Used for generating the result of matrix
--vector multiplications.  Matrix is composed of -1,1's 
--so we can simplify the process to additions or subtractions.
--Inputs are the input vector coming from RAM and the next element
--of the matrix coming from the LFSR block.

------------------------------------------------------------------
entity accumulator is
  port (
    clk        : in  std_logic;
    acc_active : in  std_logic;
    sel        : in  std_logic;
    reset      : in  std_logic;
    i_vec      : in  std_logic_vector(15 downto 0);
    o_reg      : out std_logic_vector(31 downto 0)
    );
end accumulator;

architecture behavior of accumulator is
  signal i_reg   : signed(15 downto 0);
  signal acc_out : signed(31 downto 0);

begin
  process(clk, reset)
  begin
    if reset = '1' then
      acc_out       <= (others => '0');
    else
      if rising_edge(clk) then
        if (acc_active = '1') then
		  --sel is the output bit from the LFSR
          if sel = '1' then
            acc_out <= acc_out + (i_reg);
          else
            acc_out <= acc_out - (i_reg);
          end if;
        else
          acc_out   <= acc_out;
        end if;
      end if;
    end if;
  end process;

  i_reg <= signed(i_vec);
  o_reg <= std_logic_vector(acc_out);

end behavior;
