library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity accumulator is 
	port (
		clk     : in std_logic;
		lfsr_b : in std_logic;
		reset  : in std_logic;
		in_vec  : in signed(31 downto 0);
		out_reg : out signed(31 downto 0)
    );
end accumulator;


architecture behavior of accumulator is 
	signal in_reg : signed(31 downto 0);
	signal acc_out : signed(31 downto 0);
begin

process ( clk,reset ) 
begin
	if reset = '1' then
		acc_out <= (others => '0');
	else
		if rising_edge(clk) then
			in_reg <= in_vec;
			if lfsr_b = '1' then
				acc_out <= acc_out + in_reg;
			else
				acc_out <= acc_out - in_reg;
			end if;
		end if;
	end if;
end process;
out_reg <= acc_out;
end behavior;
		