/*
 *  * Copyright (c) 2004 Xilinx, Inc.  All rights reserved.
 *
 * Xilinx, Inc.
 * XILINX IS PROVIDING THIS DESIGN, CODE, OR INFORMATION "AS IS" AS A 
 * COURTESY TO YOU.  BY PROVIDING THIS DESIGN, CODE, OR INFORMATION AS
 * ONE POSSIBLE   IMPLEMENTATION OF THIS FEATURE, APPLICATION OR 
 * STANDARD, XILINX IS MAKING NO REPRESENTATION THAT THIS IMPLEMENTATION 
 * IS FREE FROM ANY CLAIMS OF INFRINGEMENT, AND YOU ARE RESPONSIBLE 
 * FOR OBTAINING ANY RIGHTS YOU MAY REQUIRE FOR YOUR IMPLEMENTATION
 * XILINX EXPRESSLY DISCLAIMS ANY WARRANTY WHATSOEVER WITH RESPECT TO 
 * THE ADEQUACY OF THE IMPLEMENTATION, INCLUDING BUT NOT LIMITED TO 
 * ANY WARRANTIES OR REPRESENTATIONS THAT THIS IMPLEMENTATION IS FREE 
 * FROM CLAIMS OF INFRINGEMENT, IMPLIED WARRANTIES OF MERCHANTABILITY 
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 */

// Located in: microblaze_0/include/xparameters.h
#include "xparameters.h"

#include "xutil.h"
#include "xintc_l.h"
#include "xuartlite_l.h"
#include "xgpio_l.h"

#define FONT_OFFSET 0xA00
#define ESC 0x11b  
#define UP 0x1D
#define DOWN 0x1B
#define LEFT 0x1C
#define F1 0x3b00
#define RIGHT 0x23
#define YES 0x1579
#define NO 0x316e
#define RESTART 0x1372

#define	DARKGRAY				0X05
#define 	BLUE					0X01
#define  BROWN					0X03
#define  YELLOW				0X06
#define  LIGHTGREEN			0X03
#define  GREEN					0X02
#define  RED					0X04
#define 	WHITE					0X07

#define  X_OFFSET					   0
#define  Y_OFFSET						35   //(VSYNC+VBACK_PORCH)
#define 	BLOCK_HEIGHT				0X08
#define  BLOCK_WIDTH					0X08
#define  MAX_CLOUMN_BLOCK_NUM		10  	// default is 10
#define  MAX_ROW_BLOCK_NUM			20 	// default is 20	 
#define  TOP_Y							40 	// default is 40  
#define  TOP_X							200    	// default is 200 wait 	
#define  BOTTOM_X						TOP_X+MAX_CLOUMN_BLOCK_NUM*BLOCK_WIDTH	// default is 400	wait		
#define  MAX_Y							TOP_Y+MAX_ROW_BLOCK_NUM*BLOCK_HEIGHT//default is 440 wait 

#define  BLOCK_I_WIDTH				4*BLOCK_WIDTH	//default is 80
#define  BLOCK_O_WIDTH				2*BLOCK_WIDTH	//default is 40	
#define  BLOCK_T_WIDTH				2*BLOCK_WIDTH	//default is 40	
#define  BLOCK_T_HEIGHT				3*BLOCK_HEIGHT	//default is 60  
#define  BLOCK_L_WIDTH				2*BLOCK_WIDTH	//default is 40	
#define  BLOCK_L_HEIGHT				3*BLOCK_HEIGHT	//default is 60 
#define  BLOCK_J_WIDTH				2*BLOCK_WIDTH	//default is 40 	
#define  BLOCK_J_HEIGHT				3*BLOCK_HEIGHT	//default is 60 
#define  BLOCK_Z_WIDTH				2*BLOCK_WIDTH	//default is 40
#define  BLOCK_Z_HEIGHT				3*BLOCK_HEIGHT	//default is 60
#define 	BLOCK_N_WIDTH				2*BLOCK_WIDTH	//default is 40
#define 	BLOCK_N_HEIGHT				3*BLOCK_HEIGHT	//default is 40

#define  BLOCK_STATUS_MASK			0X0F	



//rectangle(200+j*20,40+i*20,200+j*20+20,40+i*20+20);
//floodfill(200+j*20+10,40+i*20+10,WHITE);
//setcolor(drblock.color);


unsigned char grid[MAX_ROW_BLOCK_NUM][MAX_CLOUMN_BLOCK_NUM];			/* LSB 4 bits:0 no block,1: block moving ,2:block in */
unsigned char level,score;
int interval;	/*level--Ascore-- interval--time interval: */
 unsigned char I_SHAPE1[1][4]={1,1,1,1};/*IN???AOСФ*/
 unsigned char I_SHAPE2[4][1]={1,
                           1,
                           1,
                           1};
 unsigned char O_SHAPE[2][2]={1,1,
     1,1};
 unsigned char T_SHAPE1[2][3]={1,1,1,
      0,1,0};
 unsigned char T_SHAPE2[3][2]={0,1,
      1,1,
      0,1};
 unsigned char T_SHAPE3[2][3]={0,1,0,
      1,1,1};
 unsigned char T_SHAPE4[3][2]={1,0,
      1,1,
      1,0};
 unsigned char L_SHAPE1[3][2]={1,0,
      1,0,
      1,1};
 unsigned char L_SHAPE2[2][3]={1,1,1,
      1,0,0};
 unsigned char L_SHAPE3[3][2]={1,1,
      0,1,
      0,1};
 unsigned char L_SHAPE4[2][3]={0,0,1,
      1,1,1};
 unsigned char J_SHAPE1[3][2]={0,1,
      0,1,
      1,1 };
 unsigned char J_SHAPE2[2][3]={1,0,0,
      1,1,1};
 unsigned char J_SHAPE3[3][2]={1,1,
      1,0,
      1,0 };
 unsigned char J_SHAPE4[2][3]={1,1,1,
      0,0,1};
 unsigned char Z_SHAPE1[2][3]={1,1,0,
      0,1,1};
 unsigned char Z_SHAPE2[3][2]={0,1,
      1,1,
      1,0 };
 unsigned char N_SHAPE1[2][3]={0,1,1,
      1,1,0};
 unsigned char N_SHAPE2[3][2]={1,0,
      1,1,
      0,1 };

struct block
{unsigned char type;/*:I,O,T,L,J,Z,N*/
 unsigned char shape;
 int  x;
 int y;
 unsigned char color;
};
void ini_graph();
int check_bottom();
int check_top();
int  check_lborder();
int  check_rborder();
int  del_line();
void initial();
void restart();

void show_next();
void drawblock();
void clear_block();
void  todelay(void);
struct block create();/*??ͤ@?s?*/

/* Address of a particular character on the screen (rows are 80) */
//sun modified #define CHAR(c,r) \
//sun modified   (((unsigned char *)(XPAR_VGA_BASEADDR))[(c) + ((r) << 6) + ((r) << 4)])

#define CHAR(c,r) \
   (((unsigned char *)(XPAR_VGA_BASEADDR))[(c) + ((r) << 5) + ((r) << 3)])

/* Start of font memory */
#define FONT ((unsigned char *)XPAR_VGA_BASEADDR + FONT_OFFSET)

int uart_interrupt_count = 0;
char uart_character;
 
/* UART interrupt service routine */
void uart_int_handler(void *baseaddr_p) {
   
   /* While UART receive FIFO has data */
   while (!XUartLite_mIsReceiveEmpty(XPAR_RS232_BASEADDR)) {
     /* Read a character */
     uart_character = XUartLite_RecvByte(XPAR_RS232_BASEADDR);
     ++uart_interrupt_count;
   }
}

/* Must be a power of two */
#define SCANCODE_BUFFER_SIZE 16
unsigned char scancode_buffer[SCANCODE_BUFFER_SIZE];
int scancode_buffer_head = 0;
int scancode_buffer_tail = 0;

int character_available()
{
  int result;
  microblaze_disable_interrupts();
  result = scancode_buffer_head != scancode_buffer_tail;
  microblaze_enable_interrupts();
  return result;	
}

unsigned char get_character()
{
  unsigned char result;
  microblaze_disable_interrupts();
  result = scancode_buffer[scancode_buffer_tail];
  scancode_buffer_tail = (scancode_buffer_tail + 1) & (SCANCODE_BUFFER_SIZE - 1);
  microblaze_enable_interrupts();
  return result;		
}

int keyboard_interrupt_count = 0;
unsigned int scan_code = 0;
unsigned int keyboard_bit = 11;

/* PS/2 Keyboard interrupt service routine */
void ps2_int_handler(void *baseaddr_p)
{
  int next_head;
  keyboard_interrupt_count++;
 
  /* We're reading a scancode and the keyboard clock fell: sample the data */
  scan_code = (scan_code >> 1) |
      (XGpio_mReadReg(XPAR_PS2IO_BASEADDR, XGPIO_DATA_OFFSET) << 9);
  if (--keyboard_bit == 0) {
    /* keycode is ready */
    next_head = (scancode_buffer_head + 1) & (SCANCODE_BUFFER_SIZE - 1);
    if (next_head != scancode_buffer_tail) {
      /* buffer is not full; add the character */
      scancode_buffer[scancode_buffer_head] = scan_code;
      scancode_buffer_head = next_head;
    }
    keyboard_bit = 11;
    scan_code = 0;
  }
   
  /* Acknowledge the interrupt */
  XGpio_mWriteReg(XPAR_PS2IO_BASEADDR, XGPIO_ISR_OFFSET, 1);
}

/* Write a text string on the display */


void updated_memory(void)
{
	int i;
	char *p;
	for (i=0; i<MAX_ROW_BLOCK_NUM;i++)
	{
		 *p = &(CHAR(0, i));
		 memcpy (p,grid[i],40);
	}
}		 


int main (void) 
{
	unsigned char key;
	struct  block  nextblock,mblock;
   int i;
   unsigned char updatedstatus;
    
    microblaze_enable_interrupts();
   /* Register the UART interrupt handler in the vector table */
   XIntc_RegisterHandler(XPAR_OPB_INTC_0_BASEADDR,XPAR_OPB_INTC_0_RS232_INTERRUPT_INTR,
      (XInterruptHandler)uart_int_handler,(void *)0);
   /* Register the keyboard interrupt handler */
   XIntc_RegisterHandler(XPAR_OPB_INTC_0_BASEADDR, XPAR_OPB_INTC_0_SYSTEM_PS2C_INTR,
      (XInterruptHandler)ps2_int_handler, (void *)0);
   /* Start the interrupt controller */
   XIntc_mMasterEnable(XPAR_OPB_INTC_0_BASEADDR);
   /* Enable timer and UART interrupt requests in the interrupt controller */
   XIntc_mEnableIntr(XPAR_OPB_INTC_0_BASEADDR,
                     XPAR_RS232_INTERRUPT_MASK | XPAR_SYSTEM_PS2C_MASK);
   /* Enable UART interrupts */
   XUartLite_mEnableIntr(XPAR_RS232_BASEADDR); 
   
   initial();
   nextblock=create(); 		
  loop: if(check_top(mblock)) initial();
  			
      mblock=nextblock;
      nextblock=create();
     // show_next(nextblock);
   	updatedstatus=0;   
	while(1)
 	{ 
 		if(character_available()) 
 			key=get_character();
      else 
      	key=0;
      	
		if ( updatedstatus)
		{
			updated_memory();    
			updatedstatus=0;   
		}	
		switch(key)
     	{
     		case DOWN:     		
    			break;
    			
       	case UP:        
       		break;
       
       	case LEFT:       	
       		break;
       		
       	case RIGHT:       
    			break;
    			
       
       default:
       	updatedstatus=1;
       	if(check_bottom(mblock)==1)
   		{  
   			if(del_line(mblock.y))
    			{ 
    				mblock.color=DARKGRAY;
    				drawblock(mblock);
    			}
    			goto loop;
   		}
    		clear_block(mblock);
     		mblock.y=mblock.y+BLOCK_HEIGHT;
     		drawblock(mblock);
     		
      	todelay();
        	break;
      }/*switch*/
   
  	}/*while*/  	

	return 0;
}
//-------------------------------------------------------------------------
/*???A??????eblock??q*/ 
void drawblock(struct block drblock)
{
	int i0,j0,i,j;
	
	j0=(drblock.x-TOP_X)/BLOCK_WIDTH;/*?W誺?x,y?⦨???grid[i][j]U?i0,j0*/
	i0=(drblock.y-TOP_Y)/BLOCK_HEIGHT;
	//setfillstyle(9,drblock.color);
	//setcolor(drblock.color);
	
	switch(drblock.type)
 	{
 		case('I'):
 			if(drblock.shape==1)
     		{ 
     			for(j=0;j<4;j++)
       		{ 
       			//rectangle(drblock.x+j*20,drblock.y,drblock.x+j*20+20,drblock.y+20);/*??l*/
  					//floodfill(drblock.x+j*20+10,drblock.y+10,drblock.color);/*R?*/
  					grid[i0][j0+j]+=I_SHAPE1[0][j];/*?w??Ogrid??ۥ[   l?grid??N[1*/
  					if (grid[i0][j0+j])
  						grid[i0][j0+j]|=(drblock.color<<4);//color
       		}                             
     		}
    		if(drblock.shape==2)
     		{ 
     			for(i=0;i<4;i++)
       		{ 
       			//rectangle(drblock.x,drblock.y+20*i,drblock.x+20,drblock.y+20*i+20);
  					//floodfill(drblock.x+10,drblock.y+20*i+10,drblock.color);
  					grid[i0+i][j0]+=I_SHAPE2[i][0];
  					if (grid[i0+i][j0])
  						grid[i0+i][j0]|=(drblock.color<<4);//color;
  				}
     		}
     		break;
     		
  		case('O'):
  			for(i=0;i<2;i++)
  			{
     			for(j=0;j<2;j++)
      		{
      			//rectangle(drblock.x+i*20,drblock.y+j*20,drblock.x+i*20+20,drblock.y+j*20+20);
       			//floodfill(drblock.x+i*20+10,drblock.y+j*20+10,drblock.color);
      			grid[i0+i][j0+j]+=O_SHAPE[i][j];
      			if (grid[i0+i][j0+j])
      				grid[i0+i][j0+j]|=(drblock.color<<4);//color;
      		}
      	}	
     		break;
     		
  		case('T'): 
  			switch(drblock.shape)
      	{
      		case(1):
      			for(i=0;i<2;i++)
      			{
        				for(j=0;j<3;j++)
        				{
        					grid[i0+i][j0+j]+=T_SHAPE1[i][j] ;
        					if(T_SHAPE1[i][j]==1)
   						{
   							grid[i0+i][j0+j]|=(drblock.color<<4);//color;
   							//rectangle(drblock.x+j*20,drblock.y+i*20,drblock.x+j*20+20,drblock.y+i*20+20);
    							//floodfill(drblock.x+j*20+10,drblock.y+i*20+10,drblock.color);
   						}
   					}	
        			}
        			break ;
        			
       		case(2):
       			for(i=0;i<3;i++)
       			{
        				for(j=0;j<2;j++)
        				{
        					grid[i0+i][j0+j]+=T_SHAPE2[i][j] ;
         				if(T_SHAPE2[i][j]==1)
   						{
   							grid[i0+i][j0+j]|=(drblock.color<<4);//color;
   							//rectangle(drblock.x+j*20,drblock.y+i*20,drblock.x+j*20+20,drblock.y+i*20+20);
    							//floodfill(drblock.x+j*20+10,drblock.y+i*20+10,drblock.color);
   						}
   					}	
        			}
        			break ;
        			
       		case(3):
       			for(i=0;i<2;i++)
       			{
        				for(j=0;j<3;j++)
        				{
        					grid[i0+i][j0+j]+=T_SHAPE3[i][j] ;
         				if(T_SHAPE3[i][j]==1)
   						{
   							grid[i0+i][j0+j]|=(drblock.color<<4);//color;
   							//rectangle(drblock.x+j*20,drblock.y+i*20,drblock.x+j*20+20,drblock.y+i*20+20);
    							//floodfill(drblock.x+j*20+10,drblock.y+i*20+10,drblock.color);
   						}
   					}	
        			}
        			break ;        			
       
     		} 
     		break;
      		
  	
 	}
}

//-----------------------------------------------------------------------------
/*?A??????W誺??ȡApA^0A_?^1*/
int del_line(int ty)
{
int i,j ,b,i0,k,ret;
	
	ret=0;
	if (ty>=MAX_Y) 
		return 0;
	i0=(ty-TOP_Y)/BLOCK_HEIGHT;
	//if(i0==19||i0==18||i0==17)//wait
	if(i0==(MAX_ROW_BLOCK_NUM-1)||i0==(MAX_ROW_BLOCK_NUM-2)||i0==(MAX_ROW_BLOCK_NUM-3))
		b=19;
	else 
		b=i0+3;
	for(k=i0;k<=b;k++)
 	{ 
 		for(j=0;j<10;j++)
 		{
   		if(!grid[k][j])  
   		break;
   	}	
   	if(j==10)  
   	{
   		score++;
        	ret=1;
        	for(i=k;i>0;i--)
        	{
        		for(j=0;j<10;j++)
  				{ 
  					grid[i][j]=grid[i-1][j];
      		
        		}
  			}
     	}
 	}
	return ret;
}
//----------------------------------------------------------------------------
void todelay(void)
{
	int i,j;
	for(i=0;i<65535;i++)
	{
		for(j=0;j<65535;j++);
	}	
	
}	
//---------------------------------------------------------------------------
/*P??O_eΤUw??A?^1A_?^0*/
int check_bottom(struct block nblock)
{ 
	int j,i0,j0;
	j0=(nblock.x-TOP_X)/BLOCK_WIDTH;
 	i0=(nblock.y-TOP_Y)/BLOCK_HEIGHT;
 	
  	switch(nblock.type)
 	{
 		case('I'): 
 			if(nblock.shape==1)
        	{
        		//if(nblock.y==420)  //wait 420
        		if(nblock.y==(MAX_Y-BLOCK_HEIGHT))
        			return 1;/*w??e*/
  				for(j=0;j<4;j++)
  				{
  					if(grid[i0+1][j0+j]) 
  						return 1;/*I?U@w??*/
  				}		
        	}
        	if(nblock.shape==2)
        	{
        		//if(nblock.y==360)  //wairt 360
        		if(nblock.y==(MAX_Y-4*BLOCK_HEIGHT)) 
        			return 1;
  				if(grid[i0+4][j0]) 
  					return 1;
        	}
        	break;
        	
  		case('O'): 
  			//if(nblock.y==400)  //wait 400
  			if(nblock.y==(MAX_Y-2*BLOCK_HEIGHT))
  				return 1;
      	for(j=0;j<2;j++)
      	{
      		if (grid[i0+2][j0+j]) 
      		return 1;
      	}	
      	break;
      	
  		case('T'):
  			switch(nblock.shape)
      	{
      		case(1):
      			//if(nblock.y==400)  //wait 400
      			if(nblock.y==(MAX_Y-2*BLOCK_HEIGHT))
      				return 1;
        			if(grid[i0+2][j0+1]||grid[i0+1][j0]||grid[i0+1][j0+2])
    					return 1;
        			break;
        			
       		case(2):
       			//if(nblock.y==380) //wait 380
       			if(nblock.y==(MAX_Y-3*BLOCK_HEIGHT))
       				return 1;
        			if(grid[i0+3][j0+1]||grid[i0+2][j0]) 
        				return 1; 
        			break;
        			
       		case(3):
       			//if(nblock.y==400) //wait 400
       			if(nblock.y==(MAX_Y-2*BLOCK_HEIGHT))
       				return 1;
        			for(j=0;j<3;j++)
        			{
        				if(grid[i0+2][j0+j]) 
        					return 1;  
        			}		
        			break;
        			
       		case(4):
       			//if(nblock.y==380) //wait 380
    				if(nblock.y==(MAX_Y-3*BLOCK_HEIGHT))
       				return 1;
        			if(grid[i0+3][j0]||grid[i0+2][j0+1]) 
        				return 1;
        			break;
      	} 
      	break;
      	
  		case('L'): 
  			switch(nblock.shape)
      	{
      		case(1):
      			//if (nblock.y>=380) //wait 380
     				if(nblock.y==(MAX_Y-3*BLOCK_HEIGHT))
      				return 1;
        			if (grid[i0+3][j0]||grid[i0+3][j0+1])
     					return 1;      
     				break;
     				
       		case(2):
       			//if(nblock.y>=400) //wait 400
       				if(nblock.y==(MAX_Y-2*BLOCK_HEIGHT))
       				return 1;
        			if(grid[i0+2][j0]||grid[i0+1][j0+1]||grid[i0+1][j0+2])
        				return 1; 
        			break;
       		case(3):
       			//if (nblock.y>=380) //wait 380
     				if(nblock.y==(MAX_Y-3*BLOCK_HEIGHT))
       				return 1;
        			if (grid[i0+3][j0+1]||grid[i0+1][j0])
     					return 1;      
     				break;
       		case(4):
       			//if (nblock.y>=400) //wait 400
     				if(nblock.y==(MAX_Y-2*BLOCK_HEIGHT))
       				return 1;
    				for(j=0;j<3;j++)
    				{
     					if(grid[i0+2][j0+j])
     						return 1;      
     				}		
     				break;
      	}
      	break;
      	
  		case('J'):
  			switch(nblock.shape)
      	{
      		case(1):
      			//if (nblock.y>=380) //wait 380
      			if(nblock.y==(MAX_Y-3*BLOCK_HEIGHT))	
      				return 1;
        			if (grid[i0+3][j0]||grid[i0+3][j0+1])
     					return 1;      
     				break;
     				
       		case(2):
       			//if (nblock.y>=400) //wait 400
       			if(nblock.y==(MAX_Y-2*BLOCK_HEIGHT))	
       				return 1;
     				for(j=0;j<3;j++)
     				{
     					if(grid[i0+2][j0+j])
     						return 1;   
     				}		
     				break;
     				
       		case(3):
       			//if (nblock.y>=380) //wait 380
       			if(nblock.y==(MAX_Y-3*BLOCK_HEIGHT))	
       				return 1;
        			if (grid[i0+3][j0]||grid[i0+1][j0+1])
     					return 1;      
     				break;

       		case(4):
       			//if (nblock.y>=400) //wait 400
       			if(nblock.y==(MAX_Y-2*BLOCK_HEIGHT))	
       				return 1;
        			if (grid[i0+2][j0+2]||grid[i0+1][j0]||grid[i0+1][j0+1])
     					return 1;      
     				break;
      	}
      	break;
      	
  		case('Z'):
  			if (nblock.shape==1)
       	{ 
       		//if(nblock.y==400) //wait 400
       		if(nblock.y==(MAX_Y-2*BLOCK_HEIGHT))	
       			return 1;
  				if(grid[i0+1][j0]||grid[i0+2][j0+1]||grid[i0+2][j0+2])
      			return 1;    
      	}
     		if (nblock.shape==2)
       	{ 
       		//if(nblock.y==380) //wait 380
       		if(nblock.y==(MAX_Y-3*BLOCK_HEIGHT))	
       			return 1;
  				if(grid[i0+3][j0]||grid[i0+2][j0+1])
      			return 1;    
      	} 
      	break;
      	
  		case('N'):
  			if(nblock.shape==1)
        	{ 
        		//if(nblock.y==400) //wait 400
        		if(nblock.y==(MAX_Y-2*BLOCK_HEIGHT))	
        			return 1;
  				if(grid[i0+1][j0+2]||grid[i0+2][j0+1]||grid[i0+2][j0])
      			return 1;
        	}
      	if(nblock.shape==2)
        	{ 
        		//if(nblock.y==380) //wait 380
        		if(nblock.y==(MAX_Y-3*BLOCK_HEIGHT))	
        			return 1;
   			if(grid[i0+2][j0]||grid[i0+3][j0+1])
      			return 1;
        	}
        	break;
   }
	return 0;
}
//----------------------------------------------------------------------------
/*P??O_e?,]O???ӡAp??^1A_?^0*/
int check_top(struct block tblock)
{ 
	if(tblock.y==TOP_Y)  
		return 1;
   else 
   	return 0;
}

//----------------------------------------------------------------------------

struct block create(void)
{
	struct block newblock ;
 	static int r;
 	
 	//r=rand(7);
 	switch(r++)
 	{case(0):newblock.type='I';newblock.color=DARKGRAY; break;
  	 case(1):newblock.type='O';newblock.color=BLUE; break;
    case(2):newblock.type='T';newblock.color=BROWN; break;
    case(3):newblock.type='L';newblock.color=YELLOW; break;
    case(4):newblock.type='J';newblock.color=LIGHTGREEN; break;
    case(5):newblock.type='Z';newblock.color=GREEN; break;
    case(6):newblock.type='N';newblock.color=RED; break;
 	}
 	newblock.shape=1;
 	newblock.x=300;
 	newblock.y=40;
 	if (r> 7) 
 	 r =0;
 	return newblock;
}
//-----------------------------------------------------------------------
void initial(void)
{
	int i,j;
	
 	score=0;
 	interval=500;
 	for(i=0;i<20;i++)
 	{
  		for(j=0;j<10;j++)
  		{
			grid[i][j]=0;
		}	
	} 
}	