/*
 *  * Copyright (c) 2004 Xilinx, Inc.  All rights reserved.
 *
 * Xilinx, Inc.
 * XILINX IS PROVIDING THIS DESIGN, CODE, OR INFORMATION "AS IS" AS A 
 * COURTESY TO YOU.  BY PROVIDING THIS DESIGN, CODE, OR INFORMATION AS
 * ONE POSSIBLE   IMPLEMENTATION OF THIS FEATURE, APPLICATION OR 
 * STANDARD, XILINX IS MAKING NO REPRESENTATION THAT THIS IMPLEMENTATION 
 * IS FREE FROM ANY CLAIMS OF INFRINGEMENT, AND YOU ARE RESPONSIBLE 
 * FOR OBTAINING ANY RIGHTS YOU MAY REQUIRE FOR YOUR IMPLEMENTATION
 * XILINX EXPRESSLY DISCLAIMS ANY WARRANTY WHATSOEVER WITH RESPECT TO 
 * THE ADEQUACY OF THE IMPLEMENTATION, INCLUDING BUT NOT LIMITED TO 
 * ANY WARRANTIES OR REPRESENTATIONS THAT THIS IMPLEMENTATION IS FREE 
 * FROM CLAIMS OF INFRINGEMENT, IMPLIED WARRANTIES OF MERCHANTABILITY 
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 */

// Located in: microblaze_0/include/xparameters.h
#include "xparameters.h"

#include "xutil.h"
#include "xintc_l.h"
#include "xuartlite_l.h"
#include "xgpio_l.h"

#define FONT_OFFSET 0xA00
#define ESC 0x11b  
#define UP 0x1D
#define DOWN 0x1B
#define LEFT 0x1C
#define F1 0x3b00
#define RIGHT 0x23
#define YES 0x1579
#define NO 0x316e
#define RESTART 0x1372

#define	DARKGRAY				0X05
#define 	BLUE					0X01
#define  BROWN					0X03
#define  YELLOW				0X06
#define  LIGHTGREEN			0X03
#define  GREEN					0X02
#define  RED					0X04
#define 	WHITE					0X07

#define  X_OFFSET					   0
#define  Y_OFFSET						35   //(VSYNC+VBACK_PORCH)
#define 	BLOCK_HEIGHT				0X08
#define  BLOCK_WIDTH					0X08
#define  MAX_CLOUMN_BLOCK_NUM		10  	// default is 10
#define  MAX_ROW_BLOCK_NUM			20 	// default is 20	 
#define  TOP_Y							40 	// default is 40  
#define  TOP_X							200    	// default is 200 wait 	
#define  BOTTOM_X						TOP_X+MAX_CLOUMN_BLOCK_NUM*BLOCK_WIDTH	// default is 400	wait		
#define  MAX_Y							TOP_Y+MAX_ROW_BLOCK_NUM*BLOCK_HEIGHT//default is 440 wait 

#define  BLOCK_I_WIDTH				4*BLOCK_WIDTH	//default is 80
#define  BLOCK_O_WIDTH				2*BLOCK_WIDTH	//default is 40	
#define  BLOCK_T_WIDTH				2*BLOCK_WIDTH	//default is 40	
#define  BLOCK_T_HEIGHT				3*BLOCK_HEIGHT	//default is 60  
#define  BLOCK_L_WIDTH				2*BLOCK_WIDTH	//default is 40	
#define  BLOCK_L_HEIGHT				3*BLOCK_HEIGHT	//default is 60 
#define  BLOCK_J_WIDTH				2*BLOCK_WIDTH	//default is 40 	
#define  BLOCK_J_HEIGHT				3*BLOCK_HEIGHT	//default is 60 
#define  BLOCK_Z_WIDTH				2*BLOCK_WIDTH	//default is 40
#define  BLOCK_Z_HEIGHT				3*BLOCK_HEIGHT	//default is 60
#define 	BLOCK_N_WIDTH				2*BLOCK_WIDTH	//default is 40
#define 	BLOCK_N_HEIGHT				3*BLOCK_HEIGHT	//default is 40

#define  BLOCK_STATUS_MASK			0X0F	



//rectangle(200+j*20,40+i*20,200+j*20+20,40+i*20+20);
//floodfill(200+j*20+10,40+i*20+10,WHITE);
//setcolor(drblock.color);


unsigned char grid[MAX_ROW_BLOCK_NUM][MAX_CLOUMN_BLOCK_NUM];			/* LSB 4 bits:0 no block,1: block moving ,2:block in */
unsigned char level,score;
int interval;	/*level--Ascore-- interval--time interval: */

static  short int blocksharp[7]={0x4444,0x0660,0xE440,0x4460,0x2260,0x0C60,0X0360};
#define I_SHAPE 	0x4444
	
#define O_SHAPE	0x0660
 
#define T_SHAPE	0xE440

#define L_SHAPE	0X4460

#define J_SHAPE	0x2260

#define Z_SHAPE	0x0C60

#define N_SHAPE	0X0360
 

unsigned char magicblock[4][4];


struct block
{
 unsigned char type;/*:I,O,T,L,J,Z,N*/
 int  x;
 int y;
 unsigned char color;
};
void ini_graph();
int check_bottom();
int check_top();
int  check_lborder();
int  check_rborder();
int  del_line();
void initial();
void restart();

void show_next();
void drawblock();
void clear_block();
void  todelay(void);
void  buildblock();
struct block create();/*??ͤ@?s?*/
void change(struct block cblock);/*????*/

/* Address of a particular character on the screen (rows are 80) */
//sun modified #define CHAR(c,r) \
//sun modified   (((unsigned char *)(XPAR_VGA_BASEADDR))[(c) + ((r) << 6) + ((r) << 4)])

#define CHAR(c,r) \
   (((unsigned char *)(XPAR_VGA_BASEADDR))[(c) + ((r) << 5) + ((r) << 3)])

/* Start of font memory */
#define FONT ((unsigned char *)XPAR_VGA_BASEADDR + FONT_OFFSET)

int uart_interrupt_count = 0;
char uart_character;
 
/* UART interrupt service routine */
void uart_int_handler(void *baseaddr_p) {
   
   /* While UART receive FIFO has data */
   while (!XUartLite_mIsReceiveEmpty(XPAR_RS232_BASEADDR)) {
     /* Read a character */
     uart_character = XUartLite_RecvByte(XPAR_RS232_BASEADDR);
     ++uart_interrupt_count;
   }
}

/* Must be a power of two */
#define SCANCODE_BUFFER_SIZE 16
unsigned char scancode_buffer[SCANCODE_BUFFER_SIZE];
int scancode_buffer_head = 0;
int scancode_buffer_tail = 0;

int character_available()
{
  int result;
  microblaze_disable_interrupts();
  result = scancode_buffer_head != scancode_buffer_tail;
  microblaze_enable_interrupts();
  return result;	
}

unsigned char get_character()
{
  unsigned char result;
  microblaze_disable_interrupts();
  result = scancode_buffer[scancode_buffer_tail];
  scancode_buffer_tail = (scancode_buffer_tail + 1) & (SCANCODE_BUFFER_SIZE - 1);
  microblaze_enable_interrupts();
  return result;		
}

int keyboard_interrupt_count = 0;
unsigned int scan_code = 0;
unsigned int keyboard_bit = 11;

/* PS/2 Keyboard interrupt service routine */
void ps2_int_handler(void *baseaddr_p)
{
  int next_head;
  keyboard_interrupt_count++;
 
  /* We're reading a scancode and the keyboard clock fell: sample the data */
  scan_code = (scan_code >> 1) |
      (XGpio_mReadReg(XPAR_PS2IO_BASEADDR, XGPIO_DATA_OFFSET) << 9);
  if (--keyboard_bit == 0) {
    /* keycode is ready */
    next_head = (scancode_buffer_head + 1) & (SCANCODE_BUFFER_SIZE - 1);
    if (next_head != scancode_buffer_tail) {
      /* buffer is not full; add the character */
      scancode_buffer[scancode_buffer_head] = scan_code;
      scancode_buffer_head = next_head;
    }
    keyboard_bit = 11;
    scan_code = 0;
  }
   
  /* Acknowledge the interrupt */
  XGpio_mWriteReg(XPAR_PS2IO_BASEADDR, XGPIO_ISR_OFFSET, 1);
}

/* Write a text string on the display */


void updated_memory(void)
{
	int i;
	char *p;
	for (i=0; i<MAX_ROW_BLOCK_NUM;i++)
	{
		 *p = &(CHAR(0, i));
		 memcpy (p,grid[i],40);
	}
}		 


int main (void) 
{
	unsigned char key;
	struct  block  nextblock,mblock;
   int i;
   unsigned char updatedstatus;
    
    microblaze_enable_interrupts();
   /* Register the UART interrupt handler in the vector table */
   XIntc_RegisterHandler(XPAR_OPB_INTC_0_BASEADDR,XPAR_OPB_INTC_0_RS232_INTERRUPT_INTR,
      (XInterruptHandler)uart_int_handler,(void *)0);
   /* Register the keyboard interrupt handler */
   XIntc_RegisterHandler(XPAR_OPB_INTC_0_BASEADDR, XPAR_OPB_INTC_0_SYSTEM_PS2C_INTR,
      (XInterruptHandler)ps2_int_handler, (void *)0);
   /* Start the interrupt controller */
   XIntc_mMasterEnable(XPAR_OPB_INTC_0_BASEADDR);
   /* Enable timer and UART interrupt requests in the interrupt controller */
   XIntc_mEnableIntr(XPAR_OPB_INTC_0_BASEADDR,
                     XPAR_RS232_INTERRUPT_MASK | XPAR_SYSTEM_PS2C_MASK);
   /* Enable UART interrupts */
   XUartLite_mEnableIntr(XPAR_RS232_BASEADDR); 
   
   initial();
   nextblock=create(); 		
  loop: if(check_top(mblock)) initial();
  			
      mblock=nextblock;
      buildblock(mblock);
      nextblock=create();
     // show_next(nextblock);
   	updatedstatus=1;   
	while(1)
 	{ 
 		if(character_available()) 
 			key=get_character();
      else 
      	key=0;
      	
		if ( updatedstatus)
		{
			updated_memory();    
			updatedstatus=0;   
		}	
		switch(key)
     	{
     		case DOWN:     	
     			if(check_bottom(mblock)==1)
        		{  
        			if(! del_line(mblock.y))
  					{
  						mblock.color=DARKGRAY;
   					drawblock(mblock);
   				}
   				goto loop;
   			}
    			clear_block(mblock);
     			mblock.y=mblock.y+BLOCK_HEIGHT;
     			drawblock(mblock);  
     			updatedstatus=1; 				
    			break;
    			
       	case UP: 
       		change(mblock);
      		updatedstatus=1;       
       		break;
       
       	case LEFT:       	
       		break;
       		
       	case RIGHT:       
    			break;
    			
       
       default:
       	updatedstatus=1;
       	if(check_bottom(mblock)==1)
   		{  
   			if(del_line(mblock.y))
    			{ 
    				mblock.color=DARKGRAY;
    				drawblock(mblock);
    			}
    			goto loop;
   		}
    		clear_block(mblock);
     		mblock.y=mblock.y+BLOCK_HEIGHT;
     		drawblock(mblock);
     		
      	todelay();
        	break;
      }/*switch*/
   
  	}/*while*/  	

	return 0;
}
//-----------------------------------------------------------------------------
void  change(struct block cblock)// only left rotation
{	
	int i,j,i0,j0;
	unsigned char u;
	unsigned char tempblock[4][4];
	
	
	j0=(cblock.x-TOP_X)/BLOCK_WIDTH;/*?W誺?x,y?⦨???grid[i][j]U?i0,j0*/
	i0=(cblock.y-TOP_Y)/BLOCK_HEIGHT;
	
	for (i=0;i<4;i++)
	{
		for (j=0;j<4;j++)
		{
			tempblock[i][j]=magicblock[j][3-i];	
			if (grid[i0+i][j0+j])
			{
				if (magicblock[j][3-i])
						return ;
			}
		}
	}		
	clear_block(cblock);		
	
	for (i=0;i<4;i++)
	{
		for (j=0;j<4;j++)
		{
			magicblock[i][j]=tempblock[i][j];					
		}
	}				
	return cblock;			
}
	
	


//-------------------------------------------------------------------------
/*???A??????eblock??q*/ 
void buildblock(struct block drblock)
{
	unsigned char i,j;
	short int blockdata;
	blockdata=blocksharp[drblock.type];
	for (i=0;i<4;i++)
	{
		for (j=0;j<4;j++)
		{
			if (blockdata&0x8000)
				magicblock[i][j]=((drblock.color<4)+1) ;
			else
				magicblock[i][j]=0;
			blockdata =(blockdata<1);		
		}
	}
}	
//-------------------------------------------------------------------------
/*M??Aέ?eR??????eblock??q*/
void clear_block(struct block cblock)
{ 
	int i,j,i0,j0;
	
	
	
	
 	
}  
void drawblock(struct block drblock)
{
	int i0,j0,i,j;
	
	
	j0=(drblock.x-TOP_X)/BLOCK_WIDTH;/*?W誺?x,y?⦨???grid[i][j]U?i0,j0*/
	i0=(drblock.y-TOP_Y)/BLOCK_HEIGHT;
	for (i=3;i>0;i--)
 	{
 		for (j=0;j<4;j++)
 		{
 			grid[i0+i][j0+j]=magicblock[i][j]; 
 		}	
 	} 	
}

//-----------------------------------------------------------------------------
/*?A??????W誺??ȡApA^0A_?^1*/
int del_line(int ty)
{
	int i,j ,b,i0,k,ret;
	ret=0;
	
	if (ty>=MAX_Y) 
		return 0;
	i0=(ty-TOP_Y)/BLOCK_HEIGHT;
	//if(i0==19||i0==18||i0==17)//wait
	if(i0==(MAX_ROW_BLOCK_NUM-1)||i0==(MAX_ROW_BLOCK_NUM-2)||i0==(MAX_ROW_BLOCK_NUM-3))
		b=MAX_ROW_BLOCK_NUM-1;
	else 
		b=i0+3;
	for(k=i0;k<=b;k++)
 	{ 
 		for(j=0;j<MAX_CLOUMN_BLOCK_NUM;j++)
 		{
   		if(!grid[k][j])  
   		break;
   	}	
   	if(j==10)  
   	{
   		score++;
        	ret=1;
        	for(i=k;i>0;i--)
        	{
        		for(j=0;j<MAX_CLOUMN_BLOCK_NUM;j++)
  				{ 
  					grid[i][j]=grid[i-1][j];
      		}
  			}
     	}
 	}
	return ret;

}
//----------------------------------------------------------------------------
void todelay(void)
{
	int i,j;
	for(i=0;i<65535;i++)
	{
		for(j=0;j<65535;j++);
	}	
	
}	
//---------------------------------------------------------------------------
/*P??O_eΤUw??A?^1A_?^0*/
int check_bottom(struct block nblock)
{ 
	int j,i0,j0;
	int i;
	j0=((nblock.x-TOP_X)/BLOCK_WIDTH);
	i0=((nblock.y-TOP_Y)/BLOCK_HEIGHT);
 	for (i=3;i>0;i--)
 	{
 		for (j=0;j<4;j++)
 		{
 			if (magicblock[i][j])
 			{
 				
 				if ((i0==MAX_ROW_BLOCK_NUM)|| (grid[i0+i+1][j0+j]))
 					return 1;//BOTTOM 				
 			}	 			
 		}	
 	} 	
	return 0;
}
//----------------------------------------------------------------------------
/*P??O_e?,]O???ӡAp??^1A_?^0*/
int check_top(struct block tblock)
{ 
	if(tblock.y==TOP_Y)  
		return 1;
   else 
   	return 0;
}

//----------------------------------------------------------------------------
#define start_xadd		300
#define start_yadd		40

struct block create(void)
{
	struct block newblock ;
 	static int r;
 	
 	//r=rand(7);
 	switch(r++)
 	{
	 //case(0):	newblock.type='I';newblock.color=DARKGRAY; break;
  	 //case(1):newblock.type='O';newblock.color=BLUE; break;
    //case(2):newblock.type='T';newblock.color=BROWN; break;
    //case(3):newblock.type='L';newblock.color=YELLOW; break;
    //case(4):newblock.type='J';newblock.color=LIGHTGREEN; break;
    //case(5):newblock.type='Z';newblock.color=GREEN; break;
    //case(6):newblock.type='N';newblock.color=RED; break;
    case(0):newblock.color=DARKGRAY; break;
  	 case(1):newblock.color=BLUE; break;
    case(2):newblock.color=BROWN; break;
    case(3):newblock.color=YELLOW; break;
    case(4):newblock.color=LIGHTGREEN; break;
    case(5):newblock.color=GREEN; break;
    case(6):newblock.color=RED; break;
 	}
 	newblock.type=r;
 	
 	newblock.x=start_xadd;
 	newblock.y=start_yadd;
 	if (r> 7) 
 	 r =0;
 	return newblock;
}
//-----------------------------------------------------------------------
void initial(void)
{
	int i,j;
	
 	score=0;
 	interval=500;
 	for(i=0;i<MAX_ROW_BLOCK_NUM;i++)
 	{
  		for(j=0;j<MAX_CLOUMN_BLOCK_NUM;j++)
  		{
			grid[i][j]=0;
		}	
	} 
}	