/*
 *  * Copyright (c) 2004 Xilinx, Inc.  All rights reserved.
 *
 * Xilinx, Inc.
 * XILINX IS PROVIDING THIS DESIGN, CODE, OR INFORMATION "AS IS" AS A 
 * COURTESY TO YOU.  BY PROVIDING THIS DESIGN, CODE, OR INFORMATION AS
 * ONE POSSIBLE   IMPLEMENTATION OF THIS FEATURE, APPLICATION OR 
 * STANDARD, XILINX IS MAKING NO REPRESENTATION THAT THIS IMPLEMENTATION 
 * IS FREE FROM ANY CLAIMS OF INFRINGEMENT, AND YOU ARE RESPONSIBLE 
 * FOR OBTAINING ANY RIGHTS YOU MAY REQUIRE FOR YOUR IMPLEMENTATION
 * XILINX EXPRESSLY DISCLAIMS ANY WARRANTY WHATSOEVER WITH RESPECT TO 
 * THE ADEQUACY OF THE IMPLEMENTATION, INCLUDING BUT NOT LIMITED TO 
 * ANY WARRANTIES OR REPRESENTATIONS THAT THIS IMPLEMENTATION IS FREE 
 * FROM CLAIMS OF INFRINGEMENT, IMPLIED WARRANTIES OF MERCHANTABILITY 
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 */

// Located in: microblaze_0/include/xparameters.h
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <time.h>
#include <stdlib.h>
#define FONT_OFFSET 0xA00
#define ESC 0x11b  
#define UP 0x4800
#define DOWN 0x5000
#define LEFT 0x4b00
#define F1 0x3b00
#define RIGHT 0x4d00
#define YES 0x1579
#define NO 0x316e
#define RESTART 0x1372
#define DARKGRAY			0X05
#define BLUE				0X01
#define BROWN				0X07
#define YELLOW				0X06
#define LIGHTGREEN		0X03
#define GREEN				0X02
#define RED					0X04
#define WHITE				0X07

unsigned char grid[20][10];			/* msb 4 bits:0 no block,1: block moving ,2:block in */
unsigned char level,score;
int interval;	/*level--Ascore-- interval--time interval: */
static unsigned char I_SHAPE1[1][4]={1,1,1,1};/*IN???AOСФ*/
static unsigned char I_SHAPE2[4][1]={1,
                           1,
                           1,
                           1};
static unsigned char O_SHAPE[2][2]={1,1,
     1,1};
static unsigned char T_SHAPE1[2][3]={1,1,1,
      0,1,0};
static unsigned char T_SHAPE2[3][2]={0,1,
      1,1,
      0,1};
static unsigned char T_SHAPE3[2][3]={0,1,0,
      1,1,1};
static unsigned char T_SHAPE4[3][2]={1,0,
      1,1,
      1,0};
static unsigned char L_SHAPE1[3][2]={1,0,
      1,0,
      1,1};
static unsigned char L_SHAPE2[2][3]={1,1,1,
      1,0,0};
static unsigned char L_SHAPE3[3][2]={1,1,
      0,1,
      0,1};
static unsigned char L_SHAPE4[2][3]={0,0,1,
      1,1,1};
static unsigned char J_SHAPE1[3][2]={0,1,
      0,1,
      1,1 };
static unsigned char J_SHAPE2[2][3]={1,0,0,
      1,1,1};
static unsigned char J_SHAPE3[3][2]={1,1,
      1,0,
      1,0 };
static unsigned char J_SHAPE4[2][3]={1,1,1,
      0,0,1};
static unsigned char Z_SHAPE1[2][3]={1,1,0,
      0,1,1};
static unsigned char Z_SHAPE2[3][2]={0,1,
      1,1,
      1,0 };
static unsigned char N_SHAPE1[2][3]={0,1,1,
      1,1,0};
static unsigned char N_SHAPE2[3][2]={1,0,
      1,1,
      0,1 };

struct block
{unsigned char type;/*:I,O,T,L,J,Z,N*/
 unsigned char shape;
 int  x;
 int  y;
 unsigned char color;
};
void ini_graph();
int check_bottom();
int check_top();
int  check_lborder();
int  check_rborder();
int  del_line();
void initial();
void restart();

void show_next();
void drawblock();
void clear_block();

struct block create();/*??ͤ@?s?*/
struct block change();/*????*/
/* Address of a particular character on the screen (rows are 80) */
//sun modified #define CHAR(c,r) \
//sun modified   (((unsigned char *)(XPAR_VGA_BASEADDR))[(c) + ((r) << 6) + ((r) << 4)])

#define CHAR(c,r) \
   (((unsigned char *)(XPAR_VGA_BASEADDR))[(c) + ((r) << 5) + ((r) << 3)])

/* Start of font memory */
#define FONT ((unsigned char *)XPAR_VGA_BASEADDR + FONT_OFFSET)

int uart_interrupt_count = 0;
char uart_character;
 
/* UART interrupt service routine */
void uart_int_handler(void *baseaddr_p) {
   
   /* While UART receive FIFO has data */
   
}

/* Must be a power of two */
#define SCANCODE_BUFFER_SIZE 16
unsigned char scancode_buffer[SCANCODE_BUFFER_SIZE];
int scancode_buffer_head = 0;
int scancode_buffer_tail = 0;

int character_available()
{
  int result;
 
  return result;	
}

unsigned char get_character()
{
  unsigned char result;
 
  return result;		
}

int keyboard_interrupt_count = 0;
unsigned int scan_code = 0;
unsigned int keyboard_bit = 11;

/* PS/2 Keyboard interrupt service routine */
void ps2_int_handler(void *baseaddr_p)
{
  int next_head;
  keyboard_interrupt_count++;
 

}

/* Write a text string on the display */
void put_string(char *string, int column, int row)
{
 
}

int main (void) 
{
	unsigned char key;
	struct  block  nextblock,mblock;
   int i;
    
  	initial(); 
  	
  	
  	nextblock=create(); 		
  	
loop: if(check_top(mblock)) restart();
  			
      mblock=nextblock;
      nextblock=create();
      show_next(nextblock);
      
	while(1)
 	{ 
 		if(character_available()) 
 			key=get_character();
      else 
      	key=0;
     
     	switch(key)
     	{
     		case DOWN:
     			{ 
     				if(check_bottom(mblock)==1)
        			{  
        				if(! del_line(mblock.y))
  						{
  							mblock.color=DARKGRAY;
   						drawblock(mblock);
   					}
   					goto loop;
   				}
    				clear_block(mblock);
     				mblock.y=mblock.y+20;
     				drawblock(mblock);   				
   			}	
    			break;
    			
       	case UP: 
       		mblock=change(mblock);
       		break;
       
       	case LEFT: 
       		if(!check_lborder(mblock)&&!check_bottom(mblock))
       		{
       			clear_block(mblock);mblock.x-=20;
       		}  
       		break;
       		
       	case RIGHT:
       		if(!check_rborder(mblock)&&!check_bottom(mblock))
      		{
      			clear_block(mblock);mblock.x+=20;
      		}
    			break;
    			
       	case F1:
       		//test();
       		break;
       		
       	case ESC: 
       		//setfillstyle(1, DARKGRAY);
   			//bar(0,465,640,480);
   			//outtextxy(5,469,"Are you sure to exit (Y/N)...");
   			while(1)
     			{ 
     				if(character_available()) 
 						key=get_character();
      			else 
      				key=0;
       			if (key==NO)
               {
               	initial();
               	//help(420,200);
               	//showscore();
               	//printscore();
               	goto loop;
               }
               if(key==YES)
    				{
    					//closegraph();
    					exit(1);
    				}
      		}
      		break;
      		
       default:
       	{ 
       		if(check_bottom(mblock)==1)
   			{  
   				if(! del_line(mblock.y))
    				{ 
    					mblock.color=DARKGRAY;
    					drawblock(mblock);
    				}
    				goto loop;
   			}
    			clear_block(mblock);
     			mblock.y=mblock.y+20;
     			drawblock(mblock);
      		delay(interval);
        	}
      }/*switch*/
  }/*while*/
}

//----------------------------------------------------------------------------
/*P??O_e?,]O???ӡAp??^1A_?^0*/
int check_top(struct block tblock)
{ 
	if(tblock.y==40)  
		return 1;
   else 
   	return 0;
}
//----------------------------------------------------------------------------
/*P??O_ek?ɩΥkw??A?^1A_?^0
??????eblock???qA */
int check_rborder(struct block cblock)
{
	int i0,j0;
	j0=(cblock.x-200)/20;/*?W誺?x,y?⦨???grid[i][j]U?i0,j0*/
	i0=(cblock.y-40)/20;
	
	switch(cblock.type)
  	{
  		case('I'):
  			if(cblock.shape==1)
      	{
      		if(cblock.x+80>=400||grid[i0][j0+4]) 
      			return 1;
      	}/*w??ek?ɩΥ?w?*/
       	else 
       	{
       		if(cblock.x+20>=400||grid[i0][j0+1])
       		return 1;
       	}
  			break;
  			
   	case('O'): 
   		if(cblock.x+40>=400||grid[i0][j0+2]||grid[i0+1][j0+2])
  				return 1;   
  				break;
  				
   	case('T'): 
   		switch(cblock.shape)
        	{	
        		case(1): 
        			if(cblock.x+60>=400||grid[i0][j0+3]||grid[i0+1][j0+2])
       				return 1;
       			break;
       			
  				case(3): 
  					if(cblock.x+60>=400||grid[i0+1][j0+3]||grid[i0][j0+2])
       				return 1;
       			break;

  				case(2):
  					if(cblock.x+40>=400||grid[i0][j0+2]||grid[i0+1][j0+2]||grid[i0+2][j0+2])
     					return 1;
     				break;
     				
  				case(4):
  					if(cblock.x+40>=400||grid[i0][j0+1]||grid[i0+2][j0+1]||grid[i0+1][j0+2])
     					return 1;
     				break;
        	}
    		break;
    		
   		case('L'):
   			switch(cblock.shape)
        		{
        			case(1): 
        				if(cblock.x+40>=400||grid[i0+2][j0+2]||grid[i0][j0+1]||grid[i0+1][j0+1])
         				return 1;
         			break;
  					case(2): 
  						if(cblock.x+60>=400||grid[i0][j0+3]||grid[i0+1][j0+3])
     						return 1;
     					break;
  					case(3): 
  						if(cblock.x+40>=400||grid[i0][j0+2]||grid[i0+1][j0+2]||grid[i0+2][j0+2])
     						return 1;
     					break;
  					case(4): 
  						if(cblock.x+60>=400||grid[i0][j0+3]||grid[i0+1][j0+3])
         				return 1;
         			break;
        		} 
        		break;
        		
   		case('J'):
   			switch(cblock.shape)
       		{
       			case(1): 
       				if(cblock.x+40>=400||grid[i0][j0+2]||grid[i0+1][j0+2]||grid[i0+2][j0+2])
         				return 1;
         			break;
  					case(2):
  						if(cblock.x+60>=400||grid[i0][j0+1]||grid[i0+1][j0+3])
     						return 1;
     					break;
  					case(3): 
  						if(cblock.x+40>=400||grid[i0][j0+2]||grid[i0+1][j0+1]||grid[i0+2][j0+1])
     						return 1;
     					break;
  					case(4): 
  						if(cblock.x+60>=400||grid[i0][j0+3]||grid[i0+1][j0+3])
         				return 1;
         			break;
        		} 
        		break;
        		
   		case('Z'): 
   			switch(cblock.shape)
        		{
        			case(1): 
        				if(cblock.x+60>=400||grid[i0][j0+2]||grid[i0+1][j0+3])
       					return 1;
       				break;
  					case(2):
  						if(cblock.x+40>=400||grid[i0][j0+2]||grid[i0+1][j0+2]||grid[i0+2][j0+1])
     						return 1;
     					break;
        		}
        		break;
        		
   		case('N'): 
   			switch(cblock.shape)
        		{
        			case(1): 
        				if(cblock.x+60>=400||grid[i0][j0+3]||grid[i0+1][j0+2])
       					return 1;
       				break;
  					case(2):
  						if(cblock.x+40>=400||grid[i0][j0+1]||grid[i0+1][j0+2]||grid[i0+2][j0+2])
     						return 1;
     					break;
        		} 
        		break;
  	}
 	return 0;
}

//-----------------------------------------------------------------------------
/*P??O_e?ɩΥw??A?^1A_?^0
??????eblock???qA */
int check_lborder(struct block cblock)
{
	int i0,j0;
  	j0=(cblock.x-200)/20;
  	i0=(cblock.y-40)/20;
  	
  	if(cblock.x<=200) 
  		return 1;/*w??e?*/
  		
  	switch(cblock.type)
   {
   	case('I'):
   		if(grid[i0][j0-1]) 
   			return 1; 
   		break;/*?wL?*/
   		
    	case('O'):
    		if(grid[i0][j0-1]) 
    			return 1; 
    		break;
    		
    case('L'): 
    		switch(cblock.shape)
        	{
        		case(1):
        			if(grid[i0][j0-1]||grid[i0+1][j0-1]||grid[i0+2][j0-1])
    					return 1;  
    				break;
    				
        		case(2):
        			if(grid[i0][j0-1]||grid[i0+1][j0-1])
    					return 1;     
    				break;
    				
        		case(3):
        			if(grid[i0][j0-1]||grid[i0+1][j0]||grid[i0+2][j0])
     					return 1;   
     				break;
        		case(4): 
        			if(grid[i0][j0-1]||grid[i0+1][j0-1])
    					return 1;
    				break;
        	}           
        	break;
        	
    	case('J'):
    		switch(cblock.shape)
        	{
        		case(1):
        			if(grid[i0][j0]||grid[i0+1][j0]||grid[i0+2][j0-1])
      				return 1;  
      			break;
        		case(2):
        			if(grid[i0][j0-1]||grid[i0-1][j0-1])
    					return 1;     
    				break;
        		case(3):
        			if(grid[i0][j0-1]||grid[i0+1][j0-1]||grid[i0+2][j0-1])
     					return 1;   
     				break;
        		case(4): 
        			if(grid[i0][j0-1]||grid[i0+1][j0+1])
     					return 1;      
     				break;
        	}   
        	break;
        	
    	case('T'):
    		break;
    		
    	case('Z'):
    		break;
    		
    	case('N'):
    		break;
   }
    return 0;
}

//-----------------------------------------------------------------------------
struct block change(struct block cblock)
{	
	int i,j,i0,j0;
	j0=(cblock.x-200)/20;/*?W誺?x,y?⦨???grid[i][j]U?i0,j0*/
	i0=(cblock.y-40)/20;
 	switch(cblock.type)
 	{
 		case('I'):
 			switch(cblock.shape)
    		{ 
    			case(1):
    				if (grid[i0+2][j0+1]||grid[i0+3][j0+1])
       				return cblock;
       			clear_block(cblock); 
       			cblock.x+=20; 
       			cblock.shape++;
       			break;
       			
      		case(2):
      			if (grid[i0][j0-1]||grid[i0][j0+1] || grid[i0][j0+2]||cblock.x>=360||cblock.x<=200)
       					return cblock;/*pG??ZlWw?L?A
                                     ??Z?WX???*/
       			clear_block(cblock); 
       			cblock.x-=20;/*_?M??A?X??s?*/
               cblock.shape--;/*P@???JU@??*/
               break;
    		}
   		break;
   		
  		case('T'):
  			switch(cblock.shape)
     		{
     			case(1):
     				if(grid[i0-1][j0+1]) 
     					return cblock;
        			clear_block(cblock);cblock.y-=20;
       			cblock.shape++;  
       			break;
       			
      		case(2):
      			if(cblock.x>=360||grid[i0+1][j0+2])  
      				return cblock;
        			clear_block(cblock);
        			cblock.shape++;
        			break;
        			
      		case(3):
      			if(grid[i0-1][j0+1]||grid[i0][j0+2])
       				return cblock;
       			clear_block(cblock);
       			cblock.x+=20;
       			cblock.y-=20;
     				cblock.shape++;
     				break;
     				
      		case(4):
      			if(cblock.x<=200||grid[i0+1][j0-1])
      	 			return cblock;
       			clear_block(cblock);
       			cblock.y+=20;
       			cblock.x-=20;
       			cblock.shape=1;  
       			break;
     		}                      
     		break;
     		
  		case('L'):
  			switch(cblock.shape)
     		{
     			case(1):
     				if(grid[i0+2][j0-1]||grid[i0+1][j0+1]||cblock.x<=200)
       				return cblock;
       			clear_block(cblock);
       			cblock.y+=20; 
       			cblock.x-=20;
       			cblock.shape++;  
       			break;
       			
      		case(2): 
      			if(grid[i0-1][j0]||grid[i0-1][j0+1]||grid[i0+1][j0+1])
        				return cblock;
        			clear_block(cblock);cblock.y-=20;
        			cblock.shape++;break;
      		case(3): 
      			if(grid[i0+2][j0-1]||grid[i0+2][j0]||cblock.x<=200)
       				return cblock;
       			clear_block(cblock);
       			cblock.y+=20;
       			cblock.x-=20;
       			cblock.shape++;break;
      		case(4): 
      			if(grid[i0][j0+1]||grid[i0-1][j0+1])
        				return cblock;
        			clear_block(cblock);
        			cblock.y-=20;
        			cblock.x+=20;
       			cblock.shape=1;  
       			break;
     		}
     		break;
     		
  		case('J'): 
  			switch(cblock.shape)
     		{
     			case(1):
     				if(grid[i0+1][j0]||grid[i0+2][j0+2]||cblock.x>=360)
       				return cblock;
       			clear_block(cblock);
       			cblock.y+=20;
       			cblock.shape++;  
       			break;
      		case(2): 
      			if(grid[i0-1][j0+1]||grid[i0-1][j0])
       				return cblock;
       			clear_block(cblock);
       			cblock.y-=20;
       			cblock.shape++;
       			break;
       			
      		case(3):
      			if(grid[i0+1][j0+1]||grid[i0+2][j0+1]||grid[i0+1][j0-1])
       				return cblock;
       			clear_block(cblock);
       			cblock.y+=20;
       			cblock.x-=20;
        			if(grid[i0-1][j0]||grid[i0-1][j0+1]||cblock.x<=200)
       				return cblock;
       			cblock.shape++;
       			break;
       			
      		case(4): 
      			if(grid[i0-1][j0-2]||grid[i0+1][j0+1])
       				return cblock;
       			clear_block(cblock);
       			cblock.y-=20;
       			cblock.x+=20;
       			cblock.shape=1;  
       			break;
     		}
        	break;
        	
   	case('Z'):
   		switch(cblock.shape)
    		{ 
    			case(1):
    				if(grid[i0-1][j0+1]||grid[i0+1][j0])
       				return cblock;
       			clear_block(cblock);cblock.y-=20;
       			cblock.shape++;
       			break;
       			
      		case(2): 
      			if(grid[i0+2][j0+1]||grid[i0+2][j0+2])
        				return cblock;
        			clear_block(cblock);
        			cblock.y+=20;
        			cblock.shape--;break;
    		}
    		break;
    		
   	case('N'):
   		switch(cblock.shape)
    		{ 
    			case(1):
    				if(grid[i0][j0]||grid[i0-1][j0])
        				return cblock;
       			clear_block(cblock); 
       			cblock.y-=20;
       			cblock.shape++;
       			break;
       			
      		case(2):
      			if(grid[i0+2][j0]||grid[i0+1][j0+2]||cblock.x>=360)
       				return cblock;
       			clear_block(cblock); 
       			cblock.y+=20; 
       			cblock.shape--;
       			break;
    		}break;
 	}
	return cblock;/*^??Z?*/
}


//-----------------------------------------------------------------------------
/*?A??????W誺??ȡApA^0A_?^1*/
int del_line(int ty)
{
	int i,j ,b,i0,k,ret;
	
	ret=0;
	if (ty>=440) 
		return 0;
	i0=(ty-40)/20;
	if(i0==19||i0==18||i0==17)
		b=19;
	else 
		b=i0+3;
	for(k=i0;k<=b;k++)
 	{ 
 		for(j=0;j<10;j++)
 		{
   		if(!grid[k][j])  
   		break;
   	}	
   	if(j==10)  
   	{
   		score++;
        	ret=1;
        	for(i=k;i>0;i--)
        	{
        		for(j=0;j<10;j++)
  				{ 
  					grid[i][j]=grid[i-1][j];
      			if(!grid[i][j])
     				{
     					setfillstyle(1,LIGHTGREEN);
      				setcolor(WHITE);
      				rectangle(200+j*20,40+i*20,200+j*20+20,40+i*20+20);
      				floodfill(200+j*20+10,40+i*20+10,WHITE);
     				}
   				else 
   				{
   					setfillstyle(9,DARKGRAY);
         			setcolor(DARKGRAY);
         			rectangle(200+j*20,40+i*20,200+j*20+20,40+i*20+20);
         			floodfill(200+j*20+10,40+i*20+10,DARKGRAY);
         		}	
        		}
  			}
     	}
 	}
	return ret;
}

//---------------------------------------------------------------------------
/*P??O_eΤUw??A?^1A_?^0*/
int check_bottom(struct block nblock)
{ 
	int j,i0,j0;
	
 	j0=(nblock.x-200)/20;
 	i0=(nblock.y-40)/20;
 	
  	switch(nblock.type)
 	{
 		case('I'): 
 			if(nblock.shape==1)
        	{
        		if(nblock.y==420)  
        			return 1;/*w??e*/
  				for(j=0;j<4;j++)
  				{
  					if(grid[i0+1][j0+j]) 
  						return 1;/*I?U@w??*/
  				}		
        	}
        	if(nblock.shape==2)
        	{
        		if(nblock.y==360)  
        			return 1;
  				if(grid[i0+4][j0]) 
  					return 1;
        	}
        	break;
        	
  		case('O'): 
  			if(nblock.y==400) 
  				return 1;
      	for(j=0;j<2;j++)
      	{
      		if (grid[i0+2][j0+j]) 
      		return 1;
      	}	
      	break;
      	
  		case('T'):
  			switch(nblock.shape)
      	{
      		case(1):
      			if(nblock.y==400)  
      				return 1;
        			if(grid[i0+2][j0+1]||grid[i0+1][j0]||grid[i0+1][j0+2])
    					return 1;
        			break;
        			
       		case(2):
       			if(nblock.y==380) 
       				return 1;
        			if(grid[i0+3][j0+1]||grid[i0+2][j0]) 
        				return 1; 
        			break;
        			
       		case(3):
       			if(nblock.y==400) 
       				return 1;
        			for(j=0;j<3;j++)
        			{
        				if(grid[i0+2][j0+j]) 
        					return 1;  
        			}		
        			break;
        			
       		case(4):
       			if(nblock.y==380) 
       				return 1;
        			if(grid[i0+3][j0]||grid[i0+2][j0+1]) 
        				return 1;
        			break;
      	} 
      	break;
      	
  		case('L'): 
  			switch(nblock.shape)
      	{
      		case(1):
      			if (nblock.y>=380) 
      				return 1;
        			if (grid[i0+3][j0]||grid[i0+3][j0+1])
     					return 1;      
     				break;
     				
       		case(2):
       			if(nblock.y>=400) 
       				return 1;
        			if(grid[i0+2][j0]||grid[i0+1][j0+1]||grid[i0+1][j0+2])
        				return 1; 
        			break;
       		case(3):
       			if (nblock.y>=380) 
       				return 1;
        			if (grid[i0+3][j0+1]||grid[i0+1][j0])
     					return 1;      
     				break;
       		case(4):
       			if (nblock.y>=400) 
       				return 1;
    				for(j=0;j<3;j++)
    				{
     					if(grid[i0+2][j0+j])
     						return 1;      
     				}		
     				break;
      	}
      	break;
      	
  		case('J'):
  			switch(nblock.shape)
      	{
      		case(1):
      			if (nblock.y>=380) 
      				return 1;
        			if (grid[i0+3][j0]||grid[i0+3][j0+1])
     					return 1;      
     				break;
     				
       		case(2):
       			if (nblock.y>=400) 
       				return 1;
     				for(j=0;j<3;j++)
     				{
     					if(grid[i0+2][j0+j])
     						return 1;   
     				}		
     				break;
     				
       		case(3):
       			if (nblock.y>=380) 
       				return 1;
        			if (grid[i0+3][j0]||grid[i0+1][j0+1])
     					return 1;      
     				break;

       		case(4):
       			if (nblock.y>=400) 
       				return 1;
        			if (grid[i0+2][j0+2]||grid[i0+1][j0]||grid[i0+1][j0+1])
     					return 1;      
     				break;
      	}
      	break;
      	
  		case('Z'):
  			if (nblock.shape==1)
       	{ 
       		if(nblock.y==400) 
       			return 1;
  				if(grid[i0+1][j0]||grid[i0+2][j0+1]||grid[i0+2][j0+2])
      			return 1;    
      	}
     		if (nblock.shape==2)
       	{ 
       		if(nblock.y==380) 
       			return 1;
  				if(grid[i0+3][j0]||grid[i0+2][j0+1])
      			return 1;    
      	} 
      	break;
      	
  		case('N'):
  			if(nblock.shape==1)
        	{ 
        		if(nblock.y==400) 
        			return 1;
  				if(grid[i0+1][j0+2]||grid[i0+2][j0+1]||grid[i0+2][j0])
      			return 1;
        	}
      	if(nblock.shape==2)
        	{ 
        		if(nblock.y==380) 
        			return 1;
   			if(grid[i0+2][j0]||grid[i0+3][j0+1])
      			return 1;
        	}
        	break;
   }
	return 0;
}


//-------------------------------------------------------------------------
/*???A??????eblock??q*/ 
void drawblock(struct block drblock)
{
	int i0,j0,i,j;
	
	j0=(drblock.x-200)/20;/*?W誺?x,y?⦨???grid[i][j]U?i0,j0*/
	i0=(drblock.y-40)/20;
	setfillstyle(9,drblock.color);
	setcolor(drblock.color);
	
	switch(drblock.type)
 	{
 		case('I'):
 			if(drblock.shape==1)
     		{ 
     			for(j=0;j<4;j++)
       		{ 
       			rectangle(drblock.x+j*20,drblock.y,drblock.x+j*20+20,drblock.y+20);/*??l*/
  					floodfill(drblock.x+j*20+10,drblock.y+10,drblock.color);/*R?*/
  					grid[i0][j0+j]+=I_SHAPE1[0][j];/*?w??Ogrid??ۥ[*/
       		}                                /*??l?grid??N[1*/
     		}
    		if(drblock.shape==2)
     		{ 
     			for(i=0;i<4;i++)
       		{ 
       			rectangle(drblock.x,drblock.y+20*i,drblock.x+20,drblock.y+20*i+20);
  					floodfill(drblock.x+10,drblock.y+20*i+10,drblock.color);
  					grid[i0+i][j0]+=I_SHAPE2[i][0];
  				}
     		}
     		break;
     		
  		case('O'):
  			for(i=0;i<2;i++)
  			{
     			for(j=0;j<2;j++)
      		{
      			rectangle(drblock.x+i*20,drblock.y+j*20,drblock.x+i*20+20,drblock.y+j*20+20);
       			floodfill(drblock.x+i*20+10,drblock.y+j*20+10,drblock.color);
      			grid[i0+i][j0+j]+=O_SHAPE[i][j];
      		}
      	}	
     		break;
     		
  		case('T'): 
  			switch(drblock.shape)
      	{
      		case(1):
      			for(i=0;i<2;i++)
      			{
        				for(j=0;j<3;j++)
        				{
        					grid[i0+i][j0+j]+=T_SHAPE1[i][j] ;
         				if(T_SHAPE1[i][j]==1)
   						{
   							rectangle(drblock.x+j*20,drblock.y+i*20,drblock.x+j*20+20,drblock.y+i*20+20);
    							floodfill(drblock.x+j*20+10,drblock.y+i*20+10,drblock.color);
   						}
   					}	
        			}
        			break ;
        			
       		case(2):
       			for(i=0;i<3;i++)
       			{
        				for(j=0;j<2;j++)
        				{
        					grid[i0+i][j0+j]+=T_SHAPE2[i][j] ;
         				if(T_SHAPE2[i][j]==1)
   						{
   							rectangle(drblock.x+j*20,drblock.y+i*20,drblock.x+j*20+20,drblock.y+i*20+20);
    							floodfill(drblock.x+j*20+10,drblock.y+i*20+10,drblock.color);
   						}
   					}	
        			}
        			break ;
        			
       		case(3):
       			for(i=0;i<2;i++)
       			{
        				for(j=0;j<3;j++)
        				{
        					grid[i0+i][j0+j]+=T_SHAPE3[i][j] ;
         				if(T_SHAPE3[i][j]==1)
   						{
   							rectangle(drblock.x+j*20,drblock.y+i*20,drblock.x+j*20+20,drblock.y+i*20+20);
    							floodfill(drblock.x+j*20+10,drblock.y+i*20+10,drblock.color);
   						}
   					}	
        			}
        			break ;
        			
       		case(4): 
       			for(i=0;i<3;i++)
       			{
        				for(j=0;j<2;j++)
        				{
        					grid[i0+i][j0+j]+=T_SHAPE4[i][j] ;
         				if(T_SHAPE4[i][j]==1)
   						{
   							rectangle(drblock.x+j*20,drblock.y+i*20,drblock.x+j*20+20,drblock.y+i*20+20);
    							floodfill(drblock.x+j*20+10,drblock.y+i*20+10,drblock.color);
   						}
   					}	
         		} 
         		break ;
     		} 
     		break;
     		
  		case('L'):  
  			switch(drblock.shape)
      	{
      		case(1):
      			for(i=0;i<3;i++)
      			{
        				for(j=0;j<2;j++)
        				{
        					grid[i0+i][j0+j]+=L_SHAPE1[i][j] ;
         				if(L_SHAPE1[i][j]==1)
   						{
   							rectangle(drblock.x+j*20,drblock.y+i*20,drblock.x+j*20+20,drblock.y+i*20+20);
    							floodfill(drblock.x+j*20+10,drblock.y+i*20+10,drblock.color);
   						}
   					}	
        			} 
        			break ;
        			
       		case(2):
       			for(i=0;i<2;i++)
       			{
        				for(j=0;j<3;j++)
        				{
        					grid[i0+i][j0+j]+=L_SHAPE2[i][j] ;
         				if(L_SHAPE2[i][j]==1)
   						{
   							rectangle(drblock.x+j*20,drblock.y+i*20,drblock.x+j*20+20,drblock.y+i*20+20);
    							floodfill(drblock.x+j*20+10,drblock.y+i*20+10,drblock.color);
   						}
   					}	
        			}  
        			break ;
        			
       		case(3):
       			for(i=0;i<3;i++)
       			{
        				for(j=0;j<2;j++)
        				{
        					grid[i0+i][j0+j]+=L_SHAPE3[i][j] ;
         				if(L_SHAPE3[i][j]==1)
   						{
   							rectangle(drblock.x+j*20,drblock.y+i*20,drblock.x+j*20+20,drblock.y+i*20+20);
    							floodfill(drblock.x+j*20+10,drblock.y+i*20+10,drblock.color);
    						}	
   					}
        			}
        			break ;
        			
       		case(4): 
       			for(i=0;i<2;i++)
       			{
        				for(j=0;j<3;j++)
        				{
        					grid[i0+i][j0+j]+=L_SHAPE4[i][j] ;
         				if(L_SHAPE4[i][j]==1)
   						{
   							rectangle(drblock.x+j*20,drblock.y+i*20,drblock.x+j*20+20,drblock.y+i*20+20);
    							floodfill(drblock.x+j*20+10,drblock.y+i*20+10,drblock.color);
   						}
   					}	
         		}      
         		break ;
     		}
        	break;
        		
  		case('J'): 
  			switch(drblock.shape)
      	{
      		case(1):
      			for(i=0;i<3;i++)
      			{
        				for(j=0;j<2;j++)
        				{
        					grid[i0+i][j0+j]+=J_SHAPE1[i][j] ;
         				if(J_SHAPE1[i][j]==1)
   						{
   							rectangle(drblock.x+j*20,drblock.y+i*20,drblock.x+j*20+20,drblock.y+i*20+20);
    							floodfill(drblock.x+j*20+10,drblock.y+i*20+10,drblock.color);
   						}
        				} 
        			}	
        			break ;
        			
       		case(2):
       			for(i=0;i<2;i++)
       			{
        				for(j=0;j<3;j++)
        				{
        					grid[i0+i][j0+j]+=J_SHAPE2[i][j] ;
         				if(J_SHAPE2[i][j]==1)
   						{
   							rectangle(drblock.x+j*20,drblock.y+i*20,drblock.x+j*20+20,drblock.y+i*20+20);
    							floodfill(drblock.x+j*20+10,drblock.y+i*20+10,drblock.color);
   						}
        				}  
        			}	
        			break ;
        			
       		case(3):
       			for(i=0;i<3;i++)
       			{
        				for(j=0;j<2;j++)
        				{
        					grid[i0+i][j0+j]+=J_SHAPE3[i][j] ;
         				if(J_SHAPE3[i][j]==1)
   						{
   							rectangle(drblock.x+j*20,drblock.y+i*20,drblock.x+j*20+20,drblock.y+i*20+20);
    							floodfill(drblock.x+j*20+10,drblock.y+i*20+10,drblock.color);
   						}
        				} 
        			}	
        			break;
        				
      		case(4): 
      			for(i=0;i<2;i++)
      			{
        				for(j=0;j<3;j++)
        				{
        					grid[i0+i][j0+j]+=J_SHAPE4[i][j] ;
         				if(J_SHAPE4[i][j]==1)
   						{
   							rectangle(drblock.x+j*20,drblock.y+i*20,drblock.x+j*20+20,drblock.y+i*20+20);
    							floodfill(drblock.x+j*20+10,drblock.y+i*20+10,drblock.color);
   						}
         			} 
         		}	
         		break ;
     		} 
     		break;
     			
  		case('Z'):
  			switch(drblock.shape)
     		{ 
     			case(1):
     				for(i=0;i<2;i++)
     				{
        				for(j=0;j<3;j++)
        				{
        					grid[i0+i][j0+j]+=Z_SHAPE1[i][j] ;
         				if(Z_SHAPE1[i][j]==1)
   						{
   							rectangle(drblock.x+j*20,drblock.y+i*20,drblock.x+j*20+20,drblock.y+i*20+20);
    							floodfill(drblock.x+j*20+10,drblock.y+i*20+10,drblock.color);
   						}
        				} 
        			}	
        			break ;
        				 
     			case(2):
     				for(i=0;i<3;i++)
     				{
        				for(j=0;j<2;j++)
        				{
        					grid[i0+i][j0+j]+=Z_SHAPE2[i][j] ;
         				if(Z_SHAPE2[i][j]==1)
   						{
   							rectangle(drblock.x+j*20,drblock.y+i*20,drblock.x+j*20+20,drblock.y+i*20+20);
    							floodfill(drblock.x+j*20+10,drblock.y+i*20+10,drblock.color);
   						}
        				}
        			}  
        			break ;
      	} 
      	break;
      		
		case('N'):
			switch(drblock.shape)
  			{ 
  				case(1):
     				for(i=0;i<2;i++)
     				{
        				for(j=0;j<3;j++)
        				{
        					grid[i0+i][j0+j]+=N_SHAPE1[i][j] ;
         				if(N_SHAPE1[i][j]==1)
   						{
   							rectangle(drblock.x+j*20,drblock.y+i*20,drblock.x+j*20+20,drblock.y+i*20+20);
    							floodfill(drblock.x+j*20+10,drblock.y+i*20+10,drblock.color);
   						}
        				} 
        			}	
        			break ;
        				
       		case(2):
      			for(i=0;i<3;i++)
      			{
        				for(j=0;j<2;j++)
        				{
        					grid[i0+i][j0+j]+=N_SHAPE2[i][j] ;
         				if(N_SHAPE2[i][j]==1)
   						{
   							rectangle(drblock.x+j*20,drblock.y+i*20,drblock.x+j*20+20,drblock.y+i*20+20);
    							floodfill(drblock.x+j*20+10,drblock.y+i*20+10,drblock.color);
   						}
        				}  
        			}	
        			break ;
      	} 
      	break;
 	}
}


//-------------------------------------------------------------------------
/*M??Aέ?eR??????eblock??q*/
void clear_block(struct block cblock)
{ 
	int i,j,i0,j0;
	j0=(cblock.x-200)/20;/*?W誺?x,y?⦨???grid[i][j]U?i0,j0*/
	i0=(cblock.y-40)/20;
	setfillstyle(1,LIGHTGREEN);/*?mR?el?*/
	setcolor(WHITE);/*`?e*/
  	switch(cblock.type)
 	{
 		case('I'):
 			if(cblock.shape==1)
     		{ 
     			for(j=0;j<4;j++)
       		{
       			rectangle(cblock.x+j*20,cblock.y,cblock.x+j*20+20,cblock.y+20);/*?el*/
  					floodfill(cblock.x+j*20+10,cblock.y+10,WHITE);/*R*/
  					grid[i0][j0+j]=0;/*MsAY?w???*/
       		}
       	}	
     
    		if(cblock.shape==2)
     		{
     			for(i=0;i<4;i++)
       		{ 
       			rectangle(cblock.x,cblock.y+20*i,cblock.x+20,cblock.y+20*i+20);
  					floodfill(cblock.x+10,cblock.y+20*i+10,WHITE);
  					grid[i0+i][j0]=0;
       		}
     		}
     		break;
     		
  		case('O'):
  			for(i=0;i<2;i++)
  			{
     			for(j=0;j<2;j++)
      		{
      			rectangle(cblock.x+i*20,cblock.y+j*20,cblock.x+i*20+20,cblock.y+j*20+20);
       			floodfill(cblock.x+i*20+10,cblock.y+j*20+10,WHITE);
      			grid[i0+i][j0+j]=0;
      		}
      	}	
     		break;
     		
  		case('T'): 
  			switch(cblock.shape)
      	{
      		case(1):
      			for(i=0;i<2;i++)
      			{
        				for(j=0;j<3;j++)
       				{ 
       					if(T_SHAPE1[i][j]==1)
   						{
   							rectangle(cblock.x+j*20,cblock.y+i*20,cblock.x+j*20+20,cblock.y+i*20+20);
    							floodfill(cblock.x+j*20+10,cblock.y+i*20+10,WHITE);
         					grid[i0+i][j0+j]=0 ;
         				}
        				}
        			}	
        			break ;

       		case(2):
       			for(i=0;i<3;i++)
       			{
        				for(j=0;j<2;j++)
        				{ 
        					if(T_SHAPE2[i][j]==1)
   						{
   							rectangle(cblock.x+j*20,cblock.y+i*20,cblock.x+j*20+20,cblock.y+i*20+20);
    							floodfill(cblock.x+j*20+10,cblock.y+i*20+10,WHITE);
    							grid[i0+i][j0+j]=0 ;
   						}
        				}  
        			}	
        			break ;
        			
       		case(3):
       			for(i=0;i<2;i++)
       			{
        				for(j=0;j<3;j++)
        				{ 
        					if(T_SHAPE3[i][j]==1)
   						{
   							rectangle(cblock.x+j*20,cblock.y+i*20,cblock.x+j*20+20,cblock.y+i*20+20);
    							floodfill(cblock.x+j*20+10,cblock.y+i*20+10,WHITE);
    							grid[i0+i][j0+j]=0;
   						}
   					}	
        			}
        			break ;
        			
       		case(4): 
       			for(i=0;i<3;i++)
       			{
        				for(j=0;j<2;j++)
        				{ 
        					if(T_SHAPE4[i][j]==1)
   						{
   							rectangle(cblock.x+j*20,cblock.y+i*20,cblock.x+j*20+20,cblock.y+i*20+20);
    							floodfill(cblock.x+j*20+10,cblock.y+i*20+10,WHITE);
         					grid[i0+i][j0+j]=0; 
         				}
         			}	
         		}
         		break ;         			
     			}
     			break;
     				
 			case('L'): 
 				switch(cblock.shape)
      		{
      			case(1):
      				for(i=0;i<3;i++)
      				{
        					for(j=0;j<2;j++)
        					{
        						if(L_SHAPE1[i][j]==1)
   							{
   								rectangle(cblock.x+j*20,cblock.y+i*20,cblock.x+j*20+20,cblock.y+i*20+20);
    								floodfill(cblock.x+j*20+10,cblock.y+i*20+10,WHITE);
    								grid[i0+i][j0+j]=0;
   							}
        					}
        				}	
        				break ;
        				
       			case(2):
       				for(i=0;i<2;i++)
       				{
        					for(j=0;j<3;j++)
        					{
        						if(L_SHAPE2[i][j]==1)
   							{
   								rectangle(cblock.x+j*20,cblock.y+i*20,cblock.x+j*20+20,cblock.y+i*20+20);
    								floodfill(cblock.x+j*20+10,cblock.y+i*20+10,WHITE);
     								grid[i0+i][j0+j]=0;
   							}
        					}  
        				}	
        				break ;
        				
       			case(3):
       				for(i=0;i<3;i++)
       				{
        					for(j=0;j<2;j++)
        					{
        						if(L_SHAPE3[i][j]==1)
   							{
   								rectangle(cblock.x+j*20,cblock.y+i*20,cblock.x+j*20+20,cblock.y+i*20+20);
    								floodfill(cblock.x+j*20+10,cblock.y+i*20+10,WHITE);
     								grid[i0+i][j0+j]=0;
   							}
        					}
        				}	
        				break ;
        				
       			case(4): 
       				for(i=0;i<2;i++)
       				{
        					for(j=0;j<3;j++)
        					{
        						if(L_SHAPE4[i][j]==1)
   							{
   								rectangle(cblock.x+j*20,cblock.y+i*20,cblock.x+j*20+20,cblock.y+i*20+20);
    								floodfill(cblock.x+j*20+10,cblock.y+i*20+10,WHITE);
     								grid[i0+i][j0+j]=0;
   							}
         				}
         			}	
         			break ;
     				}
        			break;
        			
  			case('J'): 
  				switch(cblock.shape)
      		{
      			case(1):
      				for(i=0;i<3;i++)
      				{
        					for(j=0;j<2;j++)
        					{	 
        						if(J_SHAPE1[i][j]==1)
   							{
   								rectangle(cblock.x+j*20,cblock.y+i*20,cblock.x+j*20+20,cblock.y+i*20+20);
    								floodfill(cblock.x+j*20+10,cblock.y+i*20+10,WHITE);
     								grid[i0+i][j0+j]=0;
   							}
        					}
        				}	
        				break ;
        				
       			case(2):
       				for(i=0;i<2;i++)
       				{
        					for(j=0;j<3;j++)
        					{ 
        						if(J_SHAPE2[i][j]==1)
   							{	
   								rectangle(cblock.x+j*20,cblock.y+i*20,cblock.x+j*20+20,cblock.y+i*20+20);
   								floodfill(cblock.x+j*20+10,cblock.y+i*20+10,WHITE);
    								grid[i0+i][j0+j]=0;
   							}
        					}
        				}	  
        				break ;
        				
       			case(3):
       				for(i=0;i<3;i++)
       				{
        					for(j=0;j<2;j++)
        					{
        						if(J_SHAPE3[i][j]==1)
   							{
   								rectangle(cblock.x+j*20,cblock.y+i*20,cblock.x+j*20+20,cblock.y+i*20+20);
    								floodfill(cblock.x+j*20+10,cblock.y+i*20+10,WHITE);
    								grid[i0+i][j0+j]=0;
   							}
   						}	
        				}
        				break;
        				
      			case(4): 
      				for(i=0;i<2;i++)
      				{
        					for(j=0;j<3;j++)
        					{ 
        						if(J_SHAPE4[i][j]==1)
   							{
   								rectangle(cblock.x+j*20,cblock.y+i*20,cblock.x+j*20+20,cblock.y+i*20+20);
    								floodfill(cblock.x+j*20+10,cblock.y+i*20+10,WHITE);
    								grid[i0+i][j0+j]=0;
    							}	
   						}
         			} 
         			break ;
     			} 
     			break;
     			
  			case('Z'):
  				switch(cblock.shape)
     			{ 
     				case(1):
     					for(i=0;i<2;i++)
     					{
        					for(j=0;j<3;j++)
        					{ 
        						if(Z_SHAPE1[i][j]==1)
   							{
   								rectangle(cblock.x+j*20,cblock.y+i*20,cblock.x+j*20+20,cblock.y+i*20+20);
    								floodfill(cblock.x+j*20+10,cblock.y+i*20+10,WHITE);
    								grid[i0+i][j0+j]=0;
   							}
        					}
        				}	 
        				break ;
        				
       			case(2):
       				for(i=0;i<3;i++)
       				{
        					for(j=0;j<2;j++)
        					{
        						if(Z_SHAPE2[i][j]==1)
   							{	
   								rectangle(cblock.x+j*20,cblock.y+i*20,cblock.x+j*20+20,cblock.y+i*20+20);
    								floodfill(cblock.x+j*20+10,cblock.y+i*20+10,WHITE);
    								grid[i0+i][j0+j]=0;
    							}	
   						}
        				} 
        				break ;
      		}
      		break;
      		
  		case('N'):
  			switch(cblock.shape)
     		{ 
     			case(1):
     				for(i=0;i<2;i++)
     				{
        				for(j=0;j<3;j++)
        				{ 
        					if(N_SHAPE1[i][j]==1)
   						{
   							rectangle(cblock.x+j*20,cblock.y+i*20,cblock.x+j*20+20,cblock.y+i*20+20);
    							floodfill(cblock.x+j*20+10,cblock.y+i*20+10,WHITE);
    							grid[i0+i][j0+j]=0;
    						}	
    					}   				
        			} 
        			break ;
        		
       		case(2):
       			for(i=0;i<3;i++)
       			{
        				for(j=0;j<2;j++)
        				{  
        					if(N_SHAPE2[i][j]==1)
   						{
   							rectangle(cblock.x+j*20,cblock.y+i*20,cblock.x+j*20+20,cblock.y+i*20+20);
    							floodfill(cblock.x+j*20+10,cblock.y+i*20+10,WHITE);
    							grid[i0+i][j0+j]=0;
   						}
        				}
        			}	  
        			break ;
      	}
	      break;
 	}
}  
//-----------------------------------------------------------------------  


//---------------------------------------------------------------------------- 
/* to display next block infomation at right corner*/
void show_next(struct block nextblock)
{
	int i,j,g[4][4];
	
 	switch (nextblock.type)
  	{
  		case('I'):   
  			for(j=0;j<4;j++)
   		{
   			rectangle(480+j*20,60,480+j*20+20,60+20);
    			floodfill(480+j*20+10,60+10,nextblock.color);
   		}   		
  			break;
  			
   	case('O'): 
   		for(i=0;i<2;i++)
   		{
       		for(j=0;j<2;j++)
       		{
       	 		rectangle(500+20*i,60+20*j,500+20*i+20,60+20*j+20);
       	 		floodfill(500+20*i+10,60+20*j+10,nextblock.color);
       	 	}	
       	}
       	break ;
       	
   	case('T'):   
   		for(i=0;i<2;i++)
   		{
  				for(j=0;j<3;j++)
   			{
   				g[i][j]=T_SHAPE1[i][j];
    				if(g[i][j]==1)
      			{ 
      				rectangle(480+j*20,60+i*20,480+j*20+20,60+i*20+20);
        				floodfill(480+j*20+10,60+i*20+10,nextblock.color);
      			}
   			}
   		}	
    		break;
    		
   	case('L'):
   		for(i=0;i<3;i++)
   		{
   			for(j=0;j<2;j++)
   			{
   				g[i][j]=L_SHAPE1[i][j];
    				if(g[i][j]==1)
      			{
      				rectangle(500+j*20,40+i*20,500+j*20+20,40+i*20+20);
        				floodfill(500+j*20+10,40+i*20+10,nextblock.color);
      			}
   			}
   		}	
   		break;

   	case('J') :  
   		for(i=0;i<3;i++)
   		{
   			for(j=0;j<2;j++)
   			{
   				g[i][j]=J_SHAPE1[i][j];
    				if(g[i][j]==1)
      			{ 
      				rectangle(500+j*20,40+i*20,500+j*20+20,40+i*20+20);
        				floodfill(500+j*20+10,40+i*20+10,nextblock.color);
      			}
      		}	
   		}
   		break;
   		
   	case('Z'):
   		for(i=0;i<2;i++)
   		{
   			for(j=0;j<3;j++)
   			{	
   				g[i][j]=Z_SHAPE1[i][j];
    				if(g[i][j]==1)
      			{ 
      				rectangle(500+j*20,60+i*20,500+j*20+20,60+i*20+20);
        				floodfill(500+j*20+10,60+i*20+10,nextblock.color);
      			}
   			}
   		}	
   		break;

   	case('N'):  
   		for(i=0;i<2;i++)
   		{
   			for(j=0;j<3;j++)
   			{
   				g[i][j]=N_SHAPE1[i][j];
    				if(g[i][j]==1)
      			{ 
      				rectangle(500+j*20,60+i*20,500+j*20+20,60+i*20+20);
        				floodfill(500+j*20+10,60+i*20+10,nextblock.color);
      			}
   			}
   		}	
   		break;
 	}
}  
    
  
//----------------------------------------------------------------------------  
void restart()
{ 
	int key;
     
   while(1)
   { 
		if(character_available()) 
 			key=get_character();
      else 
      	key=0;
   	
     	if (key==RESTART)
      {
      	initial();
      	return;
      }
     	if(key==ESC)
      	exit(1);
   }
}
struct block create(void)
{
	struct block newblock ;
 	int r;
 	r=rand(7);
 	switch(r)
 	{case(0):newblock.type='I';newblock.color=5; break;
  	 case(1):newblock.type='O';newblock.color=BLUE; break;
    case(2):newblock.type='T';newblock.color=BROWN; break;
    case(3):newblock.type='L';newblock.color=YELLOW; break;
    case(4):newblock.type='J';newblock.color=LIGHTGREEN; break;
    case(5):newblock.type='Z';newblock.color=GREEN; break;
    case(6):newblock.type='N';newblock.color=RED; break;
 	}
 	newblock.shape=1;
 	newblock.x=300;
 	newblock.y=40;
 	return newblock;
}

void initial(void)
{
	int i,j;
	
 	score=0;
 	interval=500;
 	for(i=0;i<20;i++)
 	{
  		for(j=0;j<10;j++)
  		{
			grid[i][j]=0;
		}	
	}
}