/*
 *  * Copyright (c) 2004 Xilinx, Inc.  All rights reserved.
 *
 * Xilinx, Inc.
 * XILINX IS PROVIDING THIS DESIGN, CODE, OR INFORMATION "AS IS" AS A 
 * COURTESY TO YOU.  BY PROVIDING THIS DESIGN, CODE, OR INFORMATION AS
 * ONE POSSIBLE   IMPLEMENTATION OF THIS FEATURE, APPLICATION OR 
 * STANDARD, XILINX IS MAKING NO REPRESENTATION THAT THIS IMPLEMENTATION 
 * IS FREE FROM ANY CLAIMS OF INFRINGEMENT, AND YOU ARE RESPONSIBLE 
 * FOR OBTAINING ANY RIGHTS YOU MAY REQUIRE FOR YOUR IMPLEMENTATION
 * XILINX EXPRESSLY DISCLAIMS ANY WARRANTY WHATSOEVER WITH RESPECT TO 
 * THE ADEQUACY OF THE IMPLEMENTATION, INCLUDING BUT NOT LIMITED TO 
 * ANY WARRANTIES OR REPRESENTATIONS THAT THIS IMPLEMENTATION IS FREE 
 * FROM CLAIMS OF INFRINGEMENT, IMPLIED WARRANTIES OF MERCHANTABILITY 
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 */
// Located in: microblaze_0/include/xparameters.h

#include "xparameters.h"
#include "xutil.h"
#include "xintc_l.h"
#include "xuartlite_l.h"
#include "xgpio_l.h"
#define  FONT_OFFSET 0x200

#define CHAR(c,r) \
   (((unsigned char *)(XPAR_VGA_BASEADDR))[(c) + ((r) << 4) + ((r) << 2)])

#define FONT ((unsigned char *)XPAR_VGA_BASEADDR + FONT_OFFSET)

void ShowTile(int, int, int);
void PlayerMove(int, int);
void Initiate();
int  PushBox(int, int, int, int);

const unsigned char  UPDIR    = 0x75;
const unsigned char  DOWNDIR  = 0x72;
const unsigned char  LEFTDIR  = 0x6b;
const unsigned char  RIGHTDIR = 0x74;
const unsigned char  ESCQUIT  = 0x76;
const unsigned char  RESET    = 0x2d;
const unsigned char  INTRO    = 0x05;
const unsigned char  STAGETWO = 0x06;

const int  TileRow        = 15;   
const int  TileCol        = 20;   

const int  Background     = 0;
const int  Wall           = 1;
const int  Box            = 2;
const int  Spot           = 3;
const int  Player         = 4;
const int  TwoRect        = 5;
const int  BoxMatch       = 6;

int  CurrentPlayerX;
int  CurrentPlayerY;          // keep track of the current position of player
int  PlayerCurrTile;          // keep trakc of player's current tile value


int TileMap [300]; 
      /* int TileMap[TileRow][TileCol] = {
      { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },    // row 0
      { 1, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 },    // row 1
      { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
      { 1, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 },    // row 3   
      { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
      { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
      { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
      { 1, 3, 0, 2, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 2, 0, 3, 1 },    // row 7
      { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
      { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
      { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
      { 1, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 },    // row 11
      { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
      { 1, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 },    // row 13
      { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 } };  // row 14 */


int  uart_interrupt_count = 0;
char uart_character;
unsigned char buf[1];


/* UART interrupt service routine */
void uart_int_handler(void *baseaddr_p) {
   
   /* While UART receive FIFO has data */
   while (!XUartLite_mIsReceiveEmpty(XPAR_RS232_BASEADDR)) {
     /* Read a character */
     uart_character = XUartLite_RecvByte(XPAR_RS232_BASEADDR);
     ++uart_interrupt_count;
   }
}

/* Must be a power of two */
#define SCANCODE_BUFFER_SIZE 16
unsigned char scancode_buffer[SCANCODE_BUFFER_SIZE];
int scancode_buffer_head = 0;
int scancode_buffer_tail = 0;

int character_available()
{
  int result;
  microblaze_disable_interrupts();
  result = scancode_buffer_head != scancode_buffer_tail;
  microblaze_enable_interrupts();
  return result;	
}

unsigned char get_character()
{
  unsigned char result;
  microblaze_disable_interrupts();
  result = scancode_buffer[scancode_buffer_tail];
  scancode_buffer_tail = (scancode_buffer_tail + 1) & (SCANCODE_BUFFER_SIZE - 1);
  microblaze_enable_interrupts();
  return result;		
}

int keyboard_interrupt_count = 0;
unsigned int scan_code = 0;
unsigned int keyboard_bit = 11;

/* PS/2 Keyboard interrupt service routine */
void ps2_int_handler(void *baseaddr_p)
{
  int next_head;
  keyboard_interrupt_count++;
 
  /* We're reading a scancode and the keyboard clock fell: sample the data */
  scan_code = (scan_code >> 1) |
      (XGpio_mReadReg(XPAR_PS2IO_BASEADDR, XGPIO_DATA_OFFSET) << 9);
  if (--keyboard_bit == 0) {
    /* keycode is ready */
    next_head = (scancode_buffer_head + 1) & (SCANCODE_BUFFER_SIZE - 1);
    if (next_head != scancode_buffer_tail) {
      /* buffer is not full; add the character */
      scancode_buffer[scancode_buffer_head] = scan_code;
      scancode_buffer_head = next_head;
    }
    keyboard_bit = 11;
    scan_code = 0;
  }
   
  /* Acknowledge the interrupt */
  XGpio_mWriteReg(XPAR_PS2IO_BASEADDR, XGPIO_ISR_OFFSET, 1);
}


void ShowTile(int tile, int column, int row) {
	
char *p = &(CHAR(column, row));
*p = tile;
return;
}


void PlayerMove(int dX, int dY) {

int token;
int nx, ny;
int res;

nx = CurrentPlayerX + dX;
ny = CurrentPlayerY + dY;

token = TileMap[(ny * TileCol)+ nx];

if ( (token == Background) && (PlayerCurrTile == Background) )
   { TileMap[(CurrentPlayerY * TileCol) + CurrentPlayerX] = Background;
     ShowTile(Background, (CurrentPlayerY * TileCol) + CurrentPlayerX, 0);
     CurrentPlayerX = nx; CurrentPlayerY = ny; 
     TileMap[(ny * TileCol) + nx] = Player;
     ShowTile (Player, (ny * TileCol) + nx, 0); return; }
if ( (token == Background) && (PlayerCurrTile == Spot) )
   { TileMap[(CurrentPlayerY * TileCol) + CurrentPlayerX] = Spot;
     ShowTile(Spot, (CurrentPlayerY * TileCol) + CurrentPlayerX, 0); 
     CurrentPlayerX = nx; CurrentPlayerY = ny; PlayerCurrTile = Background;
     TileMap[(ny * TileCol) + nx] = Player; 
     ShowTile(Player, (ny * TileCol) + nx, 0); return; }
if ( (token == Spot) && (PlayerCurrTile == Background) )
   { TileMap[(CurrentPlayerY * TileCol) + CurrentPlayerX] = Background;
     ShowTile(Background, (CurrentPlayerY * TileCol) + CurrentPlayerX, 0); 
     CurrentPlayerX = nx; CurrentPlayerY = ny; PlayerCurrTile = Spot;
     TileMap[(ny * TileCol) + nx] = Player;
     ShowTile(Player, (ny * TileCol) + nx, 0); return; }
if ( (token == Spot) && (PlayerCurrTile == Spot) )
   { TileMap[(CurrentPlayerY * TileCol) + CurrentPlayerX] = Spot;
     ShowTile(Spot, (CurrentPlayerY * TileCol) + CurrentPlayerX, 0);
     CurrentPlayerX = nx; CurrentPlayerY = ny;
     TileMap[(ny * TileCol) + nx] = Player;
     ShowTile(Player, (ny * TileCol) + nx, 0); return; }
if ( (token == Box) || (token == BoxMatch) )
   { res = PushBox (nx, ny, dX, dY);
     if ( res == 1 ){
	  CurrentPlayerX = nx; 
	  CurrentPlayerY = ny; return; }
   }    
if ( (token == Wall) ) { return; }

return;
}


int PushBox(int BoxX, int BoxY, int dX, int dY) {

int  nx, ny;
int  token, boxtoken;

nx = BoxX + dX;
ny = BoxY + dY;

boxtoken = TileMap[(BoxY * TileCol) + BoxX];
token    = TileMap[(ny * TileCol) + nx];

if ( (token == Background) && (PlayerCurrTile == Background) && (boxtoken == Box) )
   { TileMap[(ny * TileCol) + nx] = Box;
     ShowTile(Box, (ny * TileCol) + nx, 0);
     TileMap[(BoxY * TileCol) + BoxX] = Player;
     ShowTile(Player, (BoxY * TileCol) + BoxX, 0);
     TileMap[(CurrentPlayerY * TileCol) + CurrentPlayerX] = Background;
     ShowTile(Background, (CurrentPlayerY * TileCol) + CurrentPlayerX, 0); return 1; }
if ( (token == Background) && (PlayerCurrTile == Spot) && (boxtoken == Box) )
   { TileMap[(ny * TileCol) + nx] = Box;  // BoxMatch;
     ShowTile(Box, (ny * TileCol) + nx, 0);
     TileMap[(CurrentPlayerY * TileCol) + CurrentPlayerX] = Spot;
     ShowTile(Spot, (CurrentPlayerY * TileCol) + CurrentPlayerX, 0);
     PlayerCurrTile == Background;
     TileMap[(BoxY * TileCol) + BoxX] = Player;
     ShowTile(Player, (BoxY * TileCol) + BoxX, 0); return 1; }
if ( (token == Spot) && (PlayerCurrTile == Background) && (boxtoken == Box) )
   { TileMap[(ny * TileCol) + nx] = BoxMatch;
     ShowTile (BoxMatch, (ny * TileCol) + nx, 0);
     TileMap[(CurrentPlayerY * TileCol) + CurrentPlayerX] = Background;
     ShowTile(Background, (CurrentPlayerY * TileCol) + CurrentPlayerX, 0);
     TileMap[(BoxY * TileCol) + BoxX] = Player;
     ShowTile(Player, (BoxY * TileCol) + BoxX, 0); return 1; }
if ( (token == Spot) && (PlayerCurrTile == Spot) && (boxtoken == Box) )
   { TileMap[(ny * TileCol) + nx] = BoxMatch;
     ShowTile(BoxMatch, (ny * TileCol) + nx, 0);
     TileMap[(CurrentPlayerY * TileCol) + CurrentPlayerX] = Spot;
     ShowTile(Spot, (CurrentPlayerY * TileCol) + CurrentPlayerX, 0);
     PlayerCurrTile == Background;
     TileMap[(BoxY * TileCol) + BoxX] = Player;
     ShowTile(Player, (BoxY * TileCol) + BoxX, 0); return 1; }
if ( (token == Background) && (PlayerCurrTile == Background) && (boxtoken == BoxMatch) )
   { TileMap[(ny * TileCol) + nx] = Box;
     ShowTile(Box, (ny * TileCol) + nx, 0);
     TileMap[(CurrentPlayerY * TileCol) + CurrentPlayerX] = Background;
     ShowTile(Background, (CurrentPlayerY * TileCol) + CurrentPlayerX, 0);
     PlayerCurrTile == Spot;
     TileMap[(BoxY * TileCol) + BoxX] = Player;
     ShowTile(Player, (BoxY * TileCol) + BoxX, 0); return 1; }
if ( (token == Spot) && (PlayerCurrTile == Background) && (boxtoken == BoxMatch) )
   { TileMap[(ny * TileCol) + nx] = BoxMatch;
     ShowTile(BoxMatch, (ny * TileCol) + nx, 0);
     TileMap[(CurrentPlayerY * TileCol) + CurrentPlayerX] = Background;
     ShowTile(Background, (CurrentPlayerY * TileCol) + CurrentPlayerX, 0);
     PlayerCurrTile == Spot;
     TileMap[(BoxY * TileCol) + BoxX] = Player;
     ShowTile(Player, (BoxY * TileCol) + BoxX, 0); return 1; }
if ( (token == Background) && (PlayerCurrTile == Spot) && (boxtoken == BoxMatch) )
   { TileMap[(ny * TileCol) + nx] = Box;
     ShowTile(Box, (ny * TileCol) + nx, 0);
     TileMap[(CurrentPlayerY * TileCol) + CurrentPlayerX] = Spot;
     ShowTile(Spot, (CurrentPlayerY * TileCol) + CurrentPlayerX, 0);
     TileMap[(BoxY * TileCol) + BoxX] = Player;
     ShowTile(Player, (BoxY * TileCol) + BoxX, 0); return 1; }
if ( (token == Spot) && (PlayerCurrTile == Spot) && (boxtoken == BoxMatch) )
   { TileMap[(ny * TileCol) + nx] = BoxMatch;
     ShowTile(BoxMatch, (ny * TileCol) + nx, 0);
     TileMap[(CurrentPlayerY * TileCol) + CurrentPlayerX] = Spot;
     ShowTile(Spot, (CurrentPlayerY * TileCol) + CurrentPlayerX, 0);
     TileMap[(BoxY * TileCol) + BoxX] = Player;
     ShowTile(Player, (BoxY * TileCol) + BoxX, 0); return 1; }
if ( (token == Wall) || (token == Box) || (token == BoxMatch) ) { return 0; }

return 0;
}


void Initiate(){
int  Col,Row;

for ( Row=0; Row < TileRow; Row++ ){
      for ( Col=0; Col < TileCol; Col++ )  
      { TileMap[(Row * TileCol) + Col] = Background;
        ShowTile(Background, (Row * TileCol) + Col, 0); }
    }
TileMap [ ( 4 * 20) + 8 ] = Wall;
ShowTile(  Wall,( 4 * 20) + 8,0);
TileMap [ ( 4 * 20) + 9 ] = Wall;
ShowTile(  Wall,( 4 * 20) + 9,0);
TileMap [ ( 4 * 20) +10 ] = Wall;
ShowTile(  Wall,( 4 * 20) +10,0);
TileMap [ ( 4 * 20) +11 ] = Wall;
ShowTile(  Wall,( 4 * 20) +11,0);
TileMap [ ( 4 * 20) +12 ] = Wall;
ShowTile(  Wall,( 4 * 20) +12,0);
TileMap [ ( 5 * 20) + 8 ] = Wall;
ShowTile(  Wall,( 5 * 20) + 8,0);
TileMap [ ( 5 * 20) + 9 ] = Player;
ShowTile(Player,( 5 * 20) + 9,0);
TileMap [ ( 5 * 20) +11 ] = Wall;
ShowTile(  Wall,( 5 * 20) +11,0);
TileMap [ ( 5 * 20) +12 ] = Wall;
ShowTile(  Wall,( 5 * 20) +12,0);
TileMap [ ( 5 * 20) +13 ] = Wall;
ShowTile(  Wall,( 5 * 20) +13,0);
TileMap [ ( 6 * 20) + 8 ] = Wall;
ShowTile(  Wall,( 6 * 20) + 8,0);
TileMap [ ( 6 * 20) +10 ] =  Box;
ShowTile(   Box,( 6 * 20) +10,0);
TileMap [ ( 6 * 20) +13 ] = Wall;
ShowTile(  Wall,( 6 * 20) +13,0);
TileMap [ ( 7 * 20) + 7 ] = Wall;
ShowTile(  Wall,( 7 * 20) + 7,0);
TileMap [ ( 7 * 20) + 8 ] = Wall;
ShowTile(  Wall,( 7 * 20) + 8,0);
TileMap [ ( 7 * 20) + 9 ] = Wall;
ShowTile(  Wall,( 7 * 20) + 9,0);
TileMap [ ( 7 * 20) +11 ] = Wall;
ShowTile(  Wall,( 7 * 20) +11,0);
TileMap [ ( 7 * 20) +13 ] = Wall;
ShowTile(  Wall,( 7 * 20) +13,0);
TileMap [ ( 7 * 20) +14 ] = Wall;
ShowTile(  Wall,( 7 * 20) +14,0);
TileMap [ ( 8 * 20) + 7 ] = Wall;
ShowTile(  Wall,( 8 * 20) + 7,0);
TileMap [ ( 8 * 20) + 8 ] = Spot;
ShowTile(  Spot,( 8 * 20) + 8,0);
TileMap [ ( 8 * 20) + 9 ] = Wall;
ShowTile(  Wall,( 8 * 20) + 9,0);
TileMap [ ( 8 * 20) +11 ] = Wall;
ShowTile(  Wall,( 8 * 20) +11,0);
TileMap [ ( 8 * 20) +14 ] = Wall;
ShowTile(  Wall,( 8 * 20) +14,0);
TileMap [ ( 9 * 20) + 7 ] = Wall;
ShowTile(  Wall,( 9 * 20) + 7,0);
TileMap [ ( 9 * 20) + 8 ] = Spot;
ShowTile(  Spot,( 9 * 20) + 8,0);
TileMap [ ( 9 * 20) + 9 ] =  Box;
ShowTile(   Box,( 9 * 20) + 9,0);
TileMap [ ( 9 * 20) +12 ] = Wall;
ShowTile(  Wall,( 9 * 20) +12,0);
TileMap [ ( 9 * 20) +14 ] = Wall;
ShowTile(  Wall,( 9 * 20) +14,0);
TileMap [ (10 * 20) + 7 ] = Wall;
ShowTile(  Wall,(10 * 20) + 7,0);
TileMap [ (10 * 20) + 8 ] = Spot;
ShowTile(  Spot,(10 * 20) + 8,0);
TileMap [ (10 * 20) +12 ] =  Box;
ShowTile(   Box,(10 * 20) +12,0);
TileMap [ (10 * 20) +14 ] = Wall;
ShowTile(  Wall,(10 * 20) +14,0);
CurrentPlayerX = 9;
CurrentPlayerY = 5;  
PlayerCurrTile = Background;
for (Col=7; Col < 15; Col++){ 
TileMap[(11 * 20) + Col ] = Wall;
ShowTile(Wall, (11 * 20) + Col, 0);
}

return;
}


/*void Initiate() {

int  Col,Row;

for ( Row=0; Row < TileRow; Row++ ){
      for ( Col=0; Col < TileCol; Col++ )  
      { TileMap[(Row * TileCol) + Col] = Background;
        ShowTile(Background, (Row * TileCol) + Col, 0); }
    }
Col = 0;
while ( Col < TileCol ){
      Row = 0;
      TileMap[(Row * TileCol) + Col] = Wall;
      ShowTile(Wall, (Row * TileCol) + Col, 0);
      Col++; 
      }
Col = 0;
while (Col < TileCol){
      Row = 14;
      TileMap[(Row * TileCol) + Col] = Wall;
      ShowTile(Wall, (Row * TileCol) + Col, 0);
      Col++; 
      }
Row = 1;
for  (Row=1; Row < TileCol-1; Row++){
      Col = 0;
      TileMap[(Row * TileCol) + Col] = Wall;
      ShowTile(Wall, (Row * TileCol) + Col, 0);
      Col = 19;
      TileMap[(Row * TileCol) + Col] = Wall;
      ShowTile(Wall, (Row * TileCol) + Col, 0);
      }      
TileMap[(3 * 20)  +  9] = Box;
TileMap[(7 * 20)  +  3] = Box;
TileMap[(7 * 20) +  16] = Box;
TileMap[(11 * 20) +  9] = Box;
TileMap[(1 * 20)  +  9] = Spot;
TileMap[(7 * 20)  +  1] = Spot;
TileMap[(7 * 20)  + 18] = Spot;
TileMap[(13 * 20) +  9] = Spot;
ShowTile(Box, (3 * 20)  +  9, 0);
ShowTile(Box, (7 * 20)  +  3, 0);
ShowTile(Box, (7 * 20) +  16, 0);
ShowTile(Box, (11 * 20) +  9, 0);
ShowTile(Spot, (1 * 20)  +  9, 0);
ShowTile(Spot, (7 * 20)  +  1, 0);
ShowTile(Spot, (7 * 20)  + 18, 0);
ShowTile(Spot, (13 * 20) +  9, 0);
CurrentPlayerX = 9;
CurrentPlayerY = 7;  
TileMap[(CurrentPlayerY*TileCol) + CurrentPlayerX] = Player;  // set the initial position of player
ShowTile(Player, (CurrentPlayerY*TileCol) + CurrentPlayerX, 0);
PlayerCurrTile = Background;  // set the initial background tile of player

return;
}*/

int main (void) {
   
   int  Done = 0;
   int  i;
   /* Enable MicroBlaze interrupts */
   microblaze_enable_interrupts();
   /* Register the UART interrupt handler in the vector table */
   XIntc_RegisterHandler(XPAR_OPB_INTC_0_BASEADDR,XPAR_OPB_INTC_0_RS232_INTERRUPT_INTR,
      (XInterruptHandler)uart_int_handler,(void *)0);
   /* Register the keyboard interrupt handler */
   XIntc_RegisterHandler(XPAR_OPB_INTC_0_BASEADDR, XPAR_OPB_INTC_0_SYSTEM_PS2C_INTR,
      (XInterruptHandler)ps2_int_handler, (void *)0);
   /* Start the interrupt controller */
   XIntc_mMasterEnable(XPAR_OPB_INTC_0_BASEADDR);
   /* Enable timer and UART interrupt requests in the interrupt controller */
   XIntc_mEnableIntr(XPAR_OPB_INTC_0_BASEADDR,
                     XPAR_RS232_INTERRUPT_MASK | XPAR_SYSTEM_PS2C_MASK);
   /* Enable UART interrupts */
   XUartLite_mEnableIntr(XPAR_RS232_BASEADDR);
    
   //Intro();
   Initiate();
   while ( !Done ) {
    if (character_available())  { buf[0] = get_character(); putnum( buf[0] ); print("\r\n"); }
    if ( (buf[0] == UPDIR)   )  { i++; if ( i == 2 ) { PlayerMove(0 , -1); i = 0; } } 
    if ( (buf[0] == DOWNDIR) )  { i++; if ( i == 2 ) { PlayerMove(0 ,  1); i = 0; } }
    if ( (buf[0] == LEFTDIR) )  { i++; if ( i == 2 ) { PlayerMove(-1,  0); i = 0; } }
    if ( (buf[0] == RIGHTDIR))  { i++; if ( i == 2 ) { PlayerMove(1 ,  0); i = 0; } }
    if ( (buf[0] == RESET)   )  { Initiate(); }
    if (  buf[0] == ESCQUIT  )  { Done = 1; }
    buf[0] = 0;
   }
   
   return 0;
}
