/*
 * 
 * Copyright (c) 2004 Xilinx, Inc.  All rights reserved.
 */

// Located in: microblaze_0/include/xparameters.h
#include "xutil.h"
#include "xintc_l.h"
#include "xuartlite_l.h"
#include "xbasic_types.h"
#include "xparameters.h"
#include "xio.h"
#include "xgpio_l.h"


#define QTableBA0    0xc0030000
#define QTableBA1    0xc0030100
#define QTableBA2    0xc0030200
#define QTableBA3    0xc0030300
#define MCU_Buff_BA0 0xc0030400
#define MCU_Buff_BA1 0xc0030500
#define MCU_Buff_BA2 0xc0030600
#define MCU_Buff_BA3 0xc0030700
#define MCU_Buff_BA4 0xc0030800
#define MCU_Buff_BA5 0xc0030900
#define MCU_Buff_BA6 0xc0030a00
#define MCU_Buff_BA7 0xc0030b00
#define MCU_Buff_BA8 0xc0030c00
#define MCU_Buff_BA9 0xc0030d00

#define jpgBA        0xc0040000

#define MMAXADDR   0xc00FFFFF
#define DispBA     0xc0000003
#define DispBAEnd  0xc0025803

//------------------------------
#define MBASADDR   0xc0000000    //err at c03ffff4
#define MBASADDR1  0xc0001000    //       c03ffcd0
#define MBASADDR04 0xc00000AC    //       c03ff6e8

//#define MBASADDR   0xc03ffff4  //err at c07fffc4
//#define MBASADDR1  0xc03ffcd0  //       c07ffca0
//#define MBASADDR04 0xc03ff6e8  //       c07ff6b8 
//------------------------------

unsigned int *jpgptr = (unsigned int *)jpgBA;
volatile unsigned char jpgTxDone=0;
static int ByteIdx = 0;

int uart_interrupt_count = 0;
char uart_character;
//int x = 0,y = 0;
char buf[2];

#define EOF     (-1)
/*#define SPY*/
/* Leave structures in memory,output something and dump core in the event
   of a failure: */
#define DEBUG 0
#define Not_uBlaze 
//unsigned char MCU_ROW_Buffer[15360];
// unsigned char MCU_ROW_Buffer[1];

//unsigned char jpgfile[1]={};
/* 0xFF,0xD8,0xFF,0xE0,0x00,0x10,0x4A,0x46,
0x49,0x46,0x00,0x01,0x01,0x01,0x00,0x44,
0x00,0x44,0x00,0x00,0xFF,0xDB,0x00,0x43,
0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0xFF,0xDB,0x00,0x43,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0xFF,0xC0,
0x00,0x11,0x08,0x00,0x10,0x00,0x10,0x03,
0x01,0x22,0x00,0x02,0x11,0x01,0x03,0x11,
0x01,0xFF,0xC4,0x00,0x15,0x00,0x01,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x07,
0xFF,0xC4,0x00,0x21,0x10,0x00,0x02,0x02,
0x01,0x04,0x02,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x05,0x06,0x04,
0x16,0x08,0x03,0x07,0x14,0x15,0x00,0x17,
0x02,0x13,0x18,0xFF,0xC4,0x00,0x14,0x01,
0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xFF,0xC4,0x00,0x14,0x11,0x01,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xDA,0x00,0x0C,0x03,0x01,0x00,0x02,0x11,
0x03,0x11,0x00,0x3F,0x00,0x3F,0xFF,0x00,
0x1D,0xE7,0x13,0x84,0x57,0xF1,0x63,0x1A,
0x40,0xF4,0x95,0x9E,0x93,0x1F,0xF6,0x6C,
0x45,0x72,0xAD,0x47,0xAF,0xF5,0xBB,0x74,
0xB9,0x0B,0xA4,0xA5,0x7A,0x2F,0x17,0xE9,
0xFD,0x57,0xD3,0xC0,0xAB,0x7E,0x68,0xC7,
0x7A,0xFF,0x00,0x1F,0xA9,0xF4,0x5E,0xD2,
0x71,0x28,0x0B,0xF7,0xFF,0x00,0x00,0x9D,
0xB2,0x32,0xAC,0x36,0xA6,0x68,0x68,0xA6,
0x58,0x18,0xD2,0x62,0xB0,0x19,0x8C,0x9C,
0xC2,0xD8,0xB2,0x39,0x2D,0xA8,0xEA,0xAE,
0x81,0x19,0x3A,0x4B,0xC6,0x59,0x93,0x83,
0xB6,0x3E,0x88,0x53,0x60,0x28,0x23,0xE3,
0x0E,0x71,0x95,0x91,0x6F,0x4E,0x83,0x81,
0x11,0xD7,0x92,0x2E,0x0B,0x63,0x1C,0x68,
0xBA,0x46,0x26,0x07,0xFF,0xD9}; */
/*----------------------------------*/
/* JPEG format parsing markers here */
/*----------------------------------*/

#define SOI_MK	0xFFD8		/* start of image	*/
#define APP_MK	0xFFE0		/* custom, up to FFEF */
#define COM_MK	0xFFFE		/* commment segment	*/
#define SOF_MK	0xFFC0		/* start of frame	*/
#define SOS_MK	0xFFDA		/* start of scan	*/
#define DHT_MK	0xFFC4		/* Huffman table	*/
#define DQT_MK	0xFFDB		/* Quant. table		*/
#define DRI_MK	0xFFDD		/* restart interval	*/
#define EOI_MK	0xFFD9		/* end of image		*/
#define MK_MSK	0xFFF0

#define RST_MK(x)	( (0xFFF8&(x)) == 0xFFD0 )
			/* is x a restart interval ? */



/*-------------------------------------------------------- */
/* all kinds of macros here				*/
/*-------------------------------------------------------- */

#define first_quad(c)   ((c) >> 4)        /* first 4 bits in file order */
#define second_quad(c)  ((c) & 15)

#define HUFF_ID(hclass, id)       (2 * (hclass) + (id))

#define DC_CLASS        0
#define AC_CLASS        1


/*-------------------------------------------------------*/
/* JPEG data types here					*/
/*-------------------------------------------------------*/

typedef union {		/* block of pixel-space values */
  unsigned char	block[8][8];
  unsigned char	linear[64];
} PBlock;

typedef union {		
   int	block[8][8];
   int	linear[64];
} PBlockInt;


//PBlockInt *MCU_buff[10];

typedef union {		/* block of frequency-space values */
  int block[8][8];
  int linear[64];
} FBlock;


/* component descriptor structure */

typedef struct {
  unsigned char	CID;	/* component ID */
  unsigned char	IDX;	/* index of first block in MCU */

  unsigned char	HS;	/* sampling factors */
  unsigned char	VS;
  unsigned char	HDIV;	/* sample width ratios */
  unsigned char	VDIV;

  char		QT;	/* QTable index, 2bits 	*/
  char		DC_HT;	/* DC table index, 1bit */
  char		AC_HT;	/* AC table index, 1bit */
  int		PRED;	/* DC predictor value */
} cd_t;


/*--------------------------------------------*/
/* global variables here		      */
/*--------------------------------------------*/


extern cd_t   comp[3]; /* for every component, useful stuff */

//extern PBlock *MCU_buff[10];  /* decoded component buffer */
			      /* between IDCT and color convert */
extern int    MCU_valid[10];  /* for every DCT block, component id then -1 */


			 
/* picture attributes */
extern int x_size, y_size;	/* Video frame size     */
extern int rx_size, ry_size;	/* down-rounded Video frame size */
				/* in pixel units, multiple of MCU */
extern int MCU_sx, MCU_sy;  	/* MCU size in pixels   */
extern int mx_size, my_size;	/* picture size in units of MCUs */
extern int n_comp;		/* number of components 1,3 */

/* processing cursor variables */
extern int in_frame, curcomp, MCU_row, MCU_column;
			/* current position in MCU unit */

/* RGB buffer storage */
extern PBlock        *PBuff;
extern FBlock        *FBuff;

/* process statistics */
extern int stuffers;	/* number of stuff bytes in file */
extern int passed;	/* number of bytes skipped looking for markers */

extern int verbose;


/*-----------------------------------------*/
/* prototypes from utils.c		   */
/*-----------------------------------------*/


extern int      ceil_div(int N, int D);
extern int      floor_div(int N, int D);
extern int	reformat(unsigned long S, int good);
//extern void     free_structures();
//extern void	aborted_stream(unsigned char *fi);

/*-----------------------------------------*/
/* prototypes from parse.c		   */
/*-----------------------------------------*/

extern void	clear_bits();
extern unsigned long	get_bits(unsigned char *fi, int number);
extern unsigned char	get_one_bit(unsigned char *fi);
//extern unsigned int	get_size(unsigned char *fi);
//extern unsigned int	aget_size();
extern unsigned int     get_next_MK(unsigned char *fi);
extern int	load_quant_tables(unsigned char *fi);
extern int      init_MCU();
extern void     skip_segment(unsigned char *fi);
extern int      process_MCU(unsigned char *fi);

/*-------------------------------------------*/
/* prototypes from fast_idct.c               */
/*-------------------------------------------*/

extern void	IDCT(const FBlock *S, PBlock *T);

/*-----------------------------------------*/
/* prototypes from color.c		   */
/*-----------------------------------------*/

//extern void	color_conversion(void);

/*-------------------------------------------*/
/* prototypes from table_vld.c or tree_vld.c */
/*-------------------------------------------*/

extern int	load_huff_tables(unsigned char *fi);
extern unsigned char    get_symbol(unsigned char *fi, int select);

/*-----------------------------------------*/
/* prototypes from huffman.c 		   */
/*-----------------------------------------*/

extern void	unpack_block(unsigned char *fi, FBlock *T, int comp);
		/* unpack, predict, dequantize, reorder on store */

/*-----------------------------------------*/
/* prototypes from spy.c		   */
/*-----------------------------------------*/

extern void 	trace_bits(int number, int type);
extern void	output_stats(char *dumpfile);

/*---------------------------------------------*/
/* File : fast_idct.c, utilities for jfif view */
/* Author : Pierre Guerrier, march 1998	       */
/* IDCT code by Geert Janssen	     	       */
/*---------------------------------------------*/

#define Y(i,j)		Y[8*i+j]
#define X(i,j)		(output->block[i][j])

/* This version is IEEE compliant using 16-bit arithmetic. */

/* The number of bits coefficients are scaled up before 2-D IDCT: */
#define S_BITS	         3
/* The number of bits in the fractional part of a fixed point constant: */
#define C_BITS		14

#define SCALE(x,n)	((x) << (n))

/* This version is vital in passing overall mean error test. */
#define DESCALE(x, n)	(((x) + (1 << ((n)-1)) - ((x) < 0)) >> (n))

#define ADD(x, y)	((x) + (y))
#define SUB(x, y)	((x) - (y))
#define CMUL(C, x)	(((C) * (x) + (1 << (C_BITS-1))) >> C_BITS)

/* Butterfly: but(a,b,x,y) = rot(sqrt(2),4,a,b,x,y) */
#define but(a,b,x,y)	{ x = SUB(a,b); y = ADD(a,b); }

/*-------------------------------------------*/
/* File : huffman.c, utilities for jfif view */
/* Author : Pierre Guerrier, march 1998	     */
/*-------------------------------------------*/

/*--------------------------------------*/
/* private huffman.c defines and macros */
/*--------------------------------------*/

#define HUFF_EOB		0x00
#define HUFF_ZRL		0xF0

/*------------------------------------------*/
/* some constants for on-the-fly IQ and IZZ */
/*------------------------------------------*/

static const int G_ZZ[] = {
   0,  1,  8, 16,  9,  2,  3, 10,
  17, 24, 32, 25, 18, 11,  4,  5,
  12, 19, 26, 33, 40, 48, 41, 34,
  27, 20, 13,  6,  7, 14, 21, 28,
  35, 42, 49, 56, 57, 50, 43, 36,
  29, 22, 15, 23, 30, 37, 44, 51,
  58, 59, 52, 45, 38, 31, 39, 46,
  53, 60, 61, 54, 47, 55, 62, 63
};

/*-----------------------------------------*/
/* File : tree_vld.c, utilities for jfif view */
/* Author : Pierre Guerrier, march 1998	   */
/*-----------------------------------------*/
/*--------------------------------------*/
/* private huffman.c defines and macros */
/*--------------------------------------*/

/* Number of HTable words sacrificed to bookkeeping: */
#define GLOB_SIZE		32

/* Memory size of HTables: */
#define MAX_SIZE(hclass)		((hclass)?384:64)

/* Available cells, top of storage: */
#define MAX_CELLS(hclass)	(MAX_SIZE(hclass) - GLOB_SIZE)

/* for Huffman tree descent */
/* lower 8 bits are for value/left son */

#define GOOD_NODE_FLAG		0x100
#define GOOD_LEAF_FLAG		0x200
#define BAD_LEAF_FLAG		0x300
#define SPECIAL_FLAG		0x000
#define HUFF_FLAG_MSK		0x300

#define HUFF_FLAG(c)		((c) & HUFF_FLAG_MSK)
#define HUFF_VALUE(c)		((unsigned char)( (c) & (~HUFF_FLAG_MSK) ))


/*--------------------------------------*/
/* some static structures for storage	*/
/*--------------------------------------*/

static unsigned int	DC_Table0[MAX_SIZE(DC_CLASS)],
			DC_Table1[MAX_SIZE(DC_CLASS)];

static unsigned int	AC_Table0[MAX_SIZE(AC_CLASS)],
			AC_Table1[MAX_SIZE(AC_CLASS)];

static unsigned int    *HTable[4] = {
  				      &DC_Table0[0], &DC_Table1[0],
				      &AC_Table0[0], &AC_Table1[0]
				    };

/*-----------------------------------------*/
/* File : jpeg.c, main for jfif decoder	   */
/* Author : Pierre Guerrier, march 1998	   */
/*                                         */
/* 19/01/99  Edited by Koen van Eijk       */
/*-----------------------------------------*/

/* real declaration of global variables here */
/* see jpeg.h for more info			*/

cd_t   comp[3];	      /* descriptors for 3 components */
PBlock MCU_buff_Resv[6]= {{1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8},
			   {1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8},
			   {1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8},
			   {1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8},
			   {1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8},
                  {1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8}
}; /* decoded DCT blocks buffer */

PBlock *MCU_buff[10];
int    MCU_valid[10]; /* components of above MCU blocks */

PBlock QT_Resv[4]={{1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8},
			   {1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8},
			   {1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8},
               {1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8,
               1,2,3,4,5,6,7,8}
};
//PBlockInt *QTable[4];  /* three quantization tables */
PBlock *QTable[4];  /* three quantization tables */
int    QTvalid[4];

int   x_size,y_size;	 /* Video frame size	 */
int   rx_size,ry_size;	 /* down-rounded Video frame size (integer MCU) */
int   MCU_sx, MCU_sy;	 /* MCU size in pixels	 */
int   mx_size, my_size;	 /* picture size in units of MCUs */
int   n_comp;		 /* number of components 1,3 */

//unsigned char ColorBuffer[384]; /* for 640*480 only, MCU after color conversion */
//unsigned char *FrameBuffer; /* complete final RGB image */
FBlock	      FBuff_Resv = {1,2,3,4,5,6,7,8,
                            1,2,3,4,5,6,7,8,
							1,2,3,4,5,6,7,8,
							1,2,3,4,5,6,7,8,
							1,2,3,4,5,6,7,8,
							1,2,3,4,5,6,7,8,
							1,2,3,4,5,6,7,8,
							1,2,3,4,5,6,7,8};	    /* mem reserve for scratch frequency buffer */
FBlock	      *FBuff;	    /* scratch frequency buffer */

PBlock	      PBuff_Resv = {1,2,3,4,5,6,7,8,
                            1,2,3,4,5,6,7,8,
							1,2,3,4,5,6,7,8,
							1,2,3,4,5,6,7,8,
							1,2,3,4,5,6,7,8,
							1,2,3,4,5,6,7,8,
							1,2,3,4,5,6,7,8,
							1,2,3,4,5,6,7,8};	    /* mem reserve for scratch frequency buffer */

PBlock	      *PBuff;	    /* scratch pixel buffer */

int	in_frame, curcomp;   /* frame started ? current component ? */
int	MCU_row, MCU_column; /* current position in MCU unit */

int stuffers = 0;	/* stuff bytes in entropy coded segments */
int passed = 0;		/* bytes passed when searching markers */

int verbose = 1;


/*-----------------------------------------*/
/* File : parse.c, utilities for jfif view */
/* Author : Pierre Guerrier, march 1998	   */
/*-----------------------------------------*/

/*---------------------------------------------------------------------*/


/* utility and counter to return the number of bits from file */
/* right aligned, masked, first bit towards MSB's		*/

static unsigned char bit_count;	/* available bits in the window */
static unsigned char window;

unsigned char agetc()
{
  static unsigned int word_data;
  unsigned char a;
  if ( (ByteIdx%4) == 0 )   word_data = *jpgptr++;
  switch (ByteIdx%4) {
    case 0 : a = (unsigned char)(word_data>>24); break;
    case 1 : a = (unsigned char)((word_data&0x00ffffff)>>16); break;
    case 2 : a = (unsigned char)((word_data&0x0000ffff)>> 8); break;
    case 3 : a = (unsigned char) (word_data&0x000000ff);      break;
    default : break;
  }
  ByteIdx++;
  return (a);
}

void DisplayErrMessage()
{
}

void DisplayDoneMessage()
{
}

/*-----------------------------------------*/
/* File : parse.c, utilities for jfif view */
/* Author : Pierre Guerrier, march 1998	   */
/*-----------------------------------------*/

/*---------------------------------------------------------------------*/


/* utility and counter to return the number of bits from file */
/* right aligned, masked, first bit towards MSB's		*/

unsigned long
get_bits(unsigned char *fi, int number)
{
  int i, newbit;
  unsigned long result = 0;
  unsigned char aux, wwindow;

  if (!number)
    return 0;

  for (i = 0; i < number; i++) {
    if (bit_count == 0) {
      wwindow = agetc();

      if (wwindow == 0xFF)
	switch (aux = agetc()) {	/* skip stuffer 0 byte */
	case EOF:
	case 0xFF:
	  DisplayErrMessage();
	  //aborted_stream(fi);
	  break;

	case 0x00:
	  stuffers++;
	  break;

	default:
	  if (RST_MK(0xFF00 | aux))
	  DisplayErrMessage();
	  //aborted_stream(fi);
	  break;
	}

      bit_count = 8;
    }
    else wwindow = window;
    newbit = (wwindow>>7) & 1;
    window = wwindow << 1;
    bit_count--;
    result = (result << 1) | newbit;
  }
  return result;
}


void
clear_bits(void)
{
  bit_count = 0;
}


unsigned char
get_one_bit(unsigned char *fi)
{
  int newbit;
  unsigned char aux, wwindow;

  if (bit_count == 0) {
    wwindow = agetc();

    if (wwindow == 0xFF)
      switch (aux = agetc()) {	/* skip stuffer 0 byte */
      case EOF:
      case 0xFF:
	DisplayErrMessage();
	//aborted_stream(fi);
	break;

      case 0x00:
	stuffers++;
	break;

      default:
	if (RST_MK(0xFF00 | aux))
	  DisplayErrMessage();
	//aborted_stream(fi);
	break;
      }

    bit_count = 8;
  } 
  else
    wwindow = window;

  newbit = (wwindow >> 7) & 1;
  window = wwindow << 1;
  bit_count--;
  return newbit;
}

/*----------------------------------------------------------*/


/* unsigned int
get_size(FILE *fi)
{
  unsigned char aux;

  aux = agetc();
  return (aux << 8) | agetc();	// big endian 
}  
*/
/*

unsigned int
*/
aget_size()
{
  unsigned char aux;

  aux = agetc();
  return (aux << 8) | agetc();	/* big endian */
}


/*----------------------------------------------------------*/


void
skip_segment(unsigned char *fi)	/* skip a segment we don't want */
{
  unsigned int size;
  char	tag[5];
  int i;

  size = aget_size();
  if (size > 5) {
    for (i = 0; i < 4; i++) 
      tag[i] = agetc();
    tag[4] = '\0';
    size -= 4;
  }
  //fseek(fi, size-2, SEEK_CUR);

//  ByteIdx=ByteIdx+(size-2);
  for (i=0; i<(size-2); i++){
    agetc();    
  }
}


/*----------------------------------------------------------------*/
/* find next marker of any type, returns it, positions just after */
/* EOF instead of marker if end of file met while searching ...	  */
/*----------------------------------------------------------------*/

unsigned int
get_next_MK(unsigned char *fi)
{
  unsigned int c;
  int ffmet = 0;
  int locpassed = -1;

  passed--;	/* as we fetch one anyway */

  while ((c = agetc()) != (unsigned int) EOF) {
    switch (c) {
    case 0xFF:
      ffmet = 1;
      break;
    case 0x00:
      ffmet = 0;
      break;
    default:
      if (ffmet)
	return (0xFF00 | c);
      ffmet = 0;
      break;
    }
    locpassed++;
    passed++;
  }

  return (unsigned int) EOF;
}


/*----------------------------------------------------------*/
/* loading and allocating of quantization table             */
/* table elements are in ZZ order (same as unpack output)   */
/*----------------------------------------------------------*/

int
load_quant_tables(unsigned char *fi)
{
  char aux;
  unsigned int size, n, i, id, x;

  size = aget_size(); /* this is the tables' size */
  n = (size - 2) / 65;

  for (i = 0; i < n; i++) {
    aux = agetc();
    if (first_quad(aux) > 0) {
	  DisplayErrMessage();  
	  return -1;
    }
    id = second_quad(aux);
    //0821a QTable[id] = (PBlock *) malloc(sizeof(PBlock));
/*    QTable[0] = (PBlockInt *)(QTableBA0);
    QTable[1] = (PBlockInt *)(QTableBA1);
    QTable[2] = (PBlockInt *)(QTableBA2);
    QTable[3] = (PBlockInt *)(QTableBA3); */
    QTable[0] = &QT_Resv[0];
    QTable[1] = &QT_Resv[1];
    QTable[2] = &QT_Resv[2];
    QTable[3] = &QT_Resv[3];

    QTvalid[id] = 1;
    for (x = 0; x < 64; x++)
      QTable[id]->linear[x] = agetc();
      /*
         -- This is useful to print out the table content --
         for (x = 0; x < 64; x++)
         fprintf(stderr, "%d\n", QTable[id]->linear[x]);
      */
  }
  return 0;
}


/*----------------------------------------------------------*/
/* initialise MCU block descriptors	                    */
/*----------------------------------------------------------*/

int init_MCU(void)
{
  int i, j, k, n, hmax = 0, vmax = 0;

  for (i = 0; i < 10; i++)
    MCU_valid[i] = -1;

  k = 0;

  for (i = 0; i < n_comp; i++) {
    if (comp[i].HS > hmax)
      hmax = comp[i].HS;
    if (comp[i].VS > vmax)
      vmax = comp[i].VS;
    n = comp[i].HS * comp[i].VS;

    comp[i].IDX = k;
    for (j = 0; j < n; j++) {
      MCU_valid[k] = i;
      MCU_buff[k] = &MCU_buff_Resv[k];
      k++;
      if (k == 10) {
	    DisplayErrMessage();  
	    return -1;
      }
    }
  }
/*  MCU_buff[0] = (PBlockInt *)MCU_buff_BA0;
  MCU_buff[1] = (PBlockInt *)MCU_buff_BA1;
  MCU_buff[2] = (PBlockInt *)MCU_buff_BA2;
  MCU_buff[3] = (PBlockInt *)MCU_buff_BA3;
  MCU_buff[4] = (PBlockInt *)MCU_buff_BA4;
  MCU_buff[5] = (PBlockInt *)MCU_buff_BA5;
  MCU_buff[6] = (PBlockInt *)MCU_buff_BA6;
  MCU_buff[7] = (PBlockInt *)MCU_buff_BA7;
  MCU_buff[8] = (PBlockInt *)MCU_buff_BA8;
  MCU_buff[9] = (PBlockInt *)MCU_buff_BA9;
*/

  MCU_sx = 8 * hmax;
  MCU_sy = 8 * vmax;
  for (i = 0; i < n_comp; i++) {
    comp[i].HDIV = (hmax / comp[i].HS > 1);	/* if 1 shift by 0 */
    comp[i].VDIV = (vmax / comp[i].VS > 1);	/* if 2 shift by one */
  }

  mx_size = ceil_div(x_size,MCU_sx);
  my_size = ceil_div(y_size,MCU_sy);
  rx_size = MCU_sx * floor_div(x_size,MCU_sx);
  ry_size = MCU_sy * floor_div(y_size,MCU_sy);

  return 0;
}


/*----------------------------------------------------------*/
/* this takes care for processing all the blocks in one MCU */
/*----------------------------------------------------------*/

int
process_MCU(unsigned char *fi)
{
  int  i,j;
  unsigned int offset;
  int  goodrows, goodcolumns;
  unsigned int *ptr;
//  unsigned int AddrIdx=0;
//  unsigned int MCU_row_offset, MCU_col_offset, MCU_V, MCU_H;
  unsigned int y_temp, y_disp;
  

  if (MCU_column == mx_size) {
    MCU_column = 0;
    MCU_row++;
    if (MCU_row == my_size) {
      in_frame = 0;
      return 0;
    }
  }

  for (curcomp = 0; MCU_valid[curcomp] != -1; curcomp++) {
    unpack_block(fi, FBuff, MCU_valid[curcomp]); /* pass index to HT,QT,pred */
    IDCT(FBuff, MCU_buff[curcomp]);
  }

  /* YCrCb to RGB color space transform here */
/*  if (n_comp > 1)
    color_conversion();
  else
    DisplayErrMessage(); 
*/

  /* cut last row/column as needed */
  if ((y_size != ry_size) && (MCU_row == (my_size - 1)))
    goodrows = y_size - ry_size;
  else
    goodrows = MCU_sy;

  if ((x_size != rx_size) && (MCU_column == (mx_size - 1)))
    goodcolumns = x_size - rx_size;
  else
    goodcolumns = MCU_sx;

  offset = n_comp * (MCU_row * MCU_sy * x_size + MCU_column * MCU_sx);
//  MCU_row_offset = MCU_row * MCU_sy * 640;
//  MCU_col_offset = MCU_column * MCU_sx;
//  ptr = (int *) DispBA;
  for (i = 0; i < goodrows; i++){
	for (j=0; j < goodcolumns; j++){
          //MCU_ROW_Buffer[ offset + n_comp * i * x_size + j] = ColorBuffer[n_comp * i * MCU_sx +j];
//          MCU_V = i * 640;
//          MCU_H = j ;
//          AddrIdx = (MCU_row_offset + MCU_col_offset + MCU_V + MCU_H )/8;
//          ptr = (unsigned int *) DispBA + AddrIdx;
          ptr = (unsigned int *) DispBA + ((MCU_row * MCU_sy * 640 + MCU_column * MCU_sx + i * 640 + j)>>3);
          if (i < 8) y_temp = (unsigned int)MCU_buff[j/8]->block[i][j%8];
            else     y_temp = (unsigned int)MCU_buff[(j/8)+2]->block[i%8][j%8];
          if ( y_temp >= 0x80 ) y_temp = 0x0f; else y_temp = 0x00; //black or white
          y_disp = (y_disp<<4) + y_temp;
          if ((j+1)%8 ==0) *ptr = y_disp;
          // *ptr = (unsigned int)0x22222222;
        }
   } // for

  
  MCU_column++;

  if (MCU_column == mx_size) {
//    MCU_ROW_RGB_save(fo);
  }

  return 1;
}


/*-----------------------------------------*/
/* File : utils.c, utilities for jfif view */
/* Author : Pierre Guerrier, march 1998	   */
/*-----------------------------------------*/


/*-------------------------------------------*/


/*----------------------------------------------------------*/

/* Returns ceil(N/D). */
int
ceil_div(int N, int D)
{
  int i = N/D;

  if (N > D*i) i++;
  return i;
}


/* Returns floor(N/D). */
int
floor_div(int N, int D)
{
  int i = N/D;

  if (N < D*i) i--;
  return i;
}

/* For all components reset DC prediction value to 0. */
void
reset_prediction(void)
{
  int i;

  for (i=0; i<3; i++) comp[i].PRED = 0;
}



/*---------------------------------------------------------*/


/* Transform JPEG number format into usual 2's-complement format. */
int
reformat(unsigned long S, int good)
{
  int St;
 
  if (!good)
    return 0;
  St = 1 << (good-1);	/* 2^(good-1) */
  if (S < (unsigned long) St)
    return (S+1+((-1) << good));
  else
    return S;
}


/*----------------------------------------------------------*/


/*-----------------------------------------*/
/* File : color.c, utilities for jfif view */
/* Author : Pierre Guerrier, march 1998	   */
/*-----------------------------------------*/

/* Ensure number is >=0 and <=255			   */
#define Saturate(n)	((n) > 0 ? ((n) < 255 ? (n) : 255) : 0)

/*------------------------------------------------------------*/


/* internal color conversion utility */
/*
static unsigned char
get_comp(int n, int i, int j)
{
  int ip = i >> comp[n].VDIV;	/ * get coordinates in n-th comp pixels * /
  int jp = j >> comp[n].HDIV;	/ * within the MCU * /

  return MCU_buff[comp[n].IDX+comp[n].HS*(ip>>3)+(jp>>3)]->block[ip&7][jp&7];
  / * this is the right block in MCU, and this right sample * /
}
*/
/* and alternate macro, a little faster */
/*
#define get_comp(t,n,i,j) { int ip = i >> comp[n].VDIV; \
			    int jp = j >> comp[n].HDIV; \
t = MCU_buff[comp[n].IDX+comp[n].HS*(ip>>3)+(jp>>3) ]->block[ip&7][jp& 7]; \
			}
*/

/*---------------------------------------*/
/* rules for color conversion:	         */
/*  r = y		+1.402	v	 */
/*  g = y -0.34414u	-0.71414v	 */
/*  b = y +1.772  u			 */
/* Approximations: 1.402 # 7/5 = 1.400	 */
/*		.71414 # 357/500 = 0.714 */
/*		.34414 # 43/125	= 0.344	 */
/*		1.772  = 443/250	 */
/*---------------------------------------*/
/* Approximations: 1.402 # 359/256 = 1.40234 */
/*		.71414 # 183/256 = 0.71484 */
/*		.34414 # 11/32 = 0.34375 */
/*		1.772 # 227/128 = 1.7734 */
/*----------------------------------*/

/* the space here originally is for color_conversion */
#if 0
void
color_conversion(void)
{
  int  i, j;
  unsigned char y,cb,cr;
  signed char rcb, rcr;
  long r,g,b;
  long offset;

  for (i = 0; i < MCU_sy; i++)   /* pixel rows */
    {
      int ip_0 = i >> comp[0].VDIV;
      int ip_1 = i >> comp[1].VDIV;
      int ip_2 = i >> comp[2].VDIV;
      int inv_ndx_0 = comp[0].IDX + comp[0].HS * (ip_0 >> 3);
      int inv_ndx_1 = comp[1].IDX + comp[1].HS * (ip_1 >> 3);
      int inv_ndx_2 = comp[2].IDX + comp[2].HS * (ip_2 >> 3);
      int ip_0_lsbs = ip_0 & 7;
      int ip_1_lsbs = ip_1 & 7;
      int ip_2_lsbs = ip_2 & 7;
      int i_times_MCU_sx = i * MCU_sx;

      for (j = 0; j < MCU_sx; j++)   /* pixel columns */
	{
	  int jp_0 = j >> comp[0].HDIV;
	  int jp_1 = j >> comp[1].HDIV;
	  int jp_2 = j >> comp[2].HDIV;
	  
	  y  = MCU_buff[inv_ndx_0 + (jp_0 >> 3)]->block[ip_0_lsbs][jp_0 & 7];
	  cb = MCU_buff[inv_ndx_1 + (jp_1 >> 3)]->block[ip_1_lsbs][jp_1 & 7];
	  cr = MCU_buff[inv_ndx_2 + (jp_2 >> 3)]->block[ip_2_lsbs][jp_2 & 7];

	  rcb = cb - 128;
	  rcr = cr - 128;
	  
	  r = y + ((359 * rcr) >> 8);
	  g = y - ((11 * rcb) >> 5) - ((183 * rcr) >> 8);
	  b = y + ((227 * rcb) >> 7);
	  
	  offset = 3 * (i_times_MCU_sx + j);
	  ColorBuffer[offset + 2] = Saturate(r);
	  ColorBuffer[offset + 1] = Saturate(g);
	  ColorBuffer[offset + 0] = Saturate(b);
	  /* note that this is SunRaster color ordering */
	}
    }
}

#endif

/*---------------------------------------------*/
/* File : fast_idct.c, utilities for jfif view */
/* Author : Pierre Guerrier, march 1998	       */
/* IDCT code by Geert Janssen	     	       */
/*---------------------------------------------*/

/* Inverse 1-D Discrete Cosine Transform.
   Result Y is scaled up by factor sqrt(8).
   Original Loeffler algorithm.
*/
static void
idct_1d(int *Y)
{
  int z1[8], z2[8], z3[8];

  /* Stage 1: */
  but(Y[0], Y[4], z1[1], z1[0]);
  /* rot(sqrt(2), 6, Y[2], Y[6], &z1[2], &z1[3]); */
  z1[2] = SUB(CMUL( 8867, Y[2]), CMUL(21407, Y[6]));
  z1[3] = ADD(CMUL(21407, Y[2]), CMUL( 8867, Y[6]));
  but(Y[1], Y[7], z1[4], z1[7]);
  /* z1[5] = CMUL(sqrt(2), Y[3]);
     z1[6] = CMUL(sqrt(2), Y[5]);
  */
  z1[5] = CMUL(23170, Y[3]);
  z1[6] = CMUL(23170, Y[5]);

  /* Stage 2: */
  but(z1[0], z1[3], z2[3], z2[0]);
  but(z1[1], z1[2], z2[2], z2[1]);
  but(z1[4], z1[6], z2[6], z2[4]);
  but(z1[7], z1[5], z2[5], z2[7]);

  /* Stage 3: */
  z3[0] = z2[0];
  z3[1] = z2[1];
  z3[2] = z2[2];
  z3[3] = z2[3];
  /* rot(1, 3, z2[4], z2[7], &z3[4], &z3[7]); */
  z3[4] = SUB(CMUL(13623, z2[4]), CMUL( 9102, z2[7]));
  z3[7] = ADD(CMUL( 9102, z2[4]), CMUL(13623, z2[7]));
  /* rot(1, 1, z2[5], z2[6], &z3[5], &z3[6]); */
  z3[5] = SUB(CMUL(16069, z2[5]), CMUL( 3196, z2[6]));
  z3[6] = ADD(CMUL( 3196, z2[5]), CMUL(16069, z2[6]));

  /* Final stage 4: */
  but(z3[0], z3[7], Y[7], Y[0]);
  but(z3[1], z3[6], Y[6], Y[1]);
  but(z3[2], z3[5], Y[5], Y[2]);
  but(z3[3], z3[4], Y[4], Y[3]);
}

/* Inverse 2-D Discrete Cosine Transform. */
void
IDCT(const FBlock *input, PBlock *output)
{
  int Y[64];
  int k,l;

  /* Pass 1: process rows. */
  for (k = 0; k < 8; k++) {

    /* Prescale k-th row: */
    for (l = 0; l < 8; l++)
      Y(k,l) = SCALE(input->block[k][l], S_BITS);

    /* 1-D IDCT on k-th row: */
    idct_1d(&Y(k,0));
    /* Result Y is scaled up by factor sqrt(8)*2^S_BITS. */
  }

  /* Pass 2: process columns. */
  for (l = 0; l < 8; l++) {
    int Yc[8];

    for (k = 0; k < 8; k++) Yc[k] = Y(k,l);
    /* 1-D IDCT on l-th column: */
    idct_1d(Yc);
    /* Result is once more scaled up by a factor sqrt(8). */
    for (k = 0; k < 8; k++) {
      int r = 128 + DESCALE(Yc[k], S_BITS+3); /* includes level shift */

      /* Clip to 8 bits unsigned: */
      r = r > 0 ? (r < 255 ? r : 255) : 0;
      X(k,l) = r;
    }
  }
}


/*-------------------------------------------*/
/* File : huffman.c, utilities for jfif view */
/* Author : Pierre Guerrier, march 1998	     */
/*-------------------------------------------*/

/*-------------------------------------------------*/
/* here we unpack, predict, unquantify and reorder */
/* a complete 8*8 DCT block ...			   */
/*-------------------------------------------------*/

void
unpack_block(unsigned char *fi, FBlock *T, int select)
{
  unsigned int i, run, cat;
  int value;
  unsigned char	symbol;

  /* Init the block with 0's: */
  for (i=0; i<64; i++) T->linear[i] = 0;

  /* First get the DC coefficient: */
  symbol = get_symbol(fi, HUFF_ID(DC_CLASS, comp[select].DC_HT));
  value = reformat(get_bits(fi, symbol), symbol);

  value += comp[select].PRED;
  comp[select].PRED = value;
  T->linear[0] = value * QTable[comp[select].QT]->linear[0];

  /* Now get all 63 AC values: */
  for (i=1; i<64; i++) {
    symbol = get_symbol(fi, HUFF_ID(AC_CLASS, comp[select].AC_HT));
    if (symbol == HUFF_EOB) break;
    if (symbol == HUFF_ZRL) { i += 15; continue; }
    cat = symbol & 0x0F;
    run = (symbol>>4) & 0x0F;
    i += run;
    value = reformat(get_bits(fi, cat), cat);

    /* Dequantify and ZigZag-reorder: */
    T->linear[G_ZZ[i]] = value * QTable[comp[select].QT]->linear[i];
  }
}

/*-----------------------------------------*/
/* File : tree_vld.c, utilities for jfif view */
/* Author : Pierre Guerrier, march 1998	   */
/*-----------------------------------------*/
/*--------------------------------------*/
/* private huffman.c defines and macros */
/*--------------------------------------*/

/*----------------------------------------------------------*/
/* Loading of Huffman table, with leaves drop ability	    */
/*----------------------------------------------------------*/

int load_huff_tables(unsigned char *fi)
{
  char aux;
  int size, hclass, id;
  int LeavesN, NodesN, CellsN;
  int MaxDepth, i, k, done;
  int NextCellPt;	/* where shall we put next cell */
  int NextLevelPt;	/* where shall node point to */
  unsigned int flag;

  size = aget_size(); /* this is the tables' size */

  size -= 2;

  while (size>0) {

    aux = agetc();
    hclass = first_quad(aux);	/* AC or DC */
    id = second_quad(aux);	/* table no */
    if (id>1) { 
	  DisplayErrMessage();  
      return -1;
    }
    id = HUFF_ID(hclass, id);
    size--;
    CellsN = NodesN = 1;      /* the root one */
    LeavesN = 0;

    for (i=0; i<MAX_CELLS(hclass); i++)
      HTable[id][i] = SPECIAL_FLAG;	/* secure memory with crash value */

    /* first load the sizes of code elements */
    /* and compute contents of each tree level */
    /* Adress	Content		*/
    /* Top		Leaves 0	*/
    /* Top-1	Nodes  0	*/
    /* ......	.......		*/
    /* Top-2k	Leaves k	*/
    /* Top-2k-1	Nodes  k	*/

    MaxDepth = 0;
    for (i=0; i<16; i++) {
      LeavesN = HTable[id][MAX_SIZE(hclass)-2*i-1] = agetc();
      CellsN = 2*NodesN; /* nodes is old */
      NodesN = HTable[id][MAX_SIZE(hclass)-2*i-2] = CellsN-LeavesN;
      if (LeavesN) MaxDepth = i;
    }
    size-=16;

    /* build root at address 0, then deeper levels at */
    /* increasing addresses until MAX_CELLS reached */

    HTable[id][0] = 1 | GOOD_NODE_FLAG;		/* points to cell _2_ ! */
    /* we give up address one to keep left brothers on even adresses */
    NextCellPt = 2;
    i = 0;		/* this is actually length 1 */

    done = 0;

    while (i<= MaxDepth) {

      /* then load leaves for other levels */
      LeavesN = HTable[id][MAX_SIZE(hclass)-2*i-1];
      for (k = 0; k<LeavesN; k++)
	if (!done) {
	  HTable[id][NextCellPt++] = agetc() | GOOD_LEAF_FLAG;	
	  if (NextCellPt >= MAX_CELLS(hclass)) {
	    done = 1;
	    DisplayErrMessage();  
	  }
	}
	else agetc();	/* throw it away, just to keep file sync */
      size -= LeavesN;

      if (done || (i == MaxDepth)) { i++; continue; }
      /* skip useless node building */

      /* then build nodes at that level */
      NodesN = HTable[id][MAX_SIZE(hclass)-2*i-2];

      NextLevelPt = NextCellPt+NodesN;
      for (k = 0; k<NodesN; k++) {
	if (NextCellPt >= MAX_CELLS(hclass)) { done = 1; break; }

	flag = ((NextLevelPt|1) >=
		MAX_CELLS(hclass)) ? BAD_LEAF_FLAG : GOOD_NODE_FLAG;
	/* we OR by 1 to check even right brother within range */
	HTable[id][NextCellPt++] = (NextLevelPt/2) | flag;
	NextLevelPt += 2;
      }

      i++;	/* now for next level */
    }	/* nothing left to read from file after maxdepth */


    /*
      -- this is useful for displaying the uploaded tree -- */
/*      for(i=0; i<NextCellPt; i++) {
      switch (HUFF_FLAG(HTable[id][i])) {
      case GOOD_NODE_FLAG:
      fprintf(stderr, "Cell %X: Node to %X and %X\n", i,
      HUFF_VALUE(HTable[id][i])*2,
      HUFF_VALUE(HTable[id][i])*2 +1);
      break;
      case GOOD_LEAF_FLAG:
      fprintf(stderr, "Cell %X: Leaf with value %X\n", i,
      HUFF_VALUE(HTable[id][i]) );
      break;
      case SPECIAL_FLAG:
      fprintf(stderr, "Cell %X: Special flag\n", i);
      break;
      case BAD_LEAF_FLAG:
      fprintf(stderr, "Cell %X: Bad leaf\n", i);
      break;
      }
      }*/
      /**/ 

  }	/* loop on tables */
  return 0;
}

/*-----------------------------------*/
/* extract a single symbol from file */
/* using specified huffman table ... */
/*-----------------------------------*/

unsigned char
get_symbol(unsigned char *fi, int select)
{
  int cellPt;

  cellPt = 0; /* this is the root cell */

  while (HUFF_FLAG(HTable[select][cellPt]) == GOOD_NODE_FLAG)
    cellPt = get_one_bit(fi) | (HUFF_VALUE(HTable[select][cellPt])<<1);

  switch (HUFF_FLAG(HTable[select][cellPt])) {
  case SPECIAL_FLAG:
	DisplayErrMessage();  
//    aborted_stream(fi);
    break;

  case GOOD_LEAF_FLAG:
    return HUFF_VALUE(HTable[select][cellPt]);
    break;

  case BAD_LEAF_FLAG:
    /* how do we fall back in case of truncated tree ? */
    /* suggest we send an EOB and warn */
	DisplayErrMessage();  
    return 0;
    break;

  default:
    break;
  }
  return 0;
}

/*void Wait4aSec(unsigned int *ptr )
{
  int i,a,b;
  for (i=0;i<1024*1024*10;i++)
    a=a*(b+1)/57;
}*/


/*********************************************************/
/*                         UART                          */
/*********************************************************/

/* UART interrupt service routine */
void uart_int_handler(void *baseaddr_p) {
  static unsigned int inum = 0;
  unsigned char c;
   /* While UART receive FIFO has data */
   while (!XUartLite_mIsReceiveEmpty(XPAR_RS232_BASEADDR)) {
     /* Read a character */
     uart_character = XUartLite_RecvByte(XPAR_RS232_BASEADDR);
//	   putnum(uart_interrupt_count);
      buf[0] = uart_character;
      c = buf[0];
      ++uart_interrupt_count;
      if (c>='0' && c<='9') c = c - 0x30; else c = c - 0x37;
      inum = (inum<<4) + (unsigned int)c;
      if ((uart_interrupt_count&0x7) == 0) {*jpgptr++ = inum;}
//      if (((uart_interrupt_count&0x3) == 0 ) && ((inum & 0x0000FFFF) == 0x0000FFD9)) *jpgptr = 0xFFD90000;
//      if (((inum & 0x0000FFFF) == 0x0000FFD9) || ((inum & 0xFFFF0000) == 0xFFD90000)) { jpgTxDone = 1;  }
      if ((inum & 0x0000FFFF) == 0x0000FFD9) { *jpgptr = (inum<<16); jpgTxDone = 1; }
      if ((inum & 0x00FFFF00) == 0x00FFD900) { *jpgptr = (inum<<8 ); jpgTxDone = 1; }
      if ((inum & 0xFFFF0000) == 0xFFD90000) {                       jpgTxDone = 1; }
   }
}

int main (int argc, char* argv[]) {
  unsigned int *ptr;
  char *fi;
  unsigned int aux, mark;
  int n_restarts, restart_interval, leftover; /* RST check */
  int i,j;

  jpgptr = (unsigned int *)jpgBA;
  ptr = (int *) MMAXADDR;
  *ptr = 0x000000f9; // Into force_mode
  
   /* Enable MicroBlaze interrupts */
   microblaze_enable_interrupts();
   /* Register the UART interrupt handler in the vector table */
   XIntc_RegisterHandler(XPAR_OPB_INTC_0_BASEADDR,XPAR_OPB_INTC_0_RS232_INTERRUPT_INTR,
      (XInterruptHandler)uart_int_handler,(void *)XPAR_RS232_BASEADDR);
   /* Start the interrupt controller */
   XIntc_mMasterEnable(XPAR_OPB_INTC_0_BASEADDR);
   /* Enable timer and UART interrupt requests in the interrupt controller */
   XIntc_mEnableIntr(XPAR_OPB_INTC_0_BASEADDR, XPAR_RS232_INTERRUPT_MASK);
   /* Enable UART interrupts */
   XUartLite_mEnableIntr(XPAR_RS232_BASEADDR);   

   
/*   
  ptr = (int *) DispBA;
  for (row = 0 ; row < 480 ; row++) {
     for (col = 0 ; col < 80 ; col++){
       WriteData = 0x00000000;
       *ptr = WriteData;
       ptr++;
     }
   } 
*/
/*  ptr = (int *) MMAXADDR;
  *ptr = 0x00000001; // Video display mode
  
  while(1);*/

/**********************************************************************/ 

  while (jpgTxDone == 0) 
  {;}  // if jpgTxDone == 1 then begin to decode jpeg file
  
  jpgptr = (unsigned int *)jpgBA;
  //print("c");
//  putnum(*jpgptr);
//  fi=&jpgfile[0];
  fi = (unsigned char *)jpgBA;

  /* First find the SOI marker: */
  aux = get_next_MK(fi);
  if (aux != SOI_MK){
    return 1;
    //    DisplayErrMessage();
  }
//    aborted_stream(fi);


  in_frame = 0;
  restart_interval = 0;
  for (i = 0; i < 4; i++)
    QTvalid[i] = 0;

  /* Now process segments as they appear: */
  do {
    mark = get_next_MK(fi);

    switch (mark) {
    case SOF_MK:
      in_frame = 1;
      aget_size();	/* header size, don't care */

      /* load basic image parameters */
      agetc();	/* precision, 8bit, don't care */
      y_size = aget_size();
      x_size = aget_size();

      n_comp = agetc();	/* # of components */

      for (i = 0; i < n_comp; i++) {
	/* component specifiers */
	comp[i].CID = agetc();
	aux = agetc();
	comp[i].HS = first_quad(aux);
	comp[i].VS = second_quad(aux);
	comp[i].QT = agetc();
      }

      if (init_MCU() == -1)
	;//aborted_stream(fi);

      /* dimension scan buffer for YUV->RGB conversion */

      FBuff = &FBuff_Resv;
      PBuff = &PBuff_Resv;

/*    FBuff = (FBlock *) malloc(sizeof(FBlock));
      PBuff = (PBlock *) malloc(sizeof(PBlock)); */

      break;

    case DHT_MK:
      if (load_huff_tables(fi) == -1)
	;//aborted_stream(fi);
      break;

    case DQT_MK:
      if (load_quant_tables(fi) == -1)
	;//aborted_stream(fi);
      break;

    case DRI_MK:
      aget_size();	/* skip size */
      restart_interval = aget_size();
      break;	

    case SOS_MK:		/* lots of things to do here */
      aget_size(); /* don't care */
      aux = agetc();
      if (aux != (unsigned int) n_comp) {
	    DisplayErrMessage();
	    //aborted_stream(fi);
      }

      for (i = 0; i < n_comp; i++) {
	    aux = agetc();
	    if (aux != comp[i].CID) {
	      DisplayErrMessage();
	      //aborted_stream(fi);
		}
	    aux = agetc();
	    comp[i].DC_HT = first_quad(aux);
	    comp[i].AC_HT = second_quad(aux);
      }
      aget_size(); agetc();	/* skip things */

      MCU_column = 0;
      MCU_row = 0;
      clear_bits();
      reset_prediction();

//      Header_save(fo);


      /* main MCU processing loop here */
      if (restart_interval) {
	    n_restarts = ceil_div(mx_size * my_size, restart_interval) - 1;
	    leftover = mx_size * my_size - n_restarts * restart_interval;
	  /* final interval may be incomplete */

	    for (i = 0; i < n_restarts; i++) {
	      for (j = 0; j < restart_interval; j++)
	        process_MCU(fi);
	      /* proc till all EOB met */
 
	      aux = get_next_MK(fi);
	      if (!RST_MK(aux)) {
	        DisplayErrMessage();
	        //aborted_stream(fi);
		  }
	      reset_prediction();
	      clear_bits();
		}		/* intra-interval loop */
      } 
      else
	  leftover = mx_size * my_size;

      /* process till end of row without restarts */
      for (i = 0; i < leftover; i++)
	    process_MCU(fi);

      in_frame = 0;
      break;

    case EOI_MK:
      if (in_frame)
	;//aborted_stream(fi);
//      fclose(fi);
//      RGB_save(fo);
      DisplayDoneMessage();
//      exit(0);
      ptr = (int *) MMAXADDR;
      *ptr = 0x00000001; // Video display mode

	  return 1;
      break;

    case COM_MK:
     skip_segment(fi);
      break;

    case EOF:
       ;//aborted_stream(fi);

    default:
      if ((mark & MK_MSK) == APP_MK) {
    	skip_segment(fi);
	    break;
      }
      if (RST_MK(mark)) {
	    reset_prediction();
    	break;
      }
      /* if all else has failed ... */
     //aborted_stream(fi);
      break;
    } /* end switch */
  } 
  while (1);    
  return 0;
}