/*
 * 
 * Copyright (c) 2004 Xilinx, Inc.  All rights reserved.
 * 
 */

// Located in: microblaze_0/include/xparameters.h
#include "xparameters.h"
#include "xutil.h"
#include "xintc_l.h"
#include "xuartlite_l.h"
#include "xgpio_l.h"
#include "xbasic_types.h"
#include "xio.h"

#define SRAM_BASE_ADDR 0xC0000003
#define SRAM_HIGH_ADDR 0xC00FFFFF

//------------------------------

int uart_interrupt_count = 0;
char uart_character;
int x = 0,y = 0;
char buf[2];
int *ptr  = (int *) SRAM_HIGH_ADDR;
int *ptr1 = (int *) SRAM_BASE_ADDR;

int current_word_data, current_byte_data;
int byte_enable;

/* UART interrupt service routine */
void uart_int_handler(void *baseaddr_p) {
   int i;
   /* While UART receive FIFO has data */
   while (!XUartLite_mIsReceiveEmpty(XPAR_RS232_BASEADDR)) {
     /* Read a character */
     uart_character = XUartLite_RecvByte(XPAR_RS232_BASEADDR);
     //putnum(uart_interrupt_count);
     buf[0] = uart_character;
     //*ptr = 0xaa;
     //XIo_Out32(ptr++, 0xaa);
     //print(buf);
     //print("\r\n");
     //print(buf);
     
     
     if (buf[0] == 'a') {
     	/******** 2 - Download 8-color 640*480 photo ********/
        ptr1 = (int *) SRAM_BASE_ADDR;
        ptr  = (int *) SRAM_HIGH_ADDR;
        *ptr = 0x000000f9;
        uart_interrupt_count = 0;
        current_word_data = 0x0000; 
        //ptr  = (int *) SRAM_HIGH_ADDR;        
        //*ptr = 0x00000001;
        print("\r\n");putnum(1);               
        }
     else if (buf[0] == 'b') {
        /******** 3 - Display 8-color 640*480 photo ********/
        ptr1 = (int *) SRAM_BASE_ADDR;
        ptr  = (int *) SRAM_HIGH_ADDR;
        *ptr = 0x000000f9;
        uart_interrupt_count = 0;      	
        current_word_data = 0x0000;
        print("\r\n");putnum(0);                    
        ptr  = (int *) SRAM_HIGH_ADDR;        
        *ptr = 0x00000001;
        } 
     else {
     	/******** 2 - Download 8-color 640*480 photo ********/
        current_byte_data = CHAR2NUM_CONV(&buf[0]);//putnum(current_byte_data);
        byte_enable = uart_interrupt_count % 8;//putnum(byte_enable);
        current_word_data = BYTE2WORD_CONV(&current_byte_data,&byte_enable);
        uart_interrupt_count++;
        ptr  = (int *) SRAM_HIGH_ADDR;    
        *ptr = 0x000000f9;                
        if (byte_enable == 7) {
           *ptr1 = current_word_data;
           ptr1++;
        } // if
        //ptr  = (int *) SRAM_HIGH_ADDR;    
        //*ptr = 0x00000001;  
        //for(i=0;i<100000;i++); 
        //print("\r\n");putnum(9);             
     } // else
   } // while
}

int CHAR2NUM_CONV(char *one_char)
{
  if      (*one_char == '8') return 0x00000008; // red
  else if (*one_char == '4') return 0x00000004; // green
  else if (*one_char == '2') return 0x00000002; // blue
  else if (*one_char == 'E') return 0x0000000e; // white
  else if (*one_char == '0') return 0x00000000; // black
  else if (*one_char == 'C') return 0x0000000c; // yellow
  else if (*one_char == '6') return 0x00000006; // cyan
  else if (*one_char == 'A') return 0x0000000a; // meg
  else                       return 0x00000000; // black
  //print("\r\n");putnum(5);
}

int BYTE2WORD_CONV(int *byte_data, int *byte_align)
{
  	static int word_data_1;
  	word_data_1 = (word_data_1<<4) + (*byte_data);
  	return word_data_1;
}


int main (void) {
	
  int i,WriteData,row,ReadData;
  int test,test1,test2,Err=0;

  //int uart_ic_old;

   /* Enable MicroBlaze interrupts */
   microblaze_enable_interrupts();
   /* Register the UART interrupt handler in the vector table */
   XIntc_RegisterHandler(XPAR_OPB_INTC_0_BASEADDR,XPAR_OPB_INTC_0_RS232_INTERRUPT_INTR,
      (XInterruptHandler)uart_int_handler,(void *)XPAR_RS232_BASEADDR);
   /* Start the interrupt controller */
   XIntc_mMasterEnable(XPAR_OPB_INTC_0_BASEADDR);
   /* Enable timer and UART interrupt requests in the interrupt controller */
   XIntc_mEnableIntr(XPAR_OPB_INTC_0_BASEADDR, XPAR_RS232_INTERRUPT_MASK);
   /* Enable UART interrupts */
   XUartLite_mEnableIntr(XPAR_RS232_BASEADDR);   

   /******** 1 - Start of Photo Viewer ********/
   
   buf[1] = '\0';
   
   // Into video display mode when initialized
   ptr = (int *) SRAM_HIGH_ADDR;
   *ptr = 0x000000f9; 
   
   ptr = (int *) SRAM_BASE_ADDR;
   for (row = 0 ; row < ((1024*1024/4)-1) ; row++) {
       WriteData = 0xff0000ff;
       *ptr = WriteData;
       ReadData = *ptr;
       if (ReadData != WriteData) {
          print("\r\n");print("!!! ERROR 3 - read write mismatch !!!");
       }
       ptr++;
   }  
   
   
   //ptr = (int *) SRAM_HIGH_ADDR;
   //*ptr = 0x00000001;
    
   while(1);
  
  return 0; 

} // main

