/*
 *  * Copyright (c) 2004 Xilinx, Inc.  All rights reserved.
 *
 * Xilinx, Inc.
 * XILINX IS PROVIDING THIS DESIGN, CODE, OR INFORMATION "AS IS" AS A 
 * COURTESY TO YOU.  BY PROVIDING THIS DESIGN, CODE, OR INFORMATION AS
 * ONE POSSIBLE   IMPLEMENTATION OF THIS FEATURE, APPLICATION OR 
 * STANDARD, XILINX IS MAKING NO REPRESENTATION THAT THIS IMPLEMENTATION 
 * IS FREE FROM ANY CLAIMS OF INFRINGEMENT, AND YOU ARE RESPONSIBLE 
 * FOR OBTAINING ANY RIGHTS YOU MAY REQUIRE FOR YOUR IMPLEMENTATION
 * XILINX EXPRESSLY DISCLAIMS ANY WARRANTY WHATSOEVER WITH RESPECT TO 
 * THE ADEQUACY OF THE IMPLEMENTATION, INCLUDING BUT NOT LIMITED TO 
 * ANY WARRANTIES OR REPRESENTATIONS THAT THIS IMPLEMENTATION IS FREE 
 * FROM CLAIMS OF INFRINGEMENT, IMPLIED WARRANTIES OF MERCHANTABILITY 
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 */

// Located in: microblaze_0/include/xparameters.h
#include "xparameters.h"

#include "xutil.h"
#include "xintc_l.h"
#include "xuartlite_l.h"
#include "xgpio_l.h"
//////////////////////////////////////////////////////////////////////////////
#define uCAR 0x01
#define dCAR 0x02
#define lCAR 0x03
#define rCAR 0x04
#define pennant 0x05
#define wall 0x06
#define road 0x07
#define white 0x08

#define up 0x75
#define down 0x72
#define left 0x6B
#define right 0x74


//////////////////////////////////////////////////////////////////////////////
#define FONT_OFFSET 0xA00

/* Address of a particular character on the screen (rows are 80) */
#define CHAR(c,r) \
   (((unsigned char *)(XPAR_VGA_BASEADDR))[(c) + ((r) << 6) + ((r) << 4)])

/* Start of font memory */
#define FONT ((unsigned char *)XPAR_VGA_BASEADDR + FONT_OFFSET)

//////////////////////////////////////////////////////////////////////////////
void print_car(unsigned char uctemp);
void print_map(void);
unsigned char KBdir(void);

int x_col_map = 1;
int y_row_map = 28;
unsigned char exFlag = 0;
int x_flag = 38;
int y_flag = 0;

//40 col 30 row
unsigned char map[30][40] = {
 { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 2, 0,},
 { 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0,},
 { 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0,},
 { 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1,},
 { 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0,},
 { 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 0,},  
 { 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0,},
 { 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0,},
 { 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0,},
 { 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0,},
 { 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0,},
 { 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0,},
 { 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0,},
 { 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 0,},
 { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0,},
 { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 1, 0,},
 { 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0,},
 { 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0,},
 { 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0,},
 { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 0,},
 { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0,},
 { 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0,},
 { 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0,},
 { 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0,},
 { 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0,},
 { 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0,},
 { 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,},
 { 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0,},
 { 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,},
 { 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0,}};

///////////////////////////////////////////////////////////////////////////////

int uart_interrupt_count = 0;
char uart_character;
 
/* UART interrupt service routine */
void uart_int_handler(void *baseaddr_p) {
   
   /* While UART receive FIFO has data */
   while (!XUartLite_mIsReceiveEmpty(XPAR_RS232_BASEADDR)) {
     /* Read a character */
     uart_character = XUartLite_RecvByte(XPAR_RS232_BASEADDR);
     ++uart_interrupt_count;
   }
}

/* Must be a power of two */
#define SCANCODE_BUFFER_SIZE 16
unsigned char scancode_buffer[SCANCODE_BUFFER_SIZE];
int scancode_buffer_head = 0;
int scancode_buffer_tail = 0;

int character_available()
{
  int result;
  microblaze_disable_interrupts();
  result = scancode_buffer_head != scancode_buffer_tail;
  microblaze_enable_interrupts();
  return result;	
}

unsigned char get_character()
{
  unsigned char result;
  microblaze_disable_interrupts();
  result = scancode_buffer[scancode_buffer_tail];
  scancode_buffer_tail = (scancode_buffer_tail + 1) & (SCANCODE_BUFFER_SIZE - 1);
  microblaze_enable_interrupts();
  return result;		
}

int keyboard_interrupt_count = 0;
unsigned int scan_code = 0;
unsigned int keyboard_bit = 11;

/* PS/2 Keyboard interrupt service routine */
void ps2_int_handler(void *baseaddr_p)
{
  int next_head;
  keyboard_interrupt_count++;
 
  /* We're reading a scancode and the keyboard clock fell: sample the data */
  scan_code = (scan_code >> 1) |
      (XGpio_mReadReg(XPAR_PS2IO_BASEADDR, XGPIO_DATA_OFFSET) << 9);
  if (--keyboard_bit == 0) {
    /* keycode is ready */
    next_head = (scancode_buffer_head + 1) & (SCANCODE_BUFFER_SIZE - 1);
    if (next_head != scancode_buffer_tail) {
      /* buffer is not full; add the character */
      scancode_buffer[scancode_buffer_head] = scan_code;
      scancode_buffer_head = next_head;
    }
    keyboard_bit = 11;
    scan_code = 0;
  }
   
  /* Acknowledge the interrupt */
  XGpio_mWriteReg(XPAR_PS2IO_BASEADDR, XGPIO_ISR_OFFSET, 1);
}

/* Write a text string on the display */
void put_string(char *string, int column, int row)
{
  char *p = &(CHAR(column, row));
  while (*p++ = *string++)
    ;
}
void put_block(char Btype, int column, int row)
{
	unsigned char i,j;
	char uCARs[8] = {0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d};
	char dCARs[8] = {0x2a,0x27,0x28,0x2d,0x26,0x2b,0x2c,0x29};
	char lCARs[8] = {0x2e,0x2f,0x30,0x31,0x32,0x33,0x34,0x35};
	char rCARs[8] = {0x2e,0x2f,0x30,0x31,0x32,0x33,0x34,0x35};
	char pennants[8] = {0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d};
	char walls[8] = {0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24};
	char roads[8] = {0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22};
	char white_walls[8] = {0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23};	 
	char *p = &(CHAR(column, row));
	char *q = &(CHAR(column, (row+1)));
	for (j=0;j<=3;j++)
	{		
		switch (Btype)
		{
			case road:
				*p++ = roads[j];
				break;
			case wall:
				*p++ = walls[j];
				break;	
			case white:
				*p++ = white_walls[j];
				break;
			case uCAR:
				*p++ = uCARs[j];
				break;
			case dCAR:
				*p++ = dCARs[j];
				break;
			case lCAR:
				*p++ = lCARs[j];
				break;
			case rCAR:
				*p++ = rCARs[j];
				break;			
			case pennant:
				*p++ = pennants[j];
				break;	
		}
	}	
	for (j=4;j<=7;j++)
	{
		switch (Btype)
		{
			case road:
				*q++ = roads[j];
				break;
			case wall:
				*q++ = walls[j];
				break;
			case white:
				*q++ = white_walls[j];	
				break;
			case uCAR:
				*q++ = uCARs[j];
				break;
			case dCAR:
				*q++ = dCARs[j];
				break;
			case lCAR:
				*q++ = lCARs[j];
				break;
			case rCAR:
				*q++ = rCARs[j];
				break;
			case pennant:
				*q++ = pennants[j];
				break;
		}
	}
}

int main (void) {
//   int i,j;
//   int x_col = 0;
//   int y_row = 0;
	 unsigned char uctemp;
//   unsigned char exFlag = 0;


   
   	print("Hello World!\r\n");	//put string to terminal screen

//	put_string("The Digilent Spartan 3 board says \"Hello from NCTU\"", 0, 1);

	
   /* Enable MicroBlaze interrupts */
   microblaze_enable_interrupts();
   /* Register the UART interrupt handler in the vector table */
   XIntc_RegisterHandler(XPAR_OPB_INTC_0_BASEADDR,XPAR_OPB_INTC_0_RS232_INTERRUPT_INTR,
      (XInterruptHandler)uart_int_handler,(void *)0);
   /* Register the keyboard interrupt handler */
   XIntc_RegisterHandler(XPAR_OPB_INTC_0_BASEADDR, XPAR_OPB_INTC_0_SYSTEM_PS2C_INTR,
      (XInterruptHandler)ps2_int_handler, (void *)0);
   /* Start the interrupt controller */
   XIntc_mMasterEnable(XPAR_OPB_INTC_0_BASEADDR);
   /* Enable timer and UART interrupt requests in the interrupt controller */
   XIntc_mEnableIntr(XPAR_OPB_INTC_0_BASEADDR,
                     XPAR_RS232_INTERRUPT_MASK | XPAR_SYSTEM_PS2C_MASK);
   /* Enable UART interrupts */
   XUartLite_mEnableIntr(XPAR_RS232_BASEADDR);

//  for (;;) {
//    if (character_available()) {
//    	 print("Got scancode ");
//    	 putnum(get_character());
//    	 print("\r\n");
//     }
//     for (i = 0 ; i < 1000 ; i++ )  ; /* delay */
//  }

//print the Map
print_map();
print_car(up); 

put_string("~~ START GAME ~~",33,19);

for(;;)
{
	uctemp = KBdir();
	if (uctemp)
	{
		switch (uctemp)
		{
			case up:
				y_row_map -= 1;
				if ((map[y_row_map][x_col_map]==1)||(y_row_map<0))
				{
					y_row_map +=1;
				}	
				break;
			case down:
				y_row_map += 1;
				if  ((map[y_row_map][x_col_map]==1)||(y_row_map>29))
				{
					y_row_map -=1;
				}	
				break;
			case left:
				x_col_map -= 1;
				if  ((map[y_row_map][x_col_map]==1)||(x_col_map<0))
				{
					x_col_map += 1;
				}
				break;
			case right:
				x_col_map += 1;
				if  ((map[y_row_map][x_col_map]==1)||(x_col_map>39))
				{
					x_col_map -= 1;
				}
				break;
			default: break;
		}
		print_map();
		print_car(uctemp);
	}
	if ((x_col_map == x_flag)&&(y_row_map == y_flag))
	{
		put_string("~~ YOU WIN ^_^",35,19);
		return 0;
	}
	
}
	 
   	print("Goodbye! \r\n");
   	return 0;
}

void print_map(void)
{
	unsigned char i,j;
	for (i=0;i<15;i++)
	{
		for (j=0;j<20;j++)
		{	
			if (((x_col_map-9+j)<0)||((y_row_map-7+i)<0)||((x_col_map-9+j)>39)||((y_row_map-7+i)>29))
			{
				put_block(white,4*j,2*i);
				continue;
			}
			if(map[y_row_map-7+i][x_col_map-9+j] == 2)
   			{
   				put_block(pennant, 4*j, 2*i);
   			}
			else if(map[y_row_map-7+i][x_col_map-9+j] == 1)
   			{
   				put_block(wall, 4*j, 2*i);
   			}
	   		else
   			{   			
   				put_block(road, 4*j, 2*i);
   			}				
		}
	}
}
void print_car(unsigned char uctemp)
{
	switch(uctemp)
	{
		case up:
			put_block(uCAR,36,14);
			break;
		case down:
			put_block(dCAR,36,14);
			break;
		case left:
			put_block(lCAR,36,14);
			break;
		case right:	
			put_block(rCAR,36,14);
			break;
	}		
}

// Control 
unsigned char KBdir(void)
{
   	unsigned char uctemp;
	if (character_available())
	{
		uctemp = get_character();
		if (exFlag == 1)
		{
			switch (uctemp)
			{
				case 0xf0:
					scancode_buffer_head = scancode_buffer_tail;
					exFlag = 0;
					return 0;						
				case up:
					exFlag = 0;
					return up;
				case down:
					exFlag = 0;
					return down;
				case left:
					exFlag = 0;
					return left;
				case right:	
					exFlag = 0;
					return right;
				default: return 0;
			}		
		}	
		if (uctemp == 0xe0)
		{
			exFlag = 1;
			return 0;
		}
		return 0;	
	}	
}
