#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <stdlib.h>
#include <fstream>
#include <iomanip>


using namespace std;

SDL_Surface *screen;
Uint32 getpixel(SDL_Surface *surface, int x, int y)
{
    int bpp = surface->format->BytesPerPixel;
    /* Here p is the address to the pixel we want to retrieve */
    Uint8 *p = (Uint8 *)surface->pixels + y * surface->pitch + x * bpp;

    switch(bpp) {
    case 1:
        return *p;

    case 2:
        return *(Uint16 *)p;

    case 3:
        if(SDL_BYTEORDER == SDL_BIG_ENDIAN)
            return p[0] << 16 | p[1] << 8 | p[2];
        else
            return p[0] | p[1] << 8 | p[2] << 16;

    case 4:
        return *(Uint32 *)p;

    default:
        return 0;       /* shouldn't happen, but avoids warnings */
    }
}

int colormapping[2][2][2]={{{0,1},{2,3}},{{4,5},{6,7}}};

int main(int argc, char *argv[])
{
	int i;
	const char filename[] = "font2.bmp";
		
	if( SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO) <0 )
	{
		printf("Unable to init SDL: %s\n", SDL_GetError());
		return 1;
	}
	atexit(SDL_Quit);
	
	screen = SDL_SetVideoMode(640, 480 , 32, SDL_SWSURFACE);
	
	ofstream outFILE("bitmap-fpga.txt");
	ofstream outFILEPC("bitmap-pc.txt");
	
	SDL_Surface *image = IMG_Load(filename);	
	if(!image) {
		printf ( "IMG_Load: %s\n", IMG_GetError () );
		return 1;
	}
	/*
	int done = 0;
	
	while(done == 0)
	{
	    SDL_Event event;
		while ( SDL_PollEvent(&event) )
		{
	    	if ( event.type == SDL_QUIT )  {  done = 1;  }
			if ( event.type == SDL_KEYDOWN )
			{
				if ( event.key.keysym.sym == SDLK_ESCAPE ) { done = 1; }
			}
	    }
	}
	*/
	int r, g, b;
	int pixel;
	
// for pc
for(int count = 0; count<64; count++)
{
	outFILEPC << "{";
	for(int y=0; y<8; y++)
	{
		r = g = b =0;
		outFILEPC << "{";
		for(int x=0; x<8; x++) {
			pixel = getpixel(image, x+count*9, y+1);			
			// for pc
			if(pixel == 4363461)
			{
				outFILEPC << 8;
			}
			else {
				outFILEPC << colormapping[((pixel>>16)%256)/255][((pixel>>8)%256)/255][((pixel)%256)/255];
			}
			if(x!=7)
				outFILEPC << ",";
		}

		outFILEPC << "}";		
		if(y!=7)
			outFILEPC << ",";

	}
	outFILEPC << "}" << endl;
	if(count!=63)
		outFILEPC << "," << endl;;

}

// for fpga
for(int count = 0; count<64; count++)
{
	outFILE << "  attribute INIT_" << hex << setw(2) << setfill('0') << count <<
	        " of RAMB16_S36_S36_1 : label is" << endl << "   \"";
	for(int y=8; y>0; y--)
	{
		r = g = b =0;
		for(int x=0; x<8; x++) {
			pixel = getpixel(image, x+count*9, y);
			// for fpga
			r = r<<1 | (pixel>>16)/255;
			g = g<<1 | ((pixel>>8)%256)/255;
			b = b<<1 | ((pixel)%256)/255;			
		}

		outFILE << 
		"00" << hex << setw(2) << setfill('0') << r << setw(2) << setfill('0') << g << setw(2) << setfill('0') << b;

	}
	outFILE << "\";"<< endl;
}
	outFILE.close();
	outFILEPC.close();
    return 0;
}
