#################################################################
# Makefile generated by Xilinx Platform Studio 
# Project:C:\edk_user_repository\ps2keyboard\system.xmp
#################################################################

# Name of the Microprocessor system
# The hardware specification of the system is in file :
# C:\edk_user_repository\ps2keyboard\system.mhs
# The software specification of the system is in file :
# C:\edk_user_repository\ps2keyboard\system.mss

include system_incl.make


#################################################################
# EXTERNAL TARGETS
#################################################################
all:
	@echo "Makefile to build a Microprocessor system :"
	@echo "Run make with any of the following targets"
	@echo " "
	@echo "  netlist  : Generates the netlist for the given MHS "
	@echo "  bits     : Runs Implementation tools to generate the bitstream"
	@echo "  exporttopn:Export to ProjNav"
	@echo " "
	@echo "  libs     : Configures the sw libraries for this system"
	@echo "  program  : Compiles the program sources for all the processor instances"
	@echo " "
	@echo "  init_bram: Initializes bitstream with BRAM data"
	@echo "  ace      : Generate ace file from bitstream and elf"
	@echo "  download : Downloads the bitstream onto the board"
	@echo " "
	@echo "  sim      : Generates HDL simulation models and runs simulator for chosen simulation mode"
	@echo "  simmodel : Generates HDL simulation models for chosen simulation mode"
	@echo "  behavioral:Generates behavioral HDL models with BRAM initialization"
	@echo "  structural:Generates structural simulation HDL models with BRAM initialization"
	@echo "  timing   : Generates timing simulation HDL models with BRAM initialization"
	@echo " "
	@echo "  netlistclean: Deletes netlist"
	@echo "  bitsclean: Deletes bit, ncd, bmm files"
	@echo "  hwclean  : Deletes implementation dir"
	@echo "  libsclean: Deletes sw libraries"
	@echo "  programclean: Deletes compiled ELF files"
	@echo "  swclean  : Deletes sw libraries and ELF files"
	@echo "  simclean : Deletes simulation dir"
	@echo "  clean    : Deletes all generated files/directories"
	@echo " "
	@echo "  make <target> : (Default)"
	@echo "      Creates a Microprocessor system using default initializations"
	@echo "      specified for each processor in MSS file"


bits: $(SYSTEM_BIT)

ace: $(SYSTEM_ACE)

netlist: $(POSTSYN_NETLIST)

libs: $(LIBRARIES)

program: $(ALL_USER_ELF_FILES)

download: $(DOWNLOAD_BIT) dummy
	@echo "*********************************************"
	@echo "Downloading Bitstream onto the target board"
	@echo "*********************************************"
	impact -batch etc/download.cmd

init_bram: $(DOWNLOAD_BIT)

sim: $(DEFAULT_SIM_SCRIPT)
	cd simulation/behavioral; \
	$(SIM_CMD)  &

simmodel: $(DEFAULT_SIM_SCRIPT)

behavioral_model: $(BEHAVIORAL_SIM_SCRIPT)

structural_model: $(STRUCTURAL_SIM_SCRIPT)

timing_model: $(TIMING_SIM_SCRIPT)

clean: hwclean libsclean programclean simclean
	rm -f _impact.cmd

hwclean: netlistclean bitsclean
	rm -rf implementation synthesis xst hdl
	rm -rf xst.srp $(SYSTEM).srp

netlistclean:
	rm -f $(POSTSYN_NETLIST)
	rm -f $(BMM_FILE)

bitsclean:
	rm -f $(SYSTEM_BIT)
	rm -f implementation/$(SYSTEM).ncd
	rm -f implementation/$(SYSTEM)_bd.bmm 

bitsclean:

simclean: 
	rm -rf simulation/behavioral

swclean: libsclean programclean
	@echo ""

libsclean: $(LIBSCLEAN_TARGETS)

programclean: $(PROGRAMCLEAN_TARGETS)

#################################################################
# SOFTWARE PLATFORM FLOW
#################################################################


$(LIBRARIES): $(MHSFILE) $(MSSFILE) __xps/libgen.opt
	@echo "*********************************************"
	@echo "Creating software libraries..."
	@echo "*********************************************"
	libgen $(LIBGEN_OPTIONS) $(MSSFILE)


microblaze_0_libsclean:
	rm -rf microblaze_0/lib/

$(MICROBLAZE_0_XMDSTUB): $(LIBRARIES)

#################################################################
# SOFTWARE APPLICATION TESTAPP
#################################################################

TestApp_program: $(TESTAPP_OUTPUT) 

$(TESTAPP_OUTPUT) : $(TESTAPP_SOURCES) $(TESTAPP_HEADERS) $(TESTAPP_LINKER_SCRIPT) \
                    $(LIBRARIES) __xps/testapp_compiler.opt
	@mkdir -p $(TESTAPP_OUTPUT_DIR) 
	$(TESTAPP_CC) $(TESTAPP_CC_OPT) $(TESTAPP_SOURCES) -o $(TESTAPP_OUTPUT) \
	$(TESTAPP_OTHER_CC_FLAGS) $(TESTAPP_INCLUDES) $(TESTAPP_LIBPATH) \
	-xl-mode-$(TESTAPP_MODE)  \
	$(TESTAPP_CFLAGS) $(TESTAPP_LFLAGS) 
	$(TESTAPP_CC_SIZE) $(TESTAPP_OUTPUT) 

TestApp_programclean:
	rm -f $(TESTAPP_OUTPUT) 

#################################################################
# BOOTLOOP ELF FILES
#################################################################



$(MICROBLAZE_0_BOOTLOOP): $(MICROBLAZE_BOOTLOOP)
	@mkdir -p $(BOOTLOOP_DIR)
	cp -f $(MICROBLAZE_BOOTLOOP) $(MICROBLAZE_0_BOOTLOOP)

#################################################################
# HARDWARE IMPLEMENTATION FLOW
#################################################################


$(BMM_FILE) \
$(WRAPPER_NGC_FILES): $(MHSFILE) __xps/platgen.opt \
                      $(CORE_STATE_DEVELOPMENT_FILES)
	@echo "****************************************************"
	@echo "Creating system netlist for hardware specification.."
	@echo "****************************************************"
	platgen $(PLATGEN_OPTIONS) -st xst $(MHSFILE)

$(POSTSYN_NETLIST): $(WRAPPER_NGC_FILES)
	@echo "Running synthesis..."
	bash -c "cd synthesis; ./synthesis.sh; cd .."

$(SYSTEM_BIT): $(BMM_FILE) $(POSTSYN_NETLIST) __xps/xpsxflow.opt \
               $(UCF_FILE) $(BITGEN_UT_FILE) $(FASTRUNTIME_OPT_FILE)
	@echo "Copying Xilinx Implementation tool scripts.."
	@cp -f $(BITGEN_UT_FILE) implementation/bitgen.ut
	@cp -f $(FASTRUNTIME_OPT_FILE) implementation/fast_runtime.opt
	@cp -f $(UCF_FILE) implementation/$(SYSTEM).ucf
	@echo "*********************************************"
	@echo "Running Xilinx Implementation tools.."
	@echo "*********************************************"
	xflow -wd implementation -p $(DEVICE) -implement fast_runtime.opt $(SYSTEM).ngc
	cd implementation; bitgen -w -f bitgen.ut $(SYSTEM)

exporttopn: 
	@echo "You have chosen XPS for implementation tool flow."
	@echo "Please select ProjNav as your implementation flow in Project Options."
	@echo "In batch mode, use commad xset pnproj <nplfile>."

$(DOWNLOAD_BIT): $(SYSTEM_BIT) $(BRAMINIT_ELF_FILES) __xps/bitinit.opt
	@cp -f implementation/$(SYSTEM)_bd.bmm .
	@echo "*********************************************"
	@echo "Initializing BRAM contents of the bitstream"
	@echo "*********************************************"
	bitinit $(MHSFILE) $(SEARCHPATHOPT) $(BRAMINIT_ELF_FILE_ARGS) \
	-bt $(SYSTEM_BIT) -o $(DOWNLOAD_BIT)
	@rm -f $(SYSTEM)_bd.bmm

$(SYSTEM_ACE): $(DOWNLOAD_BIT) $(TESTAPP_OUTPUT) 
	@echo "*********************************************"
	@echo "Creating system ace file"
	@echo "*********************************************"
	xmd -tcl genace.tcl -jprog -hw $(DOWNLOAD_BIT) -elf $(TESTAPP_OUTPUT)  -ace $(SYSTEM_ACE)

#################################################################
# SIMULATION FLOW
#################################################################


################## BEHAVIORAL SIMULATION ##################

$(BEHAVIORAL_SIM_SCRIPT): $(MHSFILE) __xps/simgen.opt \
                          $(BRAMINIT_ELF_FILES)
	@echo "*********************************************"
	@echo "Creating behavioral simulation models..."
	@echo "*********************************************"
	simgen $(SIMGEN_OPTIONS) -m behavioral $(MHSFILE)

################## STRUCTURAL SIMULATION ##################

$(STRUCTURAL_SIM_SCRIPT): $(WRAPPER_NGC_FILES) __xps/simgen.opt \
                          $(BRAMINIT_ELF_FILES)
	@echo "*********************************************"
	@echo "Creating structural simulation models..."
	@echo "*********************************************"
	simgen $(SIMGEN_OPTIONS) -sd implementation -m structural $(MHSFILE)


################## TIMING SIMULATION ##################

$(TIMING_SIM_SCRIPT): $(SYSTEM_BIT) __xps/simgen.opt \
                      $(BRAMINIT_ELF_FILES)
	@echo "*********************************************"
	@echo "Creating timing simulation models..."
	@echo "*********************************************"
	simgen $(SIMGEN_OPTIONS) -sd implementation -m timing $(MHSFILE)

dummy:
	@echo ""

