#define	SDL

#ifdef SDL
	#include <stdio.h>
	#include <SDL/SDL.h>
	#include <stdlib.h>
#else
	#include "xparameters.h"

	#include "xutil.h"
	#include "xintc_l.h"
	#include "xuartlite_l.h"
	#include "xgpio_l.h"
#endif



#define	BACKGROUND_TILE_WIDTH 8
#define	BACKGROUND_TILE_HEIGHT 8
#define	SCREEN_WIDTH 640
#define	SCREEN_HEIGHT 480
#define	BACKGROUND_X_NUM 80
#define	BACKGROUND_Y_NUM 60
#define	MAX_SPRITE_NUM 6
#define	SPRITE_WIDTH 8
#define	SPRITE_HEIGHT 8
#define	MAX_SNAKE_LENGTH 200
#define	SNAKE_INITIAL_LENGTH 10
#define	MAX_PILL 5
#define	MAX_HEALTH 600
#define	MIN_SPEED 4
#define	MAX_SPEED 2
#define	HEALTH_BAR_FRACTION	30
#define	DOUBLE_STRENGTH_TIME 1000
#define	PILL_ALIVE_TIME	1000
#define	PILL_BLINK_TIME	300
#define	HEALTH_RECOVER_CLOCK 3
#define	MAX_GAME_LEVEL 9
#define	TILE_TYPE_WALL2	54

#define	PLAYER_STATUS_Y_OFFSET 0
const unsigned char PLAYER_STATUS_X_OFFSET[2]	= {5, 55};

#define	TILE_TYPE_WALL 54
#define	TILE_TYPE_BLACK	51
const unsigned char TILE_TYPE_DOUBLE_STRENGTH[] =	{53, 52};
const unsigned char TILE_TYPE_PLAYER[] = {50,49};
const unsigned char TILE_TYPE_PLAYER_BIG[] = {48,47};
const unsigned char TILE_TYPE_PLAYER_SMALL[] = {46,45};

const char xp[]={15,30,43,57};
const char yp[]={18,23,28,33};

#define	TILE_TYPE_LONG 21
#define	TILE_TYPE_SLOW 28
#define	TILE_TYPE_HEALTH 17
#define	TILE_TYPE_RAND 43
#define	TILE_TYPE_DOUBLE 18
#define	TILE_TYPE_FAST 15

#define	TILE_TYPE_HSTATUS_FL 61
#define	TILE_TYPE_HSTATUS_FM 60
#define	TILE_TYPE_HSTATUS_FR 62
#define	TILE_TYPE_HSTATUS_HM 59
#define	TILE_TYPE_HSTATUS_HR 63

#ifndef	SDL
	#define	SDLK_UP	1
	#define	SDLK_DOWN 2
	#define	SDLK_LEFT 3
	#define	SDLK_RIGHT 4
	#define	SDLK_KP_PLUS 5
	#define	SDLK_KP_MINUS 6
	#define	SDLK_w 7
	#define	SDLK_s 8
	#define	SDLK_a 9
	#define	SDLK_d 10
	#define	SDLK_KP9 11
	#define	SDLK_KP8 12
	#define	SDLK_F1	13
	#define	SDLK_F2	14
	#define	SDLK_F10 15
	#define	SDLK_F5	16
	#define	SDLK_F6	17
	#define	SDLK_1 18
	#define SDLK_2 19
	#define SDLK_3 20
#endif


#ifdef SDL
	SDL_Surface	*screen;

	void init_screen()
	{
		screen = SDL_SetVideoMode(SCREEN_WIDTH,	SCREEN_HEIGHT ,	32,	SDL_SWSURFACE);

		if ( screen	== NULL	)
		{
		printf("Unable to setup	the	video: %s\n", SDL_GetError());
		exit(1);
		}
	}

	inline void	DrawPixel(SDL_Surface *screen, int x, int y,
										Uint8 R, Uint8 G, Uint8	B)
	{
	  Uint32 color = SDL_MapRGB(screen->format,	R, G, B);
	  switch (screen->format->BytesPerPixel)
	  {
		case 1:	// Assuming	8-bpp
		  {
			Uint8 *bufp;
			bufp = (Uint8 *)screen->pixels + y*screen->pitch + x;
			*bufp =	color;
		  }
		  break;
		case 2:	// Probably	15-bpp or 16-bpp
		  {
			Uint16 *bufp;
			bufp = (Uint16 *)screen->pixels	+ y*screen->pitch/2	+ x;
			*bufp =	color;
		  }
		  break;
		case 3:	// Slow	24-bpp mode, usually not used
		  {
			Uint8 *bufp;
			bufp = (Uint8 *)screen->pixels + y*screen->pitch + x * 3;
			if(SDL_BYTEORDER ==	SDL_LIL_ENDIAN)
			{
			  bufp[0] =	color;
			  bufp[1] =	color >> 8;
			  bufp[2] =	color >> 16;
			} else {
			  bufp[2] =	color;
			  bufp[1] =	color >> 8;
			  bufp[0] =	color >> 16;
			}
		  }
		  break;
		case 4:	// Probably	32-bpp
		  {
			Uint32 *bufp;
			bufp = (Uint32 *)screen->pixels	+ y*screen->pitch/4	+ x;
			*bufp =	color;
		  }
		  break;
	  }
	}

	inline void	Slock(SDL_Surface *screen)
	{
	  if ( SDL_MUSTLOCK(screen)	)
	  {
		if ( SDL_LockSurface(screen) < 0 )
		{
		  return;
		}
	  }
	}

	inline void	Sulock(SDL_Surface *screen)
	{
	  if ( SDL_MUSTLOCK(screen)	)
	  {
		SDL_UnlockSurface(screen);
	  }
	}
#else
/* Address of a	particular character on	the	screen (rows are 80) */
#define	CHAR(c,r) \
   (((unsigned char	*)(XPAR_VGA_BASEADDR))[(c) + ((r) << 6)	+ ((r) << 4)])

int	uart_interrupt_count = 0;
char uart_character;

/* UART	interrupt service routine */
void uart_int_handler(void *baseaddr_p)	{

   /* While	UART receive FIFO has data */
   while (!XUartLite_mIsReceiveEmpty(XPAR_RS232_BASEADDR)) {
	 /*	Read a character */
	 uart_character	= XUartLite_RecvByte(XPAR_RS232_BASEADDR);
	 ++uart_interrupt_count;
   }
}

#endif

/* U */
/* Must	be a power of two */
#define	KEY_BUFFER_SIZE	4

#ifdef SDL
	SDLKey key_buffer[3][KEY_BUFFER_SIZE];
#else
	unsigned char key_buffer[3][KEY_BUFFER_SIZE];
#endif
unsigned char key_buffer_head[3] = {0};
unsigned char key_buffer_tail[3] = {0};



int	character_available(int	who)
{
  int result;
  #ifndef SDL
	microblaze_disable_interrupts();
  #endif
  result = key_buffer_head[who]	!= key_buffer_tail[who];
  #ifndef SDL
	microblaze_enable_interrupts();
  #endif
  return result;
}

#ifdef SDL
SDLKey get_character(int who)
#else
unsigned char get_character(int	who)
#endif
{

  #ifndef SDL
	unsigned char result;
	microblaze_disable_interrupts();
  #else
	SDLKey result;
  #endif
  result = key_buffer[who][key_buffer_tail[who]];
  key_buffer_tail[who] = (key_buffer_tail[who] + 1)	& (KEY_BUFFER_SIZE - 1);
  #ifndef SDL
	microblaze_enable_interrupts();
  #endif
  return result;
}

#ifdef SDL
void process_event()
{
	SDL_Event event;
	int	key_belong;
	while(SDL_PollEvent(&event))
	{
		if(event.type == SDL_QUIT) { exit(1); }
		if(event.type == SDL_KEYDOWN)
		{
			switch(event.key.keysym.sym) {
				case SDLK_UP:
				case SDLK_DOWN:
				case SDLK_LEFT:
				case SDLK_RIGHT:
				case SDLK_KP_PLUS:
				case SDLK_KP_MINUS:
				case SDLK_KP9:
					key_belong = 0;
				break;
				case SDLK_w:
				case SDLK_s:
				case SDLK_a:
				case SDLK_d:
				case SDLK_1:
				case SDLK_2:
				case SDLK_3:
					key_belong = 1;
				break;

				default:
					key_belong = 2;
				break;
			}
			int	next_head;
			next_head =	(key_buffer_head[key_belong] + 1) &	(KEY_BUFFER_SIZE - 1);
			if(next_head!=key_buffer_tail[key_belong]) {
				key_buffer[key_belong][key_buffer_head[key_belong]]	= event.key.keysym.sym;
				key_buffer_head[key_belong]	= next_head;
			}
		}
	}
}
#else
unsigned char scan_code_buf1, scan_code_buf2, scan_code_buf3;
unsigned char scan_code_state =	0;
int	keyboard_interrupt_count = 0;
unsigned int scan_code = 0;
unsigned int keyboard_bit =	11;

/* PS/2	Keyboard interrupt service routine */
void ps2_int_handler(void *baseaddr_p)
{

  int next_head;
  char key_pressed = 0;
  char key_belong; // 0	or 1 or	2 (player1,	player2, system)

  keyboard_interrupt_count++;

  /* We're reading a scancode and the keyboard clock fell: sample the data */
  scan_code	= (scan_code >>	1) |
	  (XGpio_mReadReg(XPAR_PS2IO_BASEADDR, XGPIO_DATA_OFFSET) << 9);
  if (--keyboard_bit ==	0) {
	/* keycode is ready	*/

	if(scan_code_state == 0) {
		scan_code_buf1 = scan_code;
		if(scan_code_buf1 == 0xE0 || scan_code_buf1	== 0xF0) {
			scan_code_state	= 1;
		}
		else {
			switch(scan_code_buf1) {
				case 0x79: key_pressed = SDLK_KP_PLUS; key_belong=0; break;
				case 0x7B: key_pressed = SDLK_KP_MINUS;	key_belong=0; break;
				case 0x1d: key_pressed = SDLK_w; key_belong=1; break;
				case 0x1b: key_pressed = SDLK_s; key_belong=1; break;
				case 0x1c: key_pressed = SDLK_a; key_belong=1; break;
				case 0x23: key_pressed = SDLK_d; key_belong=1; break;
				case 0x16: key_pressed = SDLK_1; key_belong=1; break;
				case 0x1E: key_pressed = SDLK_2; key_belong=1; break;
				case 0x26: key_pressed = SDLK_3; key_belong=1; break;								
				case 0x09: key_pressed = SDLK_F10; key_belong=2; break;
				case 0x05: key_pressed = SDLK_F1; key_belong=2;	break;
				case 0x06: key_pressed = SDLK_F2; key_belong=2;	break;
				case 0x03: key_pressed = SDLK_F5; key_belong=2;	break;
				case 0x0b: key_pressed = SDLK_F6; key_belong=2;	break;

			}
		}
	}
	else if(scan_code_state	== 1) {
		scan_code_buf2 = scan_code;
		if(scan_code_buf1 == 0xF0) {
			scan_code_state	= 0;
		}
		else if(scan_code_buf1 == 0xE0)	{
			if(scan_code_buf2 == 0xF0) {
				scan_code_state	= 2;
			}
			else {
				switch(scan_code_buf2) {
					case 0x75: key_pressed = SDLK_UP; key_belong=0;	break;
					case 0x72: key_pressed = SDLK_DOWN;	key_belong=0; break;
					case 0x6B: key_pressed = SDLK_LEFT;	key_belong=0; break;
					case 0x74: key_pressed = SDLK_RIGHT; key_belong=0; break;

				}

				scan_code_state	= 0;
			}
		}
	}
	else if(scan_code_state	== 2) {
		scan_code_state	= 0;
	}

	if(key_pressed != 0) {
		next_head =	(key_buffer_head[key_belong] + 1) &	(KEY_BUFFER_SIZE - 1);
		if(next_head!=key_buffer_tail[key_belong]) {
			key_buffer[key_belong][key_buffer_head[key_belong]]	= key_pressed;
			key_buffer_head[key_belong]	= next_head;
		}
	}

	keyboard_bit = 11;
	scan_code =	0;
  }

  /* Acknowledge the interrupt */
  XGpio_mWriteReg(XPAR_PS2IO_BASEADDR, XGPIO_ISR_OFFSET, 1);

}
#endif

/*	From the Microsoft knowledge base: */
unsigned int next_rand = 327680;
unsigned int rand_num()
{
	next_rand=((next_rand*1140671485+12820163) & 0xFFFFFF);
	return next_rand;
}


#ifdef SDL

	/* video controller	*/
	struct tile	{
		unsigned int tile_type;
	} background_tile_map[BACKGROUND_X_NUM][BACKGROUND_Y_NUM];

	struct sprite {
		unsigned int sprite_type;
		unsigned int x;
		unsigned int y;
	} sprite_map[MAX_SPRITE_NUM];


	Uint8 color_plate_b[9]={  0,255,  0,255,  0,255,  0,255,  0};
	Uint8 color_plate_g[9]={  0,  0,255,255,  0,  0,255,255,  0};
	Uint8 color_plate_r[9]={  0,  0,  0,  0,255,255,255,255,  0};


	unsigned char tile_bit_map[][8][8] = {

{{0,1,1,1,1,1,1,0},{1,1,7,7,7,7,1,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,1,7,7,7,7,1,1},{0,1,1,1,1,1,1,0}}
,
{{0,1,1,1,1,1,0,0},{0,1,7,7,7,1,0,0},{0,1,1,7,7,1,0,0},{0,0,1,7,7,1,0,0},{0,0,1,7,7,1,0,0},{0,1,1,7,7,1,1,0},{0,1,7,7,7,7,1,0},{0,1,1,1,1,1,1,0}}
,
{{0,1,1,1,1,1,1,0},{1,7,7,7,7,7,1,1},{1,1,1,1,1,7,7,1},{0,1,7,7,7,7,1,0},{1,7,7,1,1,1,0,0},{1,7,7,1,1,1,1,1},{1,7,7,7,7,7,7,1},{1,1,1,1,1,1,1,1}}
,
{{1,1,1,1,1,1,1,0},{1,7,7,7,7,7,1,1},{1,1,1,1,1,7,7,1},{0,1,7,7,7,7,1,0},{0,1,1,1,1,7,7,1},{1,1,1,1,1,7,7,1},{1,7,7,7,7,7,1,0},{1,1,1,1,1,1,1,0}}
,
{{1,1,1,1,1,1,1,0},{1,7,7,1,1,7,1,0},{1,7,7,1,1,7,1,0},{1,7,7,1,1,7,1,0},{1,7,7,1,1,7,1,1},{1,7,7,7,7,7,7,1},{1,1,1,1,1,7,1,1},{0,0,0,0,1,1,1,0}}
,
{{1,1,1,1,1,1,1,0},{1,7,7,7,7,7,1,0},{1,7,7,1,1,1,1,0},{1,7,7,7,7,7,1,1},{0,1,1,1,7,7,7,1},{0,1,1,1,7,7,7,1},{1,7,7,7,7,7,1,1},{1,1,1,1,1,1,1,0}}
,
{{0,1,1,1,1,1,1,0},{1,1,7,7,7,7,1,0},{1,7,7,1,1,1,1,0},{1,7,7,7,7,7,1,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,1,7,7,7,7,1,1},{0,1,1,1,1,1,1,0}}
,
{{1,1,1,1,1,1,1,1},{1,7,7,7,7,7,7,1},{1,1,1,1,1,7,7,1},{0,0,0,0,1,7,7,1},{0,0,0,1,7,7,1,1},{0,0,1,7,7,1,1,0},{0,1,7,7,1,1,0,0},{0,1,1,1,1,0,0,0}}
,
{{0,1,1,1,1,1,1,0},{1,1,7,7,7,7,1,1},{1,7,7,1,1,7,7,1},{1,1,7,7,7,7,1,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,1,7,7,7,7,1,1},{0,1,1,1,1,1,1,0}}
,
{{0,1,1,1,1,1,1,0},{1,1,7,7,7,7,1,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,1,7,7,7,7,7,1},{0,1,1,1,1,7,7,1},{0,1,7,7,7,7,1,1},{0,1,1,1,1,1,1,0}}
,
{{0,1,1,1,1,1,1,0},{1,1,7,7,7,7,1,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,7,7,7,7,7,7,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,1,1,1,1,1,1,1}}
,
{{1,1,1,1,1,1,0,0},{1,7,7,7,7,7,1,0},{1,7,7,1,1,7,7,1},{1,7,7,7,7,7,1,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,7,7,7,7,7,1,1},{1,1,1,1,1,1,1,0}}
,
{{0,1,1,1,1,1,1,0},{1,1,7,7,7,7,1,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,1,1,1},{1,7,7,1,1,1,1,1},{1,7,7,1,1,7,7,1},{0,1,7,7,7,7,1,1},{0,0,1,1,1,1,1,0}}
,
{{1,1,1,1,1,1,0,0},{1,7,7,7,7,1,1,0},{1,7,7,1,7,7,1,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,7,7,7,7,7,1,1},{1,1,1,1,1,1,1,0}}
,
{{1,1,1,1,1,1,1,1},{1,7,7,7,7,7,7,1},{1,7,7,1,1,1,1,1},{1,7,7,7,7,7,1,0},{1,7,7,1,1,1,1,1},{1,7,7,1,1,1,1,1},{1,7,7,7,7,7,7,1},{1,1,1,1,1,1,1,1}}
,
{{1,1,1,1,1,1,1,1},{1,7,7,7,7,7,7,1},{1,7,7,1,1,1,1,1},{1,7,7,7,7,7,1,0},{1,7,7,1,1,1,1,0},{1,7,7,1,0,0,0,0},{1,7,7,1,0,0,0,0},{1,1,1,1,0,0,0,0}}
,
{{0,1,1,1,1,1,1,0},{1,1,7,7,7,7,1,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,1,1,1},{1,7,7,1,7,7,7,1},{1,7,7,1,1,7,7,1},{0,1,7,7,7,7,1,1},{0,0,1,1,1,1,1,0}}
,
{{1,1,1,1,1,1,1,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,7,7,7,7,7,7,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,1,1,1,1,1,1,1}}
,
{{0,0,1,1,1,1,0,0},{0,0,1,7,7,1,0,0},{0,0,1,7,7,1,0,0},{0,0,1,7,7,1,0,0},{0,0,1,7,7,1,0,0},{0,0,1,7,7,1,0,0},{0,0,1,7,7,1,0,0},{0,0,1,1,1,1,0,0}}
,
{{0,0,0,0,1,1,1,1},{0,0,0,0,1,7,7,1},{0,0,0,0,1,7,7,1},{1,1,1,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{0,1,7,7,7,7,1,0},{0,0,1,1,1,1,0,0}}
,
{{1,1,1,1,0,1,1,1},{1,7,7,1,1,7,7,1},{1,7,7,1,7,7,1,0},{1,7,7,7,7,1,0,0},{1,7,7,7,7,1,0,0},{1,7,7,1,7,7,1,0},{1,7,7,1,1,7,7,1},{1,1,1,1,0,1,1,1}}
,
{{1,1,1,1,0,0,0,0},{1,7,7,1,0,0,0,0},{1,7,7,1,0,0,0,0},{1,7,7,1,0,0,0,0},{1,7,7,1,0,0,0,0},{1,7,7,1,1,1,1,1},{1,7,7,7,7,7,7,1},{1,1,1,1,1,1,1,1}}
,
{{1,1,1,1,1,1,0,0},{1,7,7,7,7,7,1,0},{1,7,1,7,1,7,7,1},{1,7,1,7,1,7,7,1},{1,7,1,7,1,7,7,1},{1,7,1,7,1,7,7,1},{1,7,1,7,1,7,7,1},{1,1,1,1,1,1,1,1}}
,
{{1,1,1,1,1,1,0,0},{1,7,7,7,7,7,1,0},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,1,1,1,1,1,1,1}}
,
{{0,0,1,1,1,1,0,0},{0,1,7,7,7,7,1,0},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{0,1,7,7,7,7,1,0},{0,0,1,1,1,1,0,0}}
,
{{1,1,1,1,1,1,0,0},{1,7,7,7,7,7,1,0},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,7,7,7,7,7,1,0},{1,7,7,1,1,1,0,0},{1,7,7,1,0,0,0,0},{1,1,1,1,0,0,0,0}}
,
{{0,0,1,1,1,1,0,0},{0,1,7,7,7,7,1,0},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,7,7,1,7,7,1,0},{0,1,7,7,7,1,7,1},{0,0,1,1,1,0,1,1}}
,
{{1,1,1,1,1,1,0,0},{1,7,7,7,7,7,1,0},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,7,7,7,7,7,1,0},{1,7,7,1,1,7,1,1},{1,7,7,1,1,7,7,1},{1,1,1,1,1,1,1,1}}
,
{{0,0,1,1,1,1,1,1},{0,1,7,7,7,7,7,1},{1,7,7,1,1,1,1,1},{1,7,7,7,7,7,1,0},{1,1,1,1,1,7,7,1},{1,7,7,7,7,7,7,1},{1,7,7,7,7,7,1,1},{1,1,1,1,1,1,1,0}}
,
{{1,1,1,1,1,1,1,1},{1,7,7,7,7,7,7,1},{1,1,1,7,7,1,1,1},{0,0,1,7,7,1,0,0},{0,0,1,7,7,1,0,0},{0,0,1,7,7,1,0,0},{0,0,1,7,7,1,0,0},{0,0,1,1,1,1,0,0}}
,
{{1,1,1,1,1,1,1,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,1,7,7,7,7,1,1},{0,1,1,1,1,1,1,0}}
,
{{1,1,1,1,1,1,1,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,1,7,1,1,7,1,1},{1,1,7,7,7,7,1,0},{0,0,1,7,7,1,0,0},{0,0,0,1,1,0,0,0}}
,
{{1,1,1,1,1,1,1,1},{1,7,1,7,1,7,7,1},{1,7,1,7,1,7,7,1},{1,7,1,7,1,7,7,1},{1,7,1,7,1,7,7,1},{1,7,1,7,1,7,7,1},{1,7,7,7,7,7,1,0},{1,1,1,1,1,1,0,0}}
,
{{1,1,0,0,0,1,1,1},{1,7,1,0,1,7,7,1},{0,1,7,1,7,7,1,0},{0,0,1,7,7,1,0,0},{0,1,7,7,1,1,0,0},{1,7,7,1,1,7,1,0},{1,7,1,0,0,1,7,1},{1,1,1,0,0,0,1,1}}
,
{{1,1,1,1,1,1,1,1},{1,7,7,1,1,7,7,1},{1,7,7,1,1,7,7,1},{1,7,7,7,7,7,7,1},{1,1,1,7,7,1,1,1},{0,0,1,7,7,1,0,0},{0,0,1,7,7,1,0,0},{0,0,1,1,1,1,0,0}}
,
{{1,1,1,1,1,1,1,1},{1,7,7,7,7,7,7,1},{1,1,1,1,7,7,1,1},{0,0,1,7,7,1,1,0},{0,1,7,7,1,1,0,0},{1,7,7,1,1,1,1,1},{1,7,7,7,7,7,7,1},{1,1,1,1,1,1,1,1}}
,
{{0,0,1,1,1,1,0,0},{0,0,1,7,7,1,0,0},{0,0,1,7,7,1,0,0},{0,0,1,7,7,1,0,0},{0,0,1,7,7,1,0,0},{0,0,1,1,1,1,0,0},{0,0,1,7,7,1,0,0},{0,0,1,1,1,1,0,0}}
,
{{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0},{0,0,1,1,1,1,0,0},{0,0,1,7,7,1,0,0},{0,0,1,1,7,1,0,0},{0,0,1,7,1,1,0,0},{0,0,1,1,1,0,0,0}}
,
{{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0},{1,1,1,1,1,1,1,0},{1,7,7,7,7,7,1,0},{1,1,1,1,1,1,1,0},{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0}}
,
{{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0},{0,0,1,1,1,1,0,0},{0,0,1,7,7,1,0,0},{0,0,1,7,7,1,0,0},{0,0,1,1,1,1,0,0}}
,
{{0,0,0,0,0,1,1,1},{0,0,0,0,1,7,7,1},{0,0,0,1,7,7,1,0},{0,0,1,7,7,1,0,0},{0,1,7,7,1,0,0,0},{1,7,7,1,0,0,0,0},{1,7,1,0,0,0,0,0},{1,1,1,0,0,0,0,0}}
,
{{0,0,0,0,0,0,0,0},{0,0,1,1,1,1,0,0},{0,0,1,7,7,1,0,0},{0,0,1,7,7,1,0,0},{0,0,1,1,1,1,0,0},{0,0,1,7,7,1,0,0},{0,0,1,7,7,1,0,0},{0,0,1,1,1,1,0,0}}
,
{{0,0,0,0,0,0,0,0},{0,0,1,1,1,1,0,0},{0,0,1,7,7,1,0,0},{0,0,1,7,7,1,0,0},{0,0,1,1,1,1,0,0},{0,0,1,7,7,1,0,0},{0,0,1,7,1,1,0,0},{0,0,1,1,1,0,0,0}}
,
{{0,1,1,1,1,1,1,0},{1,7,7,7,7,7,1,1},{1,1,1,1,1,7,7,1},{0,1,1,7,7,7,1,0},{0,1,7,7,1,1,0,0},{0,1,1,1,1,0,0,0},{0,1,7,7,1,0,0,0},{0,1,1,1,1,0,0,0}}
,
{{0,0,0,0,0,0,0,0},{0,7,7,7,7,7,7,0},{0,7,7,7,7,7,7,0},{0,7,7,7,7,7,7,0},{0,7,7,7,7,7,7,0},{0,7,7,7,7,7,7,0},{0,7,7,7,7,7,7,0},{0,0,0,0,0,0,0,0}}
,
{{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0},{0,0,5,5,5,5,0,0},{0,0,5,5,5,5,0,0},{0,0,5,5,5,5,0,0},{0,0,5,5,5,5,0,0},{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0}}
,
{{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0},{0,0,2,2,2,2,0,0},{0,0,2,2,2,2,0,0},{0,0,2,2,2,2,0,0},{0,0,2,2,2,2,0,0},{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0}}
,
{{5,5,5,5,5,5,5,5},{5,5,5,5,5,5,5,5},{5,5,5,5,5,5,5,5},{5,5,5,5,5,5,5,5},{5,5,5,5,5,5,5,5},{5,5,5,5,5,5,5,5},{5,5,5,5,5,5,5,5},{5,5,5,5,5,5,5,5}}
,
{{2,2,2,2,2,2,2,2},{2,2,2,2,2,2,2,2},{2,2,2,2,2,2,2,2},{2,2,2,2,2,2,2,2},{2,2,2,2,2,2,2,2},{2,2,2,2,2,2,2,2},{2,2,2,2,2,2,2,2},{2,2,2,2,2,2,2,2}}
,
{{0,0,0,0,0,0,0,0},{0,5,5,5,5,5,5,0},{0,5,5,5,5,5,5,0},{0,5,5,5,5,5,5,0},{0,5,5,5,5,5,5,0},{0,5,5,5,5,5,5,0},{0,5,5,5,5,5,5,0},{0,0,0,0,0,0,0,0}}
,
{{0,0,0,0,0,0,0,0},{0,2,2,2,2,2,2,0},{0,2,2,2,2,2,2,0},{0,2,2,2,2,2,2,0},{0,2,2,2,2,2,2,0},{0,2,2,2,2,2,2,0},{0,2,2,2,2,2,2,0},{0,0,0,0,0,0,0,0}}
,
{{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0}}
,
{{0,0,0,0,0,0,0,0},{0,6,6,6,6,6,6,0},{0,6,6,6,6,6,6,0},{0,6,6,6,6,6,6,0},{0,6,6,6,6,6,6,0},{0,6,6,6,6,6,6,0},{0,6,6,6,6,6,6,0},{0,0,0,0,0,0,0,0}}
,
{{0,0,0,0,0,0,0,0},{0,1,1,1,1,1,1,0},{0,1,1,1,1,1,1,0},{0,1,1,1,1,1,1,0},{0,1,1,1,1,1,1,0},{0,1,1,1,1,1,1,0},{0,1,1,1,1,1,1,0},{0,0,0,0,0,0,0,0}}
,
{{0,0,0,0,0,0,0,0},{7,7,7,7,7,7,0,7},{7,0,0,0,0,7,0,7},{7,0,7,7,0,7,0,7},{7,0,7,0,0,7,0,7},{7,0,7,7,7,7,0,7},{7,0,0,0,0,0,0,7},{7,7,7,7,7,7,7,7}}
,
{{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,7,0},{0,7,7,7,7,0,7,0},{0,7,0,0,7,0,7,0},{0,7,0,7,7,0,7,0},{0,7,0,0,0,0,7,0},{0,7,7,7,7,7,7,0},{0,0,0,0,0,0,0,0}}
,
{{0,0,0,0,0,0,0,0},{4,4,4,4,4,4,0,4},{4,0,0,0,0,4,0,4},{4,0,4,4,0,4,0,4},{4,0,4,0,0,4,0,4},{4,0,4,4,4,4,0,4},{4,0,0,0,0,0,0,4},{4,4,4,4,4,4,4,4}}
,
{{0,0,0,0,0,0,0,0},{3,3,3,3,3,3,0,3},{3,0,0,0,0,3,0,3},{3,0,3,3,0,3,0,3},{3,0,3,0,0,3,0,3},{3,0,3,3,3,3,0,3},{3,0,0,0,0,0,0,3},{3,3,3,3,3,3,3,3}}
,
{{0,0,0,0,0,0,0,0},{2,2,2,2,2,2,0,2},{2,0,0,0,0,2,0,2},{2,0,2,2,0,2,0,2},{2,0,2,0,0,2,0,2},{2,0,2,2,2,2,0,2},{2,0,0,0,0,0,0,2},{2,2,2,2,2,2,2,2}}
,
{{0,0,0,0,0,0,0,0},{0,4,4,4,4,4,4,4},{0,4,4,4,4,4,4,4},{0,4,4,4,4,4,4,4},{0,4,4,4,4,4,4,4},{0,4,4,4,4,4,4,4},{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0}}
,
{{0,0,0,0,0,0,0,0},{0,6,6,6,6,6,6,6},{0,6,6,6,6,6,6,6},{0,6,6,6,6,6,6,6},{0,6,6,6,6,6,6,6},{0,6,6,6,6,6,6,6},{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0}}
,
{{0,0,0,0,0,0,0,0},{0,0,0,6,6,6,6,6},{0,0,6,6,6,6,6,6},{0,0,6,6,6,6,6,6},{0,0,6,6,6,6,6,6},{0,0,0,6,6,6,6,6},{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0}}
,
{{0,0,0,0,0,0,0,0},{0,6,6,6,6,6,0,0},{0,6,6,6,6,6,6,0},{0,6,6,6,6,6,6,0},{0,6,6,6,6,6,6,0},{0,6,6,6,6,6,0,0},{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0}}
,
{{0,0,0,0,0,0,0,0},{0,4,4,4,4,4,0,0},{0,4,4,4,4,4,4,0},{0,4,4,4,4,4,4,0},{0,4,4,4,4,4,4,0},{0,4,4,4,4,4,0,0},{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0}}

									};

	unsigned char sprite_bit_map[1][8][8] =	{
										{
											{2,2,2,2,2,2,2,2},
											{2,2,2,2,2,2,2,2},
											{2,2,2,2,2,2,2,2},
											{2,2,2,2,2,2,2,2},
											{2,2,2,2,2,2,2,2},
											{2,2,2,2,2,2,2,2},
											{2,2,2,2,2,2,2,2},
											{2,2,2,2,2,2,2,2}
										}
									};
#endif

#ifdef SDL
struct map_type
{
	int	tile_type;
} arena[BACKGROUND_X_NUM][BACKGROUND_Y_NUM];
#endif

struct pill_type
{
	int	x;
	int	y;
	int	type;
	int	time;
};
struct pill_type pill[MAX_PILL];
int	pill_num = 0;
int	pill_font_map[]	= {TILE_TYPE_LONG, TILE_TYPE_SLOW, TILE_TYPE_FAST
, TILE_TYPE_DOUBLE,	TILE_TYPE_HEALTH, TILE_TYPE_RAND, TILE_TYPE_LONG, TILE_TYPE_LONG};

/* hardware-software API*/
void set_tile(int x_position, int y_position, int tile_type)
{
	#ifdef SDL
		background_tile_map[x_position][y_position].tile_type =	tile_type;
		arena[x_position][y_position].tile_type	= tile_type;
	#else
		char *p	= &CHAR(x_position,	y_position);
		*p = tile_type;
	#endif
}

unsigned char get_tile_type(int	x, int y)
{
	#ifdef SDL
		return arena[x][y].tile_type;
	#else
		return CHAR(x, y);
	#endif
}


#ifdef SDL
	SDL_Surface	*bitMaps[64];
	int	bitMapInitialized[64]={0};
	int	drawScreen(SDL_Surface *screen)
	{
		// draw	background
		int	x, y;
		int	i, j;

		Uint32 rmask, gmask, bmask,	amask;
	#if	SDL_BYTEORDER == SDL_BIG_ENDIAN
		rmask =	0xff000000;
		gmask =	0x00ff0000;
		bmask =	0x0000ff00;
		amask =	0x000000ff;
	#else
		rmask =	0x000000ff;
		gmask =	0x0000ff00;
		bmask =	0x00ff0000;
		amask =	0xff000000;
	#endif

		for(x=0; x<BACKGROUND_X_NUM; x++)
		{
			for(y=0; y<BACKGROUND_Y_NUM; y++)
			{
				int	tileType = background_tile_map[x][y].tile_type;

				if(bitMapInitialized[tileType]==0) {
					bitMaps[tileType] =	 SDL_CreateRGBSurface(SDL_SWSURFACE, 8,	8, 32, rmask, gmask, bmask,	amask);
					for(i=0; i<BACKGROUND_TILE_WIDTH; i++)
						for(j=0; j<BACKGROUND_TILE_HEIGHT; j++)	{
							DrawPixel(bitMaps[background_tile_map[x][y].tile_type],	i, j,
							color_plate_r[tile_bit_map[background_tile_map[x][y].tile_type][j][i]],
							color_plate_g[tile_bit_map[background_tile_map[x][y].tile_type][j][i]],
							color_plate_b[tile_bit_map[background_tile_map[x][y].tile_type][j][i]]);
						}
					bitMapInitialized[tileType]	= 1;
				}

				SDL_Rect dest;
				dest.x = x*BACKGROUND_TILE_WIDTH;
				dest.y = y*BACKGROUND_TILE_HEIGHT;
				SDL_BlitSurface(bitMaps[tileType], NULL, screen, &dest);

			}
		}

		/*
		for(i=0; i<MAX_SPRITE_NUM; i++)	{
			if(sprite_map[i].sprite_type!=MAX_SPRITE_NUM) {
				for(x=sprite_map[i].x; x<sprite_map[i].x+SPRITE_WIDTH; x++)	{
					for(y=sprite_map[i].y; y<sprite_map[i].y+SPRITE_HEIGHT;	y++) {
						DrawPixel(screen, x, y,
						color_plate_r[sprite_bit_map[i][x-sprite_map[i].x][y-sprite_map[i].y]],
						color_plate_g[sprite_bit_map[i][x-sprite_map[i].x][y-sprite_map[i].y]],
						color_plate_b[sprite_bit_map[i][x-sprite_map[i].x][y-sprite_map[i].y]]);				};
				}
			}
		}
		*/

		SDL_Flip(screen);
	}
#endif

/* ----	main game logic	---- */

struct snake_body_type
{
	int	x, y;
};

struct snake_type
{
	int	qhead;
	int	length;
	int	length_on_screen;
	char direction;
	char next_direction;
	char lives;
	char hit_wall;
	int	double_strength;
	int	score;
	char color;
	int prev_x;
	int prev_y;
	int	head_x;
	int	head_y;
	int	next_x;
	int	next_y;
	int	health;
	unsigned char speed;
	unsigned char speed_clock;
	unsigned health_recover_clock;
	struct snake_body_type body[MAX_SNAKE_LENGTH];
};



void print_string(char *str, int x,	int	y)
{
	int	i;
	int	index;
	while(1) {
		if(*str	== 0)
			break;

		if(*str	>='0' && *str <= '9') {
			set_tile(x,	y, 0 + *str-'0');
		}
		else if(*str >=	'A'	&& *str	<='Z') {
			set_tile(x,	y, 10 +	*str-'A');
		}
		else {

			switch(*str) {
				case '!' : index = 36; break;
				case ',' : index = 37; break;
				case '-' : index = 38; break;
				case '.' : index = 39; break;
				case '/' : index = 40; break;
				case ':' : index = 41; break;
				case ';' : index = 42; break;
				case '?' : index = 43; break;
				default	: index	= 99; break;
			}
			if(index!=99)
				set_tile(x,	y, index);
		}

		str++;
		x++;
	}

}

void setupLevel(struct snake_type *player, int level)
{
	int	x, y, i, j;
	for(x=0; x<BACKGROUND_X_NUM; x++) {
		for(y=0; y<BACKGROUND_Y_NUM; y++) {
			set_tile(x,	y, TILE_TYPE_BLACK);
		}
	}

	// ~
	for(x=0; x<BACKGROUND_X_NUM; x++)
	{
		set_tile(x,	4, TILE_TYPE_WALL);
		set_tile(x,	BACKGROUND_Y_NUM-1,	TILE_TYPE_WALL);
	}
	for(y=4; y<BACKGROUND_Y_NUM; y++)
	{
		set_tile(0,	y, TILE_TYPE_WALL);
		set_tile(BACKGROUND_X_NUM-1, y,	TILE_TYPE_WALL);
	}

	switch(level) {
		case 1:
			player[0].head_y = 30; player[1].head_y	= 30;
			player[0].head_x = 50; player[1].head_x	= 30;
			player[0].direction	= 3; player[1].direction = 2;

			break;
		case 2:
			for(i =20; i<60; i++) {
				set_tile(i,	30,	TILE_TYPE_WALL2);
			}
			player[0].head_y = 18; player[1].head_y	= 43;
			player[0].head_x = 60; player[1].head_x	= 20;
			player[0].direction	= 2; player[1].direction = 3;
			break;
		case 3:
			for(i=19; i<46;	i++) {
				set_tile(20, i,	TILE_TYPE_WALL2);
				set_tile(60, i,	TILE_TYPE_WALL2);
			}
			player[0].head_y = 32; player[1].head_y	= 32;
			player[0].head_x = 50; player[1].head_x	= 30;
			player[0].direction	= 0; player[1].direction = 1;
			break;
		case 4:
			for(i=1; i<30; i++)	{
				set_tile(20, 4+i, TILE_TYPE_WALL2);
				set_tile(60, 59-i, TILE_TYPE_WALL2);
			}
			for(i=1; i<38; i++)	{
				set_tile(i,	44,	TILE_TYPE_WALL2);
				set_tile(79-i, 19, TILE_TYPE_WALL2);
			}
			player[0].head_y = 16; player[1].head_y	= 47;
			player[0].head_x = 60; player[1].head_x	= 20;
			player[0].direction	= 2; player[1].direction = 3;
			break;
		case 5:
			for(i=19; i<46;	i++) {
				set_tile(21, i,	TILE_TYPE_WALL2);
				set_tile(59, i,	TILE_TYPE_WALL2);
			}
			for(i=23; i<58;	i++) {
				set_tile(i,	17,	TILE_TYPE_WALL2);
				set_tile(i,	47,	TILE_TYPE_WALL2);
			}
			player[0].head_y = 32; player[1].head_y	= 32;
			player[0].head_x = 50; player[1].head_x	= 30;
			player[0].direction	= 0; player[1].direction = 1;
			break;
		case 6:
			for(j=0; j<50; j+=10){
				for(i=9+j; i<16+j; i++) {
					set_tile(39,i, TILE_TYPE_WALL2);
		    	}
			}
			for(i=19; i<60; i++) {
				set_tile(i, 12, TILE_TYPE_WALL2);
				set_tile(i, 32, TILE_TYPE_WALL2);
				set_tile(i, 52, TILE_TYPE_WALL2);
			}
			player[0].head_y = 36; player[1].head_y = 28;
			player[0].head_x = 50; player[1].head_x = 30;
			player[0].direction = 2; player[1].direction = 3;
			break;
		case 7:
			for(i=36; i<43; i++) {
				for(j=10; j<56; j+=5){
					set_tile(i, j, TILE_TYPE_WALL2);
				}
			}
			for(i=10; i<26; i+=5) {
				for(j=24; j<40; j++){
					set_tile(i, j, TILE_TYPE_WALL2);
				}
			}
			for(i=53; i<69; i+=5) {
				for(j=24; j<40; j++){
					set_tile(i, j, TILE_TYPE_WALL2);
				}
			}
			player[0].head_y = 32; player[1].head_y = 33;
			player[0].head_x = 50; player[1].head_x = 30;
			player[0].direction = 2; player[1].direction = 3;
			break;
		case 8:
			for(i=15; i<66; i++) {
				if(!(37<=i && i <= 44)){
					set_tile(i, 14, TILE_TYPE_WALL2);	
					set_tile(i, 51, TILE_TYPE_WALL2);	
				}
			}
			for(j=14; j<52; j++){
				set_tile(15, j, TILE_TYPE_WALL2);
				set_tile(65, j, TILE_TYPE_WALL2);				
			}
			player[0].head_y = 31; player[1].head_y = 33;
			player[0].head_x = 10; player[1].head_x = 70;
			player[0].direction = 0; player[1].direction = 1;
			break;
		case 9:
			//N
			for(i=0; i<10; i++) {
				set_tile(xp[0], i+yp[0], TILE_TYPE_WALL2);
				set_tile(10+xp[0], i+yp[0], TILE_TYPE_WALL2);
			}
			for(i=0; i<10; i++) {
				set_tile(i+xp[0], i+yp[0], TILE_TYPE_WALL2);
			}
			//C
			for(i=0; i<8; i++) {
				set_tile(i+xp[1]+2, 0+yp[1], TILE_TYPE_WALL2);
				set_tile(i+xp[1]+2, 10+yp[1], TILE_TYPE_WALL2);
			}
			for(i=0; i<7; i++) {
				set_tile(xp[1], 2+yp[1]+i, TILE_TYPE_WALL2);
			}
			set_tile(xp[1]+1, yp[1]+1, TILE_TYPE_WALL2);
			set_tile(xp[1]+1, yp[1]+9, TILE_TYPE_WALL2);
			//T
			for(i=0; i<9; i++) {
				set_tile(xp[2]+i, yp[2], TILE_TYPE_WALL2);
			}
			for(i=0; i<10; i++) {
				set_tile(xp[2]+4, yp[2]+i, TILE_TYPE_WALL2);
			}
			//U
			
			for(i=0; i<8; i++) {
				set_tile(0+xp[3], i+yp[3]+1, TILE_TYPE_WALL2);
				set_tile(10+xp[3],i+yp[3]+1, TILE_TYPE_WALL2);
			}
			for(i=0; i<7; i++) {
				set_tile(2+xp[3]+i, yp[3]+10, TILE_TYPE_WALL2);
			}			
			set_tile(xp[3]+1, yp[3]+9, TILE_TYPE_WALL2);
			set_tile(xp[3]+9, yp[3]+9, TILE_TYPE_WALL2);
						
			player[0].head_y = 10; player[1].head_y = 54;
			player[0].head_x = 75; player[1].head_x = 5;
			player[0].direction = 1; player[1].direction = 0;
			break;
	}
	for(i=0; i<2; i++)
	{
		player[i].qhead	= 0;
		player[i].speed	= MIN_SPEED;
		player[i].speed_clock =	0;
		player[i].length = SNAKE_INITIAL_LENGTH;
		player[i].length_on_screen = 0;
		player[i].health = MAX_HEALTH>>1;
		player[i].body[player[0].qhead].x =	player[0].head_x;
		player[i].body[player[0].qhead].y =	player[0].head_y;
		player[i].hit_wall = TILE_TYPE_BLACK;
		player[i].double_strength =	0;
		player[i].health_recover_clock = 0;
		player[i].next_direction = player[i].direction;
		player[i].prev_x = -1;
		player[i].prev_y = -1;
	}
	
	pill_num = 0;

}

struct snake_type player[2];
unsigned char game_level;
unsigned char game_restart;
void playSnake(int num_players)
{
	unsigned char done;
	int	i, j, k, l;
	int	x, y;
	int	qtail, qhead;

	#ifdef SDL
	   SDLKey keypressed;
	#else
		unsigned char keypressed;
	#endif

	setupLevel(player, game_level);

	print_string("MICHAEL:", PLAYER_STATUS_X_OFFSET[0], PLAYER_STATUS_Y_OFFSET);
	if(num_players==2) {
		print_string("LALA:", PLAYER_STATUS_X_OFFSET[1], PLAYER_STATUS_Y_OFFSET);
	}

	done = 0;
	game_restart = 0;

	while(done == 0)
	{
		#ifdef SDL
			process_event();
		#endif

		while(character_available(2)) {
			keypressed = get_character(2);
			rand_num();

			if(keypressed == SDLK_F10) {
				done = 1;
				game_restart = 1;
			}
			if(keypressed == SDLK_F5) {	// level down
				done = 1;
				game_level = game_level-1 >	1 ?	game_level-1 : 1;
			}
			if(keypressed == SDLK_F6) {	// level up
				done = 1;
				game_level = game_level+1 <= MAX_GAME_LEVEL	? game_level+1 : MAX_GAME_LEVEL;
			}
		}


		// Ūkeyboard
		/*
		while(character_available()) {
			keypressed = get_character();
			switch(keypressed) {
				case KEY_UP_ARROW: player[0].direction = 0;	break;
				case KEY_DOWN_ARROW: player[0].direction = 1; break;
				case KEY_LEFT_ARROW: player[0].direction = 2; break;
				case KEY_RIGHT_ARROW: player[0].direction =	3; break;
				case KEY_PLUS: player[0].length= player[0].length<MAX_SNAKE_LENGTH?player[0].length+1:MAX_SNAKE_LENGTH;	break;
				case KEY_MINUS:	player[0].length = player[0].length<=1?1:player[0].length-1; break;
			}

		}
		*/



		// Bzsnake
		for(i=0; i<num_players;	i++)
		{
			// l
			if(player[i].hit_wall != TILE_TYPE_BLACK) {
				// l 
				if(player[i].double_strength > 0) {
				}
				else {
					player[i].health--;
				}
				
				// big head, little head
				player[i].prev_x = player[i].head_x;
				player[i].prev_y = player[i].head_y;				
				switch(player[i].health%8) {
					case 0:
					case 1:
						set_tile(player[i].head_x, player[i].head_y, TILE_TYPE_PLAYER[i]);
						break;
					case 2:
					case 3:
						set_tile(player[i].head_x, player[i].head_y, TILE_TYPE_PLAYER_BIG[i]);
						break;
					case 4:
					case 5:
						set_tile(player[i].head_x, player[i].head_y, TILE_TYPE_PLAYER[i]);
						break;
					case 6:
					case 7:
						set_tile(player[i].head_x, player[i].head_y, TILE_TYPE_PLAYER_SMALL[i]);
						break;
				}
				
				/*
				// ܵu
				player[i].length = player[i].length-1>1?player[i].length-1:1;
				*/

				if(player[i].health	< 0)
				{
					done = 1;
				}
			}
			else {
				// normal head
				if(player[i].prev_x>0 && player[i].prev_y>0) {
					set_tile(player[i].prev_x, player[i].prev_y, TILE_TYPE_PLAYER[i]);
					player[i].prev_x = -1;
					player[i].prev_y = -1;
				}
				
				if(player[i].health_recover_clock++	== HEALTH_RECOVER_CLOCK) {
					player[i].health_recover_clock=0;
					player[i].health = (player[i].health+1)	< MAX_HEALTH ? player[i].health+1 :	MAX_HEALTH;
				}
			}
			
			// double strength {{ 
			if(player[i].double_strength > 0) {
				player[i].double_strength--;
				qhead =	player[i].qhead;
				for(j=0; j<player[i].length_on_screen; j++)	{
					qhead--;
					if(qhead<0)
						qhead+=MAX_SNAKE_LENGTH;

					if(player[i].double_strength&1)	{
						set_tile(player[i].body[qhead].x, player[i].body[qhead].y, TILE_TYPE_DOUBLE_STRENGTH[i]);
					}
					else {
						set_tile(player[i].body[qhead].x, player[i].body[qhead].y, TILE_TYPE_PLAYER[i]);
					}
				}
			}
			

			if(player[i].speed_clock++ < player[i].speed) {
				continue;
			}
			else { 

// Bzplayer
		if(character_available(i)) {
			keypressed = get_character(i);
			rand_num();

			if(keypressed == SDLK_UP &&	player[0].direction	!= 1) {
				player[0].next_direction = 0;
			}
			if(keypressed == SDLK_DOWN && player[0].direction != 0)	{
				player[0].next_direction = 1;
			}
			if(keypressed == SDLK_LEFT && player[0].direction != 3)	{
				player[0].next_direction = 2;
			}
			if(keypressed == SDLK_RIGHT	&& player[0].direction != 2) {
				player[0].next_direction = 3;
			}
			if(keypressed == SDLK_KP_PLUS) {
				player[0].length =
				player[0].length+1<MAX_SNAKE_LENGTH-1?player[0].length+1:MAX_SNAKE_LENGTH-1;
			}
			if(keypressed == SDLK_KP_MINUS)	{
				player[0].length =
				player[0].length<=1?1:player[0].length-1;
			}
			if(keypressed == SDLK_KP9) {
				player[0].double_strength += DOUBLE_STRENGTH_TIME;
			}
			if(keypressed == SDLK_w	&& player[1].direction != 1) {
				player[1].next_direction = 0;
			}
			if(keypressed == SDLK_s	&& player[1].direction != 0) {
				player[1].next_direction = 1;
			}
			if(keypressed == SDLK_a	&& player[1].direction != 3) {
				player[1].next_direction = 2;
			}
			if(keypressed == SDLK_d	&& player[1].direction != 2) {
				player[1].next_direction = 3;
			}
			if(keypressed == SDLK_1) {
				player[1].double_strength =	DOUBLE_STRENGTH_TIME;
				
			}
			if(keypressed == SDLK_2) {
				player[1].length =
				player[1].length<=1?1:player[1].length-1;
			}
			if(keypressed == SDLK_3) {
				player[1].length =
				player[1].length+1<MAX_SNAKE_LENGTH-1?player[1].length+1:MAX_SNAKE_LENGTH-1;
			}
		}
				player[i].next_x = player[i].head_x;
				player[i].next_y = player[i].head_y;
				//player[i].direction =	player[i].next_direction;
				switch(player[i].next_direction) {
					case 0:
						player[i].next_y --;
						break;
					case 1:
						player[i].next_y ++;
						break;
					case 2:
						player[i].next_x --;
						break;
					case 3:
						player[i].next_x ++;
						break;
				}
				// pGV|F,hV
				if(get_tile_type(player[i].next_x, player[i].next_y) ==	TILE_TYPE_WALL
				|| get_tile_type(player[i].next_x, player[i].next_y) ==	TILE_TYPE_PLAYER[0]
				|| get_tile_type(player[i].next_x, player[i].next_y) ==	TILE_TYPE_PLAYER[1]
				|| get_tile_type(player[i].next_x, player[i].next_y) ==	TILE_TYPE_PLAYER_BIG[0]
				|| get_tile_type(player[i].next_x, player[i].next_y) ==	TILE_TYPE_PLAYER_BIG[1]
				|| get_tile_type(player[i].next_x, player[i].next_y) ==	TILE_TYPE_PLAYER_SMALL[0]
				|| get_tile_type(player[i].next_x, player[i].next_y) ==	TILE_TYPE_PLAYER_SMALL[1]
				|| get_tile_type(player[i].next_x, player[i].next_y) ==	TILE_TYPE_DOUBLE_STRENGTH[0]
				|| get_tile_type(player[i].next_x, player[i].next_y) ==	TILE_TYPE_DOUBLE_STRENGTH[1]) {
					if(player[i].next_direction	!= player[i].direction)	{
						player[i].next_direction = player[i].direction;
							player[i].next_x = player[i].head_x;
							player[i].next_y = player[i].head_y;
							switch(player[i].next_direction) {
								case 0:
									player[i].next_y --;
									break;
								case 1:
									player[i].next_y ++;
									break;
								case 2:
									player[i].next_x --;
									break;
								case 3:
									player[i].next_x ++;
								break;
							}
					}
				}

				player[i].direction	= player[i].next_direction;
				player[i].speed_clock =	0;
			}


			if(get_tile_type(player[i].next_x, player[i].next_y) ==	TILE_TYPE_WALL
			|| get_tile_type(player[i].next_x, player[i].next_y) ==	TILE_TYPE_PLAYER[0]
			|| get_tile_type(player[i].next_x, player[i].next_y) ==	TILE_TYPE_PLAYER[1]
			|| get_tile_type(player[i].next_x, player[i].next_y) ==	TILE_TYPE_PLAYER_BIG[0]
			|| get_tile_type(player[i].next_x, player[i].next_y) ==	TILE_TYPE_PLAYER_BIG[1]
			|| get_tile_type(player[i].next_x, player[i].next_y) ==	TILE_TYPE_PLAYER_SMALL[0]
			|| get_tile_type(player[i].next_x, player[i].next_y) ==	TILE_TYPE_PLAYER_SMALL[1]						
			|| get_tile_type(player[i].next_x, player[i].next_y) ==	TILE_TYPE_DOUBLE_STRENGTH[0]
			|| get_tile_type(player[i].next_x, player[i].next_y) ==	TILE_TYPE_DOUBLE_STRENGTH[1]) {

				// 
				//player[i].health -= 1;
				player[i].hit_wall = get_tile_type(player[i].next_x, player[i].next_y);
			}
			else { // 
				int	qtail, qhead;
				player[i].hit_wall = TILE_TYPE_BLACK;

				player[i].head_x = player[i].next_x;
				player[i].head_y = player[i].next_y;

				player[i].body[player[i].qhead].x =	player[i].head_x;
				player[i].body[player[i].qhead].y =	player[i].head_y;
				player[i].length_on_screen++;
				set_tile(player[i].head_x, player[i].head_y, TILE_TYPE_PLAYER[i]);

				qhead =	player[i].qhead	+ 1;
				if(qhead ==	MAX_SNAKE_LENGTH)
					qhead =	0;
				player[i].qhead	= qhead;


				// check for pill
				for(j=0; j<pill_num; j++)
				{
					if(player[i].head_x	== pill[j].x &&	player[i].head_y ==	pill[j].y)
					{
						switch(pill[j].type) {
							case 0:	// Long
							case 6:
							case 7:
							player[i].length = (player[i].length+15)<MAX_SNAKE_LENGTH-1?player[i].length+15:MAX_SNAKE_LENGTH-1;
							break;
							case 1:	// Slow
							player[i].speed	= player[i].speed+1<=MIN_SPEED?player[i].speed+1:MIN_SPEED;
							break;
							case 2:	// Faster
							player[i].speed	= player[i].speed-1>MAX_SPEED?player[i].speed-1:MAX_SPEED;
							break;
							case 3:	// Double
							player[i].double_strength =	DOUBLE_STRENGTH_TIME;
							break;
							case 4:	// Health
							player[i].health = player[i].health+HEALTH_BAR_FRACTION*4<MAX_HEALTH?player[i].health+HEALTH_BAR_FRACTION*4:MAX_HEALTH;
							break;
							case 5:	// Random
							switch(rand_num()%6) {
								case 0:
								player[i].length = player[i].length+75<MAX_SNAKE_LENGTH-1?player[i].length+75:MAX_SNAKE_LENGTH-1;
								break;
								case 1:
								player[i].length = player[i].length/2 >	SNAKE_INITIAL_LENGTH ? player[i].length/2 :	SNAKE_INITIAL_LENGTH;
								break;
								case 2:
								player[i].health = MAX_HEALTH;
								break;
								case 3:	// fastest
								player[i].speed	= MAX_SPEED;
								break;
								case 4:	// slowest
								player[i].speed	= MIN_SPEED;
								break;
							}
							break;
						}
						for(k=j; k<pill_num-1; k++)	{
							pill[k]	= pill[k+1];
						}
						pill_num--;
					}
				}
			}

			for(j=0; j<2; j++) {
				if(player[i].length_on_screen >	player[i].length) {
					qtail =	(player[i].qhead - player[i].length_on_screen);
					if(qtail < 0)
						qtail += MAX_SNAKE_LENGTH;

					set_tile(player[i].body[qtail].x, player[i].body[qtail].y, TILE_TYPE_BLACK);
					player[i].length_on_screen--;
				}
			}

		}



		// random pill,	1% chance

		if(pill_num	< MAX_PILL && rand_num() < (0xFFFFFF>>8)) {
			int	x, y;
			while(1)
			{
				x =	(rand_num()%(BACKGROUND_X_NUM));
				y =	(rand_num()%(BACKGROUND_Y_NUM-4))+4;
				if(get_tile_type(x,	y) == TILE_TYPE_BLACK)
				break;
			}
			pill[pill_num].x = x;
			pill[pill_num].y = y;
			pill[pill_num].time	= PILL_ALIVE_TIME;
			pill[pill_num].type	= rand_num()%8;

			set_tile(x,	y, pill_font_map[pill[pill_num].type]);

			pill_num++;
		}


		// blinking	if pill	is about to	disappear
		for(i=0; i<pill_num; i++)
		{
			pill[i].time--;
			if(pill[i].time	< PILL_BLINK_TIME)
			{
				if(pill[i].time	& 1) {
					set_tile(pill[i].x,	pill[i].y, TILE_TYPE_BLACK);
				}
				else {
					set_tile(pill[i].x,	pill[i].y, pill_font_map[pill[i].type]);
				}
			}
			if(pill[i].time<0) {
				set_tile(pill[i].x,	pill[i].y, TILE_TYPE_BLACK);
				for(j=i; j<pill_num-1; j++)	{
					pill[j]	= pill[j+1];
				}
				pill_num--;
			}
		}


		// player health status
		for(i=0; i<num_players;	i++) {
			set_tile(PLAYER_STATUS_X_OFFSET[i],	PLAYER_STATUS_Y_OFFSET+2, TILE_TYPE_HSTATUS_FL);
			for(x=1, j=HEALTH_BAR_FRACTION;	player[i].health > j &&	j <	MAX_HEALTH-HEALTH_BAR_FRACTION;	j+=HEALTH_BAR_FRACTION,	x++) {
				set_tile(PLAYER_STATUS_X_OFFSET[i]+x, PLAYER_STATUS_Y_OFFSET+2,	TILE_TYPE_HSTATUS_FM);
			}
			for(; j	< MAX_HEALTH-HEALTH_BAR_FRACTION; j+=HEALTH_BAR_FRACTION, x++) {
				set_tile(PLAYER_STATUS_X_OFFSET[i]+x, PLAYER_STATUS_Y_OFFSET+2,	TILE_TYPE_HSTATUS_HM);
			}
			if(player[i].health	== MAX_HEALTH) {
				set_tile(PLAYER_STATUS_X_OFFSET[i]+x, PLAYER_STATUS_Y_OFFSET+2,	TILE_TYPE_HSTATUS_FR);
			}
			else {
				set_tile(PLAYER_STATUS_X_OFFSET[i]+x, PLAYER_STATUS_Y_OFFSET+2,	TILE_TYPE_HSTATUS_HR);
			}
		}


//		set_sprite(0, 27, sprite_y,	0);
//		sprite_y = (sprite_y+1)%140;
		#ifdef SDL
			drawScreen(screen);
		#else
			for(i=0; i<300000; i++);
		#endif
	}
}


int	main(int argc, char	**args)
{

	int	num_player = 2;
	int	i, j, k, d;
	int	qhead;
#ifdef SDL
	if(	SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO)	< 0	)
	{
		printf("Unable to init SDL:	%s\n", SDL_GetError());
		exit(1);
	}
	atexit(SDL_Quit);

	init_screen();
	SDLKey keypressed;
#else
	unsigned char keypressed;


   //print("Hello World!\r\n");

   //put_string("The Digilent Spartan 3	board says \"Hello from	NCTU\"", 0,	1);

   /* Enable MicroBlaze	interrupts */
   microblaze_enable_interrupts();
   /* Register the UART	interrupt handler in the vector	table */
   XIntc_RegisterHandler(XPAR_OPB_INTC_0_BASEADDR,XPAR_OPB_INTC_0_RS232_INTERRUPT_INTR,
	  (XInterruptHandler)uart_int_handler,(void	*)0);
   /* Register the keyboard	interrupt handler */
   XIntc_RegisterHandler(XPAR_OPB_INTC_0_BASEADDR, XPAR_OPB_INTC_0_SYSTEM_PS2C_INTR,
	  (XInterruptHandler)ps2_int_handler, (void	*)0);
   /* Start	the	interrupt controller */
   XIntc_mMasterEnable(XPAR_OPB_INTC_0_BASEADDR);
   /* Enable timer and UART	interrupt requests in the interrupt	controller */
   XIntc_mEnableIntr(XPAR_OPB_INTC_0_BASEADDR,
					 XPAR_RS232_INTERRUPT_MASK | XPAR_SYSTEM_PS2C_MASK);
   /* Enable UART interrupts */
   XUartLite_mEnableIntr(XPAR_RS232_BASEADDR);
#endif



while(1)
{
	setupLevel(player, 1);
	print_string("PRESS	F1 FOR 1 PLAYER	GAME", 27, 28);
	print_string("PRESS	F2 FOR 2 PLAYER	GAME", 27, 29);
	print_string("DURING GAME PLAY,	PRESS F10 TO RESTART", 21, 32);

	while(1) {
		#ifdef SDL
		drawScreen(screen);
		process_event();
		#endif

		if(character_available(2)) {
			keypressed = get_character(2);
			if(keypressed == SDLK_F1) {
				num_player = 1;
				break;
			}
			else if(keypressed == SDLK_F2) {
				num_player = 2;
				break;
			}
		}

	}

	game_level = 0;
	game_restart = 0;
	while(game_restart==0) {
		for(i=0; i<3; i++) {
			while(character_available(i)) {
				get_character(i);
			}
		}
		playSnake(num_player);

		// clear snake body
		for(j=0; j<5; j++) {
			for(i=0; i<num_player; i++)	{
				qhead =	player[i].qhead+j;
				for(k=0; k<player[i].length_on_screen; k+=5) {
					qhead-=5;
					if(qhead<0)
						qhead+=MAX_SNAKE_LENGTH;
					set_tile(player[i].body[qhead].x, player[i].body[qhead].y, TILE_TYPE_BLACK);
				}


			}
			#ifdef SDL
				drawScreen(screen);
				for(d=0; d<10000000; d++);
			#else
				for(d=0; d<500000; d++);
			#endif
		}
	}


}

	return 0;
}
