/*
 *  * Copyright (c) 2004 Xilinx, Inc.  All rights reserved.
 *
 * Xilinx, Inc.
 * XILINX IS PROVIDING THIS DESIGN, CODE, OR INFORMATION "AS IS" AS A 
 * COURTESY TO YOU.  BY PROVIDING THIS DESIGN, CODE, OR INFORMATION AS
 * ONE POSSIBLE   IMPLEMENTATION OF THIS FEATURE, APPLICATION OR 
 * STANDARD, XILINX IS MAKING NO REPRESENTATION THAT THIS IMPLEMENTATION 
 * IS FREE FROM ANY CLAIMS OF INFRINGEMENT, AND YOU ARE RESPONSIBLE 
 * FOR OBTAINING ANY RIGHTS YOU MAY REQUIRE FOR YOUR IMPLEMENTATION
 * XILINX EXPRESSLY DISCLAIMS ANY WARRANTY WHATSOEVER WITH RESPECT TO 
 * THE ADEQUACY OF THE IMPLEMENTATION, INCLUDING BUT NOT LIMITED TO 
 * ANY WARRANTIES OR REPRESENTATIONS THAT THIS IMPLEMENTATION IS FREE 
 * FROM CLAIMS OF INFRINGEMENT, IMPLIED WARRANTIES OF MERCHANTABILITY 
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 */

// Located in: microblaze_0/include/xparameters.h
#include "xparameters.h"

#include "xutil.h"
#include "xintc_l.h"
#include "xuartlite_l.h"
#include "xgpio_l.h"

#define FONT_OFFSET 0xA00

/* Address of a particular character on the screen (rows are 80) */
#define CHAR(c,r) \
   (((unsigned char *)(XPAR_VGA_BASEADDR))[(c) + ((r) << 6) + ((r) << 4)])

/* Start of font memory */
#define FONT ((unsigned char *)XPAR_VGA_BASEADDR + FONT_OFFSET)

int uart_interrupt_count = 0;
char uart_character;
 
/* UART interrupt service routine */
void uart_int_handler(void *baseaddr_p) {
   
   /* While UART receive FIFO has data */
   while (!XUartLite_mIsReceiveEmpty(XPAR_RS232_BASEADDR)) {
     /* Read a character */
     uart_character = XUartLite_RecvByte(XPAR_RS232_BASEADDR);
     ++uart_interrupt_count;
   }
}

/* Must be a power of two */
#define SCANCODE_BUFFER_SIZE 16
unsigned char scancode_buffer[SCANCODE_BUFFER_SIZE];
int scancode_buffer_head = 0;
int scancode_buffer_tail = 0;

int character_available()
{
  int result;
  microblaze_disable_interrupts();
  result = scancode_buffer_head != scancode_buffer_tail;
  microblaze_enable_interrupts();
  return result;	
}

unsigned char get_character()
{
  unsigned char result;
  microblaze_disable_interrupts();
  result = scancode_buffer[scancode_buffer_tail];
  scancode_buffer_tail = (scancode_buffer_tail + 1) & (SCANCODE_BUFFER_SIZE - 1);
  microblaze_enable_interrupts();
  return result;		
}

int keyboard_interrupt_count = 0;
unsigned int scan_code = 0;
unsigned int keyboard_bit = 11;

/* PS/2 Keyboard interrupt service routine */
void ps2_int_handler(void *baseaddr_p)
{
  int next_head;
  keyboard_interrupt_count++;
 
  /* We're reading a scancode and the keyboard clock fell: sample the data */
  scan_code = (scan_code >> 1) |
      (XGpio_mReadReg(XPAR_PS2IO_BASEADDR, XGPIO_DATA_OFFSET) << 9);
  if (--keyboard_bit == 0) {
    /* keycode is ready */
    next_head = (scancode_buffer_head + 1) & (SCANCODE_BUFFER_SIZE - 1);
    if (next_head != scancode_buffer_tail) {
      /* buffer is not full; add the character */
      scancode_buffer[scancode_buffer_head] = scan_code;
      scancode_buffer_head = next_head;
    }
    keyboard_bit = 11;
    scan_code = 0;
  }
   
  /* Acknowledge the interrupt */
  XGpio_mWriteReg(XPAR_PS2IO_BASEADDR, XGPIO_ISR_OFFSET, 1);
}

/* Write a text string on the display */
void put_string(char *string, int column, int row)
{
  char *p = &(CHAR(column, row));
  while (*p++ = *string++)
    ;
}

int main (void) {
   int i;
   
   print("Hello World!\r\n");

   put_string("The Digilent Spartan 3 board says \"Hello from NCTU\"", 0, 1);

   /* Enable MicroBlaze interrupts */
   microblaze_enable_interrupts();
   /* Register the UART interrupt handler in the vector table */
   XIntc_RegisterHandler(XPAR_OPB_INTC_0_BASEADDR,XPAR_OPB_INTC_0_RS232_INTERRUPT_INTR,
      (XInterruptHandler)uart_int_handler,(void *)0);
   /* Register the keyboard interrupt handler */
   XIntc_RegisterHandler(XPAR_OPB_INTC_0_BASEADDR, XPAR_OPB_INTC_0_SYSTEM_PS2C_INTR,
      (XInterruptHandler)ps2_int_handler, (void *)0);
   /* Start the interrupt controller */
   XIntc_mMasterEnable(XPAR_OPB_INTC_0_BASEADDR);
   /* Enable timer and UART interrupt requests in the interrupt controller */
   XIntc_mEnableIntr(XPAR_OPB_INTC_0_BASEADDR,
                     XPAR_RS232_INTERRUPT_MASK | XPAR_SYSTEM_PS2C_MASK);
   /* Enable UART interrupts */
   XUartLite_mEnableIntr(XPAR_RS232_BASEADDR);

  for (;;) {
    if (character_available()) {
    	 print("Got scancode ");
    	 putnum(get_character());
    	 print("\r\n");
     }
     for (i = 0 ; i < 1000 ; i++ )  ; /* delay */
  }
  
   print("Goodbye! \r\n");
   return 0;
}

