-------------------------------------------------------------------------------
-- opb_complex_multiplier_0_wrapper.vhd
-------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

library UNISIM;
use UNISIM.VCOMPONENTS.ALL;

library opb_complex_multiplier;
use opb_complex_multiplier.all;

entity opb_complex_multiplier_0_wrapper is
  port (
    OPB_Clk : in std_logic;
    OPB_Rst : in std_logic;
    OPB_ABus : in std_logic_vector(31 downto 0);
    OPB_BE : in std_logic_vector(3 downto 0);
    OPB_DBus : in std_logic_vector(31 downto 0);
    OPB_RNW : in std_logic;
    OPB_select : in std_logic;
    OPB_seqAddr : in std_logic;
    MULT_DBus : out std_logic_vector(31 downto 0);
    MULT_errAck : out std_logic;
    MULT_retry : out std_logic;
    MULT_toutSup : out std_logic;
    MULT_xferAck : out std_logic
  );
end opb_complex_multiplier_0_wrapper;

architecture STRUCTURE of opb_complex_multiplier_0_wrapper is

  component opb_complex_multiplier is
    generic (
      C_OPB_AWIDTH : INTEGER;
      C_OPB_DWIDTH : INTEGER;
      C_BASEADDR : std_logic_vector(31 downto 0);
      C_HIGHADDR : std_logic_vector(31 downto 0)
    );
    port (
      OPB_Clk : in std_logic;
      OPB_Rst : in std_logic;
      OPB_ABus : in std_logic_vector(31 downto 0);
      OPB_BE : in std_logic_vector(3 downto 0);
      OPB_DBus : in std_logic_vector(31 downto 0);
      OPB_RNW : in std_logic;
      OPB_select : in std_logic;
      OPB_seqAddr : in std_logic;
      MULT_DBus : out std_logic_vector(31 downto 0);
      MULT_errAck : out std_logic;
      MULT_retry : out std_logic;
      MULT_toutSup : out std_logic;
      MULT_xferAck : out std_logic
    );
  end component;

begin

  opb_complex_multiplier_0 : opb_complex_multiplier
    generic map (
      C_OPB_AWIDTH => 32,
      C_OPB_DWIDTH => 32,
      C_BASEADDR => X"01800000",
      C_HIGHADDR => X"01803fff"
    )
    port map (
      OPB_Clk => OPB_Clk,
      OPB_Rst => OPB_Rst,
      OPB_ABus => OPB_ABus,
      OPB_BE => OPB_BE,
      OPB_DBus => OPB_DBus,
      OPB_RNW => OPB_RNW,
      OPB_select => OPB_select,
      OPB_seqAddr => OPB_seqAddr,
      MULT_DBus => MULT_DBus,
      MULT_errAck => MULT_errAck,
      MULT_retry => MULT_retry,
      MULT_toutSup => MULT_toutSup,
      MULT_xferAck => MULT_xferAck
    );

end architecture STRUCTURE;
