#include "xbasic_types.h"
#include "xio.h"

#include "xintc_l.h"
#include "xuartlite_l.h"
#include "xparameters.h"

#define REG1ADDR 0x01803FFC
#define REG2ADDR 0x01802FFC
#define REG3ADDR 0x01801FFC
#define REG4ADDR 0x01800FFC

#define CHECKADDR  0x01803FFC
#define RESULTADDR 0x01802FFC

int main()
{
  Xuint32 mult;
  Xuint32 concat;

  /* Write 4 registers */
  XIo_Out32(REG1ADDR, 0x5);
  XIo_Out32(REG2ADDR, 0xFE);
  XIo_Out32(REG3ADDR, 0xE);
  XIo_Out32(REG4ADDR, 0x02);
  
  /* Read the registers  just */
  /* written for sanity check */
  print("\r\nRegisters written\r\n");
  concat = XIo_In32(CHECKADDR); // reg1 & reg2 & reg3 & reg4 in the vhdl
  putnum(concat);

  /* Read the result of the multiplication reg1*reg2 */
  print("\r\nMultiplication result\r\n");
  mult = XIo_In32(0x01802FFC); // X"0000" & regout in the vhdl
  putnum(mult);

  return 0;
}
