LIBRARY ieee ;
USE ieee.std_logic_1164.all;

entity testbench is
end testbench;

architecture behavioral of testbench is
  signal clk : std_logic := '0';

  signal anode : std_logic_vector(3 downto 0);
  signal cathode : std_logic_vector(7 downto 0);

  component system
  port (
    mclk : in std_logic;           -- external clock
    anode : out std_logic_vector(3 downto 0);
    cathode : out std_logic_vector(7 downto 0)
  );

  end component;
begin

  dut: system
    port map (
      mclk    => clk,
      anode   => anode,
      cathode => cathode
      );

  clkgen : process
  begin
    wait for 20 ns;
    clk <= not clk;
  end process;
  
end behavioral;
