library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.all;
use IEEE.STD_LOGIC_UNSIGNED.all;

entity system is
  port (
    mclk    : in std_logic;
    anode   : out std_logic_vector(3 downto 0);
    cathode : out std_logic_vector(7 downto 0)
  );
end system;

architecture imp of system is

  component hexdisplay
    port (
      clk     : in std_logic;
	 byte    : in std_logic_vector(7 downto 0);
      cathode : out std_logic_vector(7 downto 0);
      anode   : out std_logic_vector(3 downto 0) );
  end component;

  signal cnt24 : std_logic_vector(23 downto 0) := X"000000";  -- clk divider
  signal cnt8 : std_logic_vector(7 downto 0) := X"00";        -- our counter
  signal slow_clk : std_logic;

  signal leftleds  : std_logic_vector(6 downto 0);
  signal rightleds : std_logic_vector(6 downto 0);

  type rom_type is array(0 to 3) of std_logic_vector(7 downto 0);
  constant ROM : rom_type := (X"C5", X"EE", X"48", X"40");

  signal rom_data : std_logic_vector(7 downto 0);

begin

  -----------------------------------------------------------------------------
  --
  -- For lab 4, make changes starting from here.
  --

  -- High-frequency clock divider

  fast_clock_divider : process (mclk)
  begin
    if mclk'event and mclk = '1' then  -- rising clock edge
      cnt24 <= cnt24 + 1;
    end if;
  end process;

  -- slow_clk <= cnt24(0);              -- faster version for simulation
  slow_clk <= cnt24(23);

  slow_counter : process (slow_clk)
  begin
    if slow_clk'event and slow_clk = '1' then              -- rising clock edge
      cnt8 <= cnt8 + 1;
    end if;
  end process;

  read_rom: process (mclk)
    begin
    if mclk'event and mclk = '1' then
      rom_data <= ROM(conv_integer(cnt8(1 downto 0)));
    end if;
  end process;

  -- 
  -- End of suggested lab4 change region
  --  
  -----------------------------------------------------------------------------

  display : hexdisplay
    port map (
      clk     => mclk,
      byte    => rom_data,
      anode   => anode,
      cathode => cathode
    );
  
end imp;

