library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_UNSIGNED.all;

entity hexdisplay is
  port (
    clk     : in  std_logic;
    byte    : in  std_logic_vector(7 downto 0);
    cathode : out std_logic_vector(7 downto 0);
    anode   : out std_logic_vector(3 downto 0)
  );     

end hexdisplay;

architecture structural of hexdisplay is

  signal clk_divider : std_logic_vector(11 downto 0) :=  X"000";
  signal digit       : std_logic_vector(3 downto 0);
  signal digit_clk   : std_logic;
  
begin

  clock_divider : process (clk)
  begin
    if clk'Event and clk = '1' then
      clk_divider <= clk_divider + 1;
    end if;
  end process;

  -- digit_clk <= clk_divider(0);	-- Fast clock for simulation
  digit_clk <= clk_divider(11);

  digit <=
    byte(7 downto 4) when digit_clk = '1' else
    byte(3 downto 0);

  anode <=
    "1110" when digit_clk = '1' else
    "1101";

  cathode(6 downto 0) <=
    "1000000" when digit = "0000" else
    "1111001" when digit = "0001" else
    "0100100" when digit = "0010" else
    "0110000" when digit = "0011" else
    "0011001" when digit = "0100" else
    "0010010" when digit = "0101" else
    "0000010" when digit = "0110" else
    "1111000" when digit = "0111" else
    "0000000" when digit = "1000" else
    "0010000" when digit = "1001" else
    "0001000" when digit = "1010" else
    "0000011" when digit = "1011" else
    "1000110" when digit = "1100" else
    "0100001" when digit = "1101" else
    "0000110" when digit = "1110" else
    "0001110" when digit = "1111" else
    "1111111";

   cathode(7) <= '1';  -- Turn off the Decimal Point

end structural;

