library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity testbench is
  
end testbench;

architecture behavioral of testbench is

  signal clk : std_logic := '0';
  signal reset, enable : std_logic;
  signal x, y, z: std_logic_vector(7 downto 0);

  component dumb_alu
    port ( clk     : in  std_logic;
           reset   : in  std_logic;
           enable  : in  std_logic;
           x, y    : in  std_logic_vector (7 downto 0);
           z       : out std_logic_vector (7 downto 0) );
  end component;

begin

  dut: dumb_alu
    port map (
      clk => clk,
      reset => reset,
      enable => enable,
      x => x,
      y => y,
      z => z);

  -----------------------------------------------------------------------------
  --
  -- Processes, etc., for a testbench
  --

  -- repeating process best for generating a clock
  -- Note that the clock was initialized in the definition of its signal
  clkgen : process
  begin
    wait for 10 ns;
    clk <= not clk;
  end process;

   -- For simple waveforms, use "<=" and "after"
   reset <= '1',
            '0' after 60 ns;

   enable <= '0',
             '1' after 120 ns,
             '0' after 140 ns,
             '1' after 160 ns,
             '0' after 180 ns;

   -- For more complicated things, use a process
   datagen : process
   begin
     wait for 51 ns;
     x <= X"04";
     y <= X"02";
     wait for 20 ns;
     x <= X"03";
     y <= X"00";
     wait for 20 ns;
     x <= X"08";
     y <= X"01";
     wait for 20 ns;
     x <= X"07";
     y <= X"04";
     wait for 20 ns;
     x <= X"05";
     y <= X"03";
     wait for 20 ns;
     x <= X"06";
     y <= X"05";
     wait for 40 ns;
     x <= X"07";
     y <= X"01";
     wait;  -- forever
   end process;

end behavioral;
