library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity dumb_alu is
  port ( clk     : in  std_logic;
         reset   : in  std_logic;
         enable  : in  std_logic;
         x, y    : in  std_logic_vector ( 7 downto 0);
         z       : out std_logic_vector ( 7 downto 0) );
end dumb_alu;

architecture behavioral of dumb_alu is

  signal w : std_logic_vector(7 downto 0);
  
begin
  process (clk)
  begin
    if clk'event and clk='1' then
      if reset='1' then
        w <= "00000000";
      elsif enable='1' then
        w <= y - 4;
      else
        w <= x + y;
      end if;
    end if;
  end process;

  z <= w;
  
end behavioral;
