-----------------------------------------------------------------------------
  --
  -- Processes, etc., for a testbench
  --

library ieee;
use ieee.std_logic_1164.all;	   
use ieee.std_logic_arith.all;
use work.all;

entity testbench is				-- entity declaration
end testbench;

---------------------------------------------------------------------

architecture behavioral of testbench is

    component design3 is 
    port(   rst, clk, go_i: in std_logic; 
	    x_i, y_i: in std_logic_vector( 3 downto 0 ); 
	    d_o: out std_logic_vector( 3 downto 0 ) 
    ); 
    end component; 

    signal T_clk,T_rst,T_Go_i: std_logic;
    signal T_x_i,T_y_i,T_D_o: std_logic_vector(3 downto 0);

begin

    U1: design3 port map(T_rst,T_clk,T_Go_i,T_x_i,T_y_i,T_D_o);

    Clk_sig: process
    begin
        T_clk<='1';				-- clock signal
        wait for 5 ns;
        T_clk<='0';
        wait for 5 ns;
    end process;

    process	

	variable err_cnt: integer := 0;

    begin
	
        T_rst <= '1';
        wait for 10 ns;
        T_rst <= '0';
        wait for 10 ns;

	-- case 1: input C & 8, output should be 4 
        T_x_i<="1100";			
	T_y_i<="1000";
	T_Go_i <= '1';
	wait for 20 ns;
	T_Go_i <='0';
	wait for 300 ns;						  
	assert(T_D_o="0100") report "Error1" severity error;
	if (T_D_o/="0100") then
	    err_cnt := err_cnt + 1;
	end if;

	-- case 2: input 3 & 9, output should be 3
	T_x_i<="0011";			
	T_y_i<="1001";	
	T_Go_i <= '1';
	wait for 20 ns;
	T_Go_i <='0';
	wait for 300 ns;		   
	assert(T_D_o="0011") report "Error2" severity error;
	if (T_D_o/="0011") then
	    err_cnt := err_cnt + 1;
	end if;

	-- case 3: input 7 & 5, output should be 1
	T_x_i<="0111";			
	T_y_i<="0101";
	T_Go_i <= '1';
	wait for 20 ns;
	T_Go_i <='0';
	wait for 300 ns;					  
	assert(T_D_o="0001") report "Error3" severity error;
	if (T_D_o/="0001") then
	    err_cnt := err_cnt + 1;
	end if;
	
	-- case 4: input A & A, output should be 10
	T_x_i<="1010";			
	T_y_i<="1010";
	T_Go_i <= '1';
	wait for 20 ns;
	T_Go_i <='0';
	wait for 300 ns;	 
	assert(T_D_o="1010") report "Error4" severity error;
	if (T_D_o/="1010") then
	    err_cnt := err_cnt + 1;
	end if;
	
	-- case input 6 & A, output should be 2
	T_x_i<="0110";			
	T_y_i<="1010";
	T_Go_i <= '1';
	wait for 20 ns;
	T_Go_i <='0';
	wait for 300 ns;	  
	assert(T_D_o="0010") report "Error5" severity error;		
	if (T_D_o/="0010") then
	    err_cnt := err_cnt + 1;
	end if;

	-- summary of all the tests
	if (err_cnt=0) then 			
	    assert false 
	    report "Testbench of design3 completed successfully!" 
	    severity note; 
	else 
	    assert true 
	    report "Something wrong, try again" 
	    severity error; 
	end if; 

	wait;

    end process;

end behavioral;

