LIBRARY ieee;
USE     ieee.std_logic_1164.all ;
USE     ieee.std_logic_arith.all ;
USE     ieee.std_logic_signed.all ;
USE     ieee.std_logic_unsigned.all ;

ENTITY design2 IS
   PORT( nclr, nload, ent, enp   : IN std_logic ;
         d, c, b, a, clk         : IN std_logic ;
         qd, qc, qb, qa, rco	 : OUT std_logic
   );
END design2;


ARCHITECTURE behavioral OF design2 IS
BEGIN
   count: PROCESS( nclr, clk, ent, enp )
      VARIABLE icount : unsigned(3 DOWNTO 0) ;
   BEGIN
      IF (nclr = '0') THEN
         icount := "0000" ;
      ELSIF clk'event and clk='1' THEN
         IF (nload = '0') THEN
             icount := (d,c,b,a) ;
         ELSIF (ent='1' AND enp='1') THEN
             icount :=  icount +  "0001" ;
         END IF;
      END IF;	
      IF (icount = 15 AND ent='1' ) THEN
         rco <= '1' ;
      ELSE
         rco <= '0' ;
      END IF;
      qa <= std_logic(icount(0)) ;
      qb <= std_logic(icount(1)) ;
      qc <= std_logic(icount(2)) ;
      qd <= std_logic(icount(3)) ;	
   END PROCESS ;	
END behavioral;
