library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity testbench is
  
end testbench;

architecture behavioral of testbench is

  signal a, b, cin, cout, sum: std_logic;

  component design1
   port( a, b : in std_logic ;
         cin  : in std_logic ;
         cout : out std_logic ;
         sum  : out std_logic ) ;
  end component;
  

begin
    
  dut: design1
    port map (
      a => a,
      b => b,
      cin => cin,
      cout => cout,
      sum => sum);

-----------------------------------------------------------------------------
  --
  -- Processes, etc., for a testbench
  --

   -- For more complicated things, use a process
   datagen : process
   begin
     wait for 51 ns;
     a   <= '0';
     b   <= '0';
     cin <= '0';
     wait for 20 ns;
     a   <= '1';
     b   <= '0';
     cin <= '0';
     wait for 20 ns;
     a   <= '1';
     b   <= '0';
     cin <= '1';
     wait for 20 ns;
     a   <= '1';
     b   <= '1';
     cin <= '0';
     wait for 20 ns;
     a   <= '1';
     b   <= '1';
     cin <= '1';
     wait for 20 ns;
     a   <= '0';
     b   <= '0';
     cin <= '1';
     wait for 40 ns;
     a   <= '0';
     b   <= '1';
     cin <= '0';
     wait for 20 ns;
     a   <= '0';
     b   <= '1';
     cin <= '1';   
     wait;  -- forever
   end process;

end behavioral;
