-------------------------------------------------------------------------------
-- opb_s3board_vga_0_wrapper.vhd
-------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

library UNISIM;
use UNISIM.VCOMPONENTS.ALL;

library opb_s3board_vga;
use opb_s3board_vga.all;

entity opb_s3board_vga_0_wrapper is
  port (
    OPB_Clk : in std_logic;
    OPB_Rst : in std_logic;
    OPB_ABus : in std_logic_vector(31 downto 0);
    OPB_BE : in std_logic_vector(3 downto 0);
    OPB_DBus : in std_logic_vector(31 downto 0);
    OPB_RNW : in std_logic;
    OPB_select : in std_logic;
    OPB_seqAddr : in std_logic;
    VGA_DBus : out std_logic_vector(31 downto 0);
    VGA_errAck : out std_logic;
    VGA_retry : out std_logic;
    VGA_toutSup : out std_logic;
    VGA_xferAck : out std_logic;
    Pixel_Clock_2x : in std_logic;
    VIDOUT_CLK : out std_logic;
    VIDOUT_RED : out std_logic;
    VIDOUT_GREEN : out std_logic;
    VIDOUT_BLUE : out std_logic;
    VIDOUT_HSYNC : out std_logic;
    VIDOUT_VSYNC : out std_logic
  );
end opb_s3board_vga_0_wrapper;

architecture STRUCTURE of opb_s3board_vga_0_wrapper is

  component opb_s3board_vga is
    generic (
      C_OPB_AWIDTH : INTEGER;
      C_OPB_DWIDTH : INTEGER;
      C_BASEADDR : std_logic_vector(31 downto 0);
      C_HIGHADDR : std_logic_vector(31 downto 0)
    );
    port (
      OPB_Clk : in std_logic;
      OPB_Rst : in std_logic;
      OPB_ABus : in std_logic_vector(31 downto 0);
      OPB_BE : in std_logic_vector(3 downto 0);
      OPB_DBus : in std_logic_vector(31 downto 0);
      OPB_RNW : in std_logic;
      OPB_select : in std_logic;
      OPB_seqAddr : in std_logic;
      VGA_DBus : out std_logic_vector(31 downto 0);
      VGA_errAck : out std_logic;
      VGA_retry : out std_logic;
      VGA_toutSup : out std_logic;
      VGA_xferAck : out std_logic;
      Pixel_Clock_2x : in std_logic;
      VIDOUT_CLK : out std_logic;
      VIDOUT_RED : out std_logic;
      VIDOUT_GREEN : out std_logic;
      VIDOUT_BLUE : out std_logic;
      VIDOUT_HSYNC : out std_logic;
      VIDOUT_VSYNC : out std_logic
    );
  end component;

begin

  opb_s3board_vga_0 : opb_s3board_vga
    generic map (
      C_OPB_AWIDTH => 32,
      C_OPB_DWIDTH => 32,
      C_BASEADDR => X"80201000",
      C_HIGHADDR => X"80201fff"
    )
    port map (
      OPB_Clk => OPB_Clk,
      OPB_Rst => OPB_Rst,
      OPB_ABus => OPB_ABus,
      OPB_BE => OPB_BE,
      OPB_DBus => OPB_DBus,
      OPB_RNW => OPB_RNW,
      OPB_select => OPB_select,
      OPB_seqAddr => OPB_seqAddr,
      VGA_DBus => VGA_DBus,
      VGA_errAck => VGA_errAck,
      VGA_retry => VGA_retry,
      VGA_toutSup => VGA_toutSup,
      VGA_xferAck => VGA_xferAck,
      Pixel_Clock_2x => Pixel_Clock_2x,
      VIDOUT_CLK => VIDOUT_CLK,
      VIDOUT_RED => VIDOUT_RED,
      VIDOUT_GREEN => VIDOUT_GREEN,
      VIDOUT_BLUE => VIDOUT_BLUE,
      VIDOUT_HSYNC => VIDOUT_HSYNC,
      VIDOUT_VSYNC => VIDOUT_VSYNC
    );

end architecture STRUCTURE;
