-------------------------------------------------------------------------------
-- sram_256kx32_util_bus_split_0_wrapper.vhd
-------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

library UNISIM;
use UNISIM.VCOMPONENTS.ALL;

library util_bus_split_v1_00_a;
use util_bus_split_v1_00_a.all;

entity sram_256kx32_util_bus_split_0_wrapper is
  port (
    Sig : in std_logic_vector(0 to 31);
    Out1 : out std_logic_vector(12 to 29);
    Out2 : out std_logic_vector(30 to 31)
  );
end sram_256kx32_util_bus_split_0_wrapper;

architecture STRUCTURE of sram_256kx32_util_bus_split_0_wrapper is

  component util_bus_split is
    generic (
      C_SIZE_IN : integer;
      C_LEFT_POS : integer;
      C_SPLIT : integer
    );
    port (
      Sig : in std_logic_vector(0 to C_SIZE_IN-1);
      Out1 : out std_logic_vector(C_LEFT_POS to C_SPLIT-1);
      Out2 : out std_logic_vector(C_SPLIT to C_SIZE_IN-1)
    );
  end component;

begin

  sram_256kx32_util_bus_split_0 : util_bus_split
    generic map (
      C_SIZE_IN => 32,
      C_LEFT_POS => 12,
      C_SPLIT => 30
    )
    port map (
      Sig => Sig,
      Out1 => Out1,
      Out2 => Out2
    );

end architecture STRUCTURE;
