 /*
  * (C) 2003-2004 Columbia University Departments of Computer Science and
  * Electrical Engineering
  *
  * Redistribution and use in source and binary forms, with or without
  * modification, is permitted provided the original authors give
  * written consent and the following conditions are met:
  *
  * 1. Redistributions of source code must retain the above copyright
  *    notice, this list of conditions and the following disclaimer.
  * 2. Redistributions in binary form must reproduce the above
  *    copyright notice, this list of conditions and the following
  *    disclaimer in the documentation and/or other materials
  *    provided with the distribution.
  *
  * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND
  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
  * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
  * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS
  * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
  * OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
  * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
  * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
  * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
  * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
  * OF SUCH DAMAGE.
  */
package settings;

import util.Debug;
import client.BrowserToProxySSLApplet;
import client.SSLSocketClient;
import server.SSLSocketServer;
import java.util.Map;
import java.util.HashMap;


// should read these from config
public class Settings extends HashMap
{

    private static Settings _instance = new Settings();
    public static final String SERVER_HOSTNAME = "SERVER_HOSTNAME";
    public static final String SERVER_PORT = "SERVER_PORT";
    public static final String PROXY_HOSTNAME = "PROXY_HOSTNAME";
    public static final String PROXY_PORT = "PROXY_PORT";
    public static final String APPLET_PORT = "APPLET_PORT";
    public static final String SSL_CONTEXT_PROTOCOL = "SSL_CONTEXT_PROTOCOL";
    public static final String KEY_MANAGER_FACTORY_ALGORITHM = "KEY_MANAGER_FACTORY_ALGORITHM";
    public static final String TRUST_MANAGER_FACTORY_ALGORITHM = "TRUST_MANAGER_FACTORY_ALGORITHM";
    public static final String KEY_STORE_TYPE = "KEY_STORE_TYPE";
    public static final String KEY_PASSWORD = "KEY_PASSWORD";
    public static final String KEY_STORE_PASSWORD = "KEY_STORE_PASSWORD";
    public static final String KEY_FILE_DIRECTORY = "KEY_FILE_DIRECTORY";
    public static final String KEY_URL = "KEY_URL_MIGHT_BE_LONG";


    private Settings()
    {
		super();
		fillMap();
		setDebugInfo();
    }


    public static Map instance()
    {
		return _instance;
    }


    private void fillMap()
    {
		//Default Settings change appropriately
		put(SERVER_HOSTNAME, "sos30.cs.columbia.edu");
		put(SERVER_PORT, new Integer(18080));
		put(APPLET_PORT, new Integer(8080));
		//Change only in case we test the module we connect
		//to a regular Proxy (normal HTTP)
		//instead of the Encrypted Java server
		put(PROXY_HOSTNAME, "sos30.cs.columbia.edu");
		put(PROXY_PORT, new Integer(8080));
		//SSL Protocol and Key Specifications
		put(SSL_CONTEXT_PROTOCOL, "SSLv3");
		put(KEY_MANAGER_FACTORY_ALGORITHM, "SunX509");
		put(TRUST_MANAGER_FACTORY_ALGORITHM, "SunX509");
		put(KEY_STORE_TYPE, "JKS");
		put(KEY_PASSWORD, "test12345");
		put(KEY_STORE_PASSWORD, "test12345");
		//Key Location both for the server and the remote client 
		put(KEY_FILE_DIRECTORY, "/www-root/main/proxylet/packages/settings/keyFile");
		put(KEY_URL, "http://sos30.cs.columbia.edu/proxylet/packages/settings/keyFile");
    }

    
    private void setDebugInfo()
    {
		// This class sets the debug info
		Debug.setEnabled(BrowserToProxySSLApplet.class.getName(), false);
		Debug.setEnabled(SSLSocketClient.class.getName(), false);
		Debug.setEnabled(SSLSocketServer.class.getName(), false);
    }
}
