 /*
  * (C) 2003-2004 Columbia University Departments of Computer Science and
  * Electrical Engineering
  *
  * Redistribution and use in source and binary forms, with or without
  * modification, is permitted provided the original authors give
  * written consent and the following conditions are met:
  *
  * 1. Redistributions of source code must retain the above copyright
  *    notice, this list of conditions and the following disclaimer.
  * 2. Redistributions in binary form must reproduce the above
  *    copyright notice, this list of conditions and the following
  *    disclaimer in the documentation and/or other materials
  *    provided with the distribution.
  *
  * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND
  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
  * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
  * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS
  * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
  * OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
  * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
  * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
  * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
  * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
  * OF SUCH DAMAGE.
  */
import java.util.*;

public class SynchHashMap extends Thread {
    public static final int TIME_TO_WAIT = 10;      // seconds
    public static final int CACHE_CLEAR_TIME = 30;  // seconds
    public static final int CACHE_CLEAR_INTERVAL = 2;// time the clearer runs

    HashMap al;

    public SynchHashMap () {
        al = new HashMap();
        this.start();
    }

    /* used to periodically clean out cache to ensure healing */
    public void run() {
        while (true) {
            try {
                Thread.sleep(CACHE_CLEAR_INTERVAL * 1000);
            }
            catch (Exception e) { 
                System.err.println("SynchHashMap: err in sleep" + e);
            }
            synchronized(this) {
                Set s = al.keySet();
                for (Iterator i = s.iterator(); i.hasNext(); ) {
                    Object key = i.next();
                    ShortcutCacheEntry sce = (ShortcutCacheEntry)
                                                      al.get(key);
                    if (System.currentTimeMillis() > (sce.timeStamp + 
                                          (CACHE_CLEAR_TIME*1000))) {
                         al.remove(key);
                    }
                }
            }
        }
    }

    public synchronized Object getWait(Object key) {
        long startTime = System.currentTimeMillis();

        Object value = al.get(key);
        if (value == null) {
            while (System.currentTimeMillis()<startTime+(TIME_TO_WAIT * 1000)){
                try {
                    this.wait(500);
                    value = al.get(key);
                    if (value != null) {
                        return value;
                    }
                    System.err.println("woke up, but did not find " + key);
                }
                catch (InterruptedException e) {
                    System.err.println("SynchHashMap woke up.");
                }
            }
            System.err.println("Stopped waiting");
            return null;
        }
        else
            return value;

    }

    public synchronized Object get(Object key) {
        return al.get(key);
    }

    public synchronized void put(Object key, Object value) {
        al.put(key, value);
        this.notifyAll();
    }

    public int size() {
        return al.size();
    }

    public String toString() {
        return al.toString();
    }
}
