 /*
  * (C) 2003-2004 Columbia University Departments of Computer Science and
  * Electrical Engineering
  *
  * Redistribution and use in source and binary forms, with or without
  * modification, is permitted provided the original authors give
  * written consent and the following conditions are met:
  *
  * 1. Redistributions of source code must retain the above copyright
  *    notice, this list of conditions and the following disclaimer.
  * 2. Redistributions in binary form must reproduce the above
  *    copyright notice, this list of conditions and the following
  *    disclaimer in the documentation and/or other materials
  *    provided with the distribution.
  *
  * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND
  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
  * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
  * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS
  * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
  * OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
  * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
  * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
  * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
  * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
  * OF SUCH DAMAGE.
  */
/**
 * Shortcut is used in the version of WebSOS in which the SOAP connects
 * directly to the servlet. This is used to send the periodic announcements
 * that we are the servlet for particular targets
 *
 * Part of WebSOS
 *
 * @author     Bill Morein
 * @version    3/9/03
 */

import java.io.*;
import java.net.*;
import java.util.*;

public class ShortcutAnnounce extends Thread {

    public static final int SERVLET_CODE = 2;
    public static final int UPDATE_DELAY_SECONDS = 20;

    DatagramSocket  socket;
    String          localIP;
    int             localPort;
    boolean         stayAlive;
    ArrayList       targets;
    ShortcutRouter  parent;

    public ShortcutAnnounce(ArrayList targets, int localPort, 
                            ShortcutRouter sr) {

        this.targets = targets;
        parent = sr;

        try {
            localIP = sr.localIP;
        }
        catch (Exception e) {
            System.err.println("ShortcutAnnounce: could not get local addr: "+
                               e);
        }
        this.localPort = localPort;
        stayAlive = true;


        /* open the socket we will send out on */
        try {
            socket = new DatagramSocket();
        }
        catch (IOException e) {
            System.err.println("Unable to open socket, exiting: " + e);
            System.exit(0);
        }
    }


    public void run() {
        while (stayAlive) {
            try {
                System.err.println("woke up");
                for (int i=0; i<targets.size(); i++) {
                    System.out.println((String)targets.get(i));
                    sendUpdate((String)targets.get(i));
                }
                this.sleep(UPDATE_DELAY_SECONDS * 1000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

    }


    public void sendUpdate(String targetIP) {
        try {

            /* get this from chord instead */
            String nextHop = parent.queryRoutingAlg(targetIP);
            InetAddress nextAddr = InetAddress.getByName(nextHop);
            int nextPort = parent.UDP_PORT;

            String send = SERVLET_CODE + "," + localIP + ":" + localPort +
                          "," + targetIP;
            byte[] buf = send.getBytes();
            DatagramPacket packet = new DatagramPacket(buf, buf.length,
                                                       nextAddr, nextPort);
            socket.send(packet);
        }
        catch (IOException e) {
            e.printStackTrace();
        }

    }
}
