 /*
  * (C) 2003-2004 Columbia University Departments of Computer Science and
  * Electrical Engineering
  *
  * Redistribution and use in source and binary forms, with or without
  * modification, is permitted provided the original authors give
  * written consent and the following conditions are met:
  *
  * 1. Redistributions of source code must retain the above copyright
  *    notice, this list of conditions and the following disclaimer.
  * 2. Redistributions in binary form must reproduce the above
  *    copyright notice, this list of conditions and the following
  *    disclaimer in the documentation and/or other materials
  *    provided with the distribution.
  *
  * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND
  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
  * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
  * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS
  * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
  * OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
  * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
  * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
  * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
  * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
  * OF SUCH DAMAGE.
  */
import java.io.*;
import java.net.*;
import java.util.*;

public class LogSender {

    DatagramSocket socket;
    InetAddress ls;
    String thisIP;

    public LogSender (String logServer) {
	try {
	    socket = new DatagramSocket();
	    ls = InetAddress.getByName(logServer);
	}
	catch (Exception e) {
	    e.printStackTrace();
	}
    }

    public void sendLog(String target, String lastIP, String nextIP) {

	try {
	    // send request
	    String send = target + "," + lastIP + "," + nextIP;
	    byte[] buf = send.getBytes();

	    DatagramPacket packet = new DatagramPacket(buf, buf.length, 
						       ls, 4445);
	    socket.send(packet);
	}
	catch (Exception e) {
	    e.printStackTrace();
	}
    }

    public static void main(String[] args) throws IOException {

        if (args.length != 1) {
             System.out.println("Usage: java  <hostname>");
             return;
        }

	LogSender logger = new LogSender(args[0]);
	logger.sendLog("target1", "lastIP1", "nextIP");
	logger.sendLog("target2", "lastIP2", "nextIP");
	logger.sendLog("target3", "lastIP3", "nextIP");
	logger.sendLog("target4", "lastIP4", "nextIP");
    }
}
